/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.upgrade;

import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$TASKS$;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.NextCustomScriptTaskJob$;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.ResultSet;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u0007\u000f\u0001eA\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tw\u0001\u0011\t\u0011)A\u0005_!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011!)\u0005A!b\u0001\n\u00031\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00119\u0003!Q1A\u0005\u0002=C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\u0006a\u0002!\t%\u001d\u0005\u0006k\u0002!\tE\u001e\u0005\u0006{\u0002!IA \u0002\u0013#V,W/\u001a3UCN\\7/\u00169he\u0006$WM\u0003\u0002\u0010!\u00059Q\u000f]4sC\u0012,'BA\t\u0013\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e&!\tY2%D\u0001\u001d\u0015\tyQD\u0003\u0002\u001f?\u0005\u0019\u0011\r]5\u000b\u0005\u0001\n\u0013AB:feZ,'O\u0003\u0002#)\u0005AA-\u001a9m_fLG/\u0003\u0002%9\t9Q\u000b]4sC\u0012,\u0007C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Q\u0013\u0001C4sSjTH.\u001a3\n\u00051:#a\u0002'pO\u001eLgnZ\u0001\rU\u0012\u00147\rV3na2\fG/Z\u000b\u0002_A\u0011\u0001'O\u0007\u0002c)\u0011!gM\u0001\u0005G>\u0014XM\u0003\u00025k\u0005!!\u000e\u001a2d\u0015\t1t'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0014aA8sO&\u0011!(\r\u0002\r\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u000eU\u0012\u00147\rV3na2\fG/\u001a\u0011\u0002\u001dI,G.Z1tKN+'O^5dKV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002B%\u000591/\u001a:wS\u000e,\u0017BA\"A\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqB]3mK\u0006\u001cXmU3sm&\u001cW\rI\u0001\u000eU>\u0014'+\u001a9pg&$xN]=\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002M\u0013\ni!j\u001c2SKB|7/\u001b;pef\faB[8c%\u0016\u0004xn]5u_JL\b%\u0001\buCN\\'+\u001a9pg&$xN]=\u0016\u0003A\u0003\"!U*\u000e\u0003IS!A\u0013\n\n\u0005Q\u0013&A\u0004+bg.\u0014V\r]8tSR|'/_\u0001\u0010i\u0006\u001c8NU3q_NLGo\u001c:zA\u00051A(\u001b8jiz\"R\u0001\u0017.jU.\u0004\"!\u0017\u0001\u000e\u00039AQ!L\u0005A\u0002=BCA\u0017/gOB\u0011Q\fZ\u0007\u0002=*\u0011q\fY\u0001\u000bC:tw\u000e^1uS>t'BA1c\u0003\u001d1\u0017m\u0019;pefT!aY\u001b\u0002\u000b\t,\u0017M\\:\n\u0005\u0015t&!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005A\u0017!\u0007=meJ+\u0007o\\:ji>\u0014\u0018P\u00133cGR+W\u000e\u001d7bi\u0016DQ\u0001P\u0005A\u0002yBQ!R\u0005A\u0002\u001dCQAT\u0005A\u0002AC#!C7\u0011\u0005us\u0017BA8_\u0005%\tU\u000f^8xSJ,G-\u0001\bva\u001e\u0014\u0018\rZ3WKJ\u001c\u0018n\u001c8\u0015\u0003I\u0004\"aG:\n\u0005Qd\"a\u0002,feNLwN\\\u0001\nI>,\u0006o\u001a:bI\u0016$\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0002u\u0006)1oY1mC&\u0011A0\u001f\u0002\b\u0005>|G.Z1o\u00039)\bo\u001a:bI\u0016\u0014V\r\\3bg\u0016$Ra`A\u0003\u0003?\u00012\u0001_A\u0001\u0013\r\t\u0019!\u001f\u0002\u0005+:LG\u000fC\u0004\u0002\b1\u0001\r!!\u0003\u0002\u0013I,G.Z1tK&#\u0007\u0003BA\u0006\u00033qA!!\u0004\u0002\u0016A\u0019\u0011qB=\u000e\u0005\u0005E!bAA\n1\u00051AH]8pizJ1!a\u0006z\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011qC=\t\u000f\u0005\u0005B\u00021\u0001\u0002$\u00059A/Y:l\u0013\u0012\u001c\bCBA\u0006\u0003K\tI!\u0003\u0003\u0002(\u0005u!aA*fi\u0002")
public class QueuedTasksUpgrade
extends Upgrade
implements Logging {
    private final JdbcTemplate jdbcTemplate;
    private final ReleaseService releaseService;
    private final JobRepository jobRepository;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        QueuedTasksUpgrade queuedTasksUpgrade = this;
        synchronized (queuedTasksUpgrade) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)"10.2.0#1");
    }

    public boolean doUpgrade() {
        this.logger().info((Function0 & Serializable)() -> "Replacing QUEUED tasks with IN_PROGRESS, adding scheduled job or each task");
        Map taskIdsByReleaseId = CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query("SELECT " + Schema$TASKS$.MODULE$.TASK_ID() + " FROM " + Schema$TASKS$.MODULE$.TABLE() + " WHERE " + Schema$TASKS$.MODULE$.STATUS() + " = '" + TaskStatus.QUEUED.value() + "' OR " + Schema$TASKS$.MODULE$.STATUS() + " = '" + TaskStatus.ABORT_SCRIPT_QUEUED.value() + "' OR " + Schema$TASKS$.MODULE$.STATUS() + " = '" + TaskStatus.FAILURE_HANDLER_QUEUED.value() + "'", (RowMapper)new RowMapper<String>(null){

            public String mapRow(ResultSet rs, int rowNum) {
                return rs.getString(1);
            }
        })).asScala().groupBy((Function1 & Serializable)x$1 -> Ids.releaseIdFrom((String)x$1));
        taskIdsByReleaseId.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String releaseId = (String)tuple2._1();
                Buffer taskIds = (Buffer)tuple2._2();
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.upgradeRelease(releaseId, (Set<String>)taskIds.toSet())).recover((PartialFunction)new Serializable(this, releaseId){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ QueuedTasksUpgrade $outer;
                    private final String releaseId$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                        A1 A1 = e;
                        this.$outer.logger().error((Function0 & Serializable)() -> "Unable to process release " + $this.releaseId$1 + ", giving up", (Function0 & Serializable)() -> e);
                        return (B1)BoxedUnit.UNIT;
                    }

                    public final boolean isDefinedAt(Throwable e) {
                        Throwable throwable = e;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.releaseId$1 = releaseId$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.upgrade.QueuedTasksUpgrade$$anonfun$$nestedInanonfun$doUpgrade$3$1 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                    }
                });
            }
            throw new MatchError((Object)tuple2);
        });
        this.logger().info((Function0 & Serializable)() -> "Done replacing QUEUED tasks");
        return true;
    }

    private void upgradeRelease(String releaseId, Set<String> taskIds) {
        Release release = this.releaseService().findById(releaseId);
        Seq tasksToUpdate = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)taskIds.contains((Object)Ids.getFolderlessId((String)task.getId()))))).toSeq();
        tasksToUpdate.foreach((Function1 & Serializable)task -> {
            if (!taskIds.contains((Object)Ids.getFolderlessId((String)task.getId()))) return BoxedUnit.UNIT;
            task.generateExecutionId();
            boolean bl = false;
            TaskStatus taskStatus = null;
            boolean bl2 = false;
            TaskStatus taskStatus2 = null;
            TaskStatus taskStatus3 = task.getStatus();
            if (TaskStatus.QUEUED.equals(taskStatus3)) {
                bl = true;
                taskStatus = taskStatus3;
                if (task.shouldFacetBeChecked()) {
                    task.setStatus(TaskStatus.FACET_CHECK_IN_PROGRESS);
                    return this.jobRepository().create(JobRow$.MODULE$.apply(new FacetCheckJob(new TaskSoftReference<Task>((Task)task, () -> task))));
                }
            }
            if (bl && task.shouldPreconditionBeChecked()) {
                task.setStatus(TaskStatus.PRECONDITION_IN_PROGRESS);
                return this.jobRepository().create(JobRow$.MODULE$.apply(new PreconditionJob(new TaskSoftReference<Task>((Task)task, () -> task))));
            }
            if (bl) {
                TaskJob<ResolvableScriptTask> taskJob;
                task.setStatus(TaskStatus.IN_PROGRESS);
                JobRepository jobRepository = this.jobRepository();
                boolean bl3 = false;
                CustomScriptTask customScriptTask = null;
                Task task2 = task;
                if (task2 instanceof ResolvableScriptTask) {
                    ResolvableScriptTask resolvableScriptTask = (ResolvableScriptTask)task2;
                    taskJob = new ScriptTaskJob(new TaskSoftReference<ResolvableScriptTask>(resolvableScriptTask, () -> resolvableScriptTask));
                    return jobRepository.create(JobRow$.MODULE$.apply(taskJob));
                }
                if (task2 instanceof CustomScriptTask) {
                    bl3 = true;
                    customScriptTask = (CustomScriptTask)task2;
                    if (customScriptTask.hasNextScriptToExecute()) {
                        taskJob = NextCustomScriptTaskJob$.MODULE$.apply(new TaskSoftReference<CustomScriptTask>(customScriptTask, () -> customScriptTask), (Duration)Duration$.MODULE$.Zero());
                        return jobRepository.create(JobRow$.MODULE$.apply(taskJob));
                    }
                }
                if (bl3) {
                    taskJob = new CustomScriptTaskJob(new TaskSoftReference<CustomScriptTask>(customScriptTask, () -> customScriptTask));
                    return jobRepository.create(JobRow$.MODULE$.apply(taskJob));
                }
                if (task2 instanceof CreateReleaseTask) {
                    CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
                    taskJob = new CreateReleaseTaskJob(new TaskSoftReference<CreateReleaseTask>(createReleaseTask, () -> createReleaseTask));
                    return jobRepository.create(JobRow$.MODULE$.apply(taskJob));
                }
                if (!(task2 instanceof NotificationTask)) throw new MatchError((Object)task2);
                NotificationTask notificationTask = (NotificationTask)task2;
                taskJob = new NotificationTaskJob(new TaskSoftReference<NotificationTask>(notificationTask, () -> notificationTask));
                return jobRepository.create(JobRow$.MODULE$.apply(taskJob));
            }
            if (TaskStatus.ABORT_SCRIPT_QUEUED.equals(taskStatus3)) {
                bl2 = true;
                taskStatus2 = taskStatus3;
                if (((CustomScriptTask)task).hasNextScriptToExecute()) {
                    task.setStatus(TaskStatus.ABORT_SCRIPT_IN_PROGRESS);
                    return this.jobRepository().create(JobRow$.MODULE$.apply(NextCustomScriptTaskJob$.MODULE$.apply(new TaskSoftReference<CustomScriptTask>((CustomScriptTask)task, () -> (CustomScriptTask)task), (Duration)Duration$.MODULE$.Zero())));
                }
            }
            if (bl2) {
                task.setStatus(TaskStatus.ABORT_SCRIPT_IN_PROGRESS);
                return this.jobRepository().create(JobRow$.MODULE$.apply(new CustomScriptTaskJob(new TaskSoftReference<CustomScriptTask>((CustomScriptTask)task, () -> (CustomScriptTask)task))));
            }
            if (!TaskStatus.FAILURE_HANDLER_QUEUED.equals(taskStatus3)) return BoxedUnit.UNIT;
            task.setStatus(TaskStatus.FAILURE_HANDLER_IN_PROGRESS);
            return this.jobRepository().create(JobRow$.MODULE$.apply(new FailureHandlerJob(new TaskSoftReference<Task>((Task)task, () -> task))));
        });
        this.taskRepository().updateTasks((Seq<Task>)tasksToUpdate);
    }

    @Autowired
    public QueuedTasksUpgrade(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, ReleaseService releaseService, JobRepository jobRepository, TaskRepository taskRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.releaseService = releaseService;
        this.jobRepository = jobRepository;
        this.taskRepository = taskRepository;
        Logging.$init$((Logging)this);
    }
}

