package com.xebialabs.xlrelease.security;

import javax.servlet.http.HttpSessionEvent;
import org.springframework.security.web.session.HttpSessionEventPublisher;

import com.xebialabs.deployit.ServerConfiguration;

public class HttpSessionListenerWithTimeout extends HttpSessionEventPublisher {

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        super.sessionCreated(event);

        int sessionTimeoutInSeconds = ServerConfiguration.getInstance().getClientSessionTimeoutMinutes() * 60;
        event.getSession().setMaxInactiveInterval(sessionTimeoutInSeconds);
    }
}
