package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.{Comment, Task}
import org.joda.time.DateTime

trait CommentRepository {

  def exists(commentId: String): Boolean

  def create(created: Comment): Boolean

  def createAll(taskId: String, comments: Seq[Comment]): Int

  def update(commentId: String, content: String, modified: Option[DateTime]): Boolean

  def update(commentId: String, content: String): Boolean = update(commentId, content, None)

  def findById(commentId: String): Comment

  def findByTask(taskId: String): Seq[Comment]

  def decorate(task: Task): Task

  def delete(comment: Comment): Unit

  def deleteByTask(task: Task): Unit

}
