/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.FacetConfiguredFacetsCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FacetUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.FacetScope;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseVariableRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FacetConfigurationService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tUa\u0001\u0002\r\u001a\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003u\u0001\u0011\u0005Q\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u000511\u0015mY3u'\u0016\u0014h/[2f\u0015\tQ2$A\u0004tKJ4\u0018nY3\u000b\u0005qi\u0012!\u0003=me\u0016dW-Y:f\u0015\tqr$A\u0005yK\nL\u0017\r\\1cg*\t\u0001%A\u0002d_6\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0013\u0001C4sSjTH.\u001a3\n\u0005AZ#a\u0002'pO\u001eLgnZ\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000f\u0005\u00024m5\tAG\u0003\u000267\u0005Q!/\u001a9pg&$xN]=\n\u0005]\"$!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\fa\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00024u%\u00111\b\u000e\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001 B\u001b\u0005y$B\u0001!\u001c\u0003\u0019)g/\u001a8ug&\u0011!i\u0010\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\t)e)D\u0001\u001a\u0013\t9\u0015D\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005MR\u0015BA&5\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002F\u001d&\u0011q*\u0007\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\nwCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\bCA\u001aS\u0013\t\u0019FGA\rSK2,\u0017m]3WCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\u0018a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007C\u0001,Z\u001b\u00059&B\u0001-\u001c\u0003\u0019\t7\r^8sg&\u0011!l\u0016\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0012i\u0006\u001c8.Q2dKN\u001c8+\u001a:wS\u000e,\u0007CA#^\u0013\tq\u0016DA\tUCN\\\u0017iY2fgN\u001cVM\u001d<jG\u0016\f\u0011DZ1dKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dKB\u0011Q)Y\u0005\u0003Ef\u0011\u0011DR1dKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK\"\"!\u0002\u001a:t!\t)\u0007/D\u0001g\u0015\t9\u0007.\u0001\u0006b]:|G/\u0019;j_:T!!\u001b6\u0002\u000f\u0019\f7\r^8ss*\u00111\u000e\\\u0001\u0006E\u0016\fgn\u001d\u0006\u0003[:\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002_\u0006\u0019qN]4\n\u0005E4'!C!vi><\u0018N]3e\u0003!\u0011X-];je\u0016$\u0017$\u0001\u0001\u0002\rqJg.\u001b;?)11x\u000f_={wrlhp`A\u0001!\t)\u0005\u0001C\u00032\u0017\u0001\u0007!\u0007C\u00039\u0017\u0001\u0007\u0011\bC\u0003=\u0017\u0001\u0007Q\bC\u0003D\u0017\u0001\u0007A\tC\u0003I\u0017\u0001\u0007\u0011\nC\u0003M\u0017\u0001\u0007Q\nC\u0003Q\u0017\u0001\u0007\u0011\u000bC\u0003U\u0017\u0001\u0007Q\u000bC\u0003\\\u0017\u0001\u0007A\fC\u0003`\u0017\u0001\u0007\u0001\rK\u0003\u0002\u0002\u0011\u00148\u000f\u000b\u0002\fI\u0006\u0019q-\u001a;\u0015\t\u0005-\u00111\u0004\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u00151\u0017mY3u\u0015\r\t)bG\u0001\u0007I>l\u0017-\u001b8\n\t\u0005e\u0011q\u0002\u0002\u0006\r\u0006\u001cW\r\u001e\u0005\b\u0003;a\u0001\u0019AA\u0010\u0003\u001d1\u0017mY3u\u0013\u0012\u0004B!!\t\u000209!\u00111EA\u0016!\r\t)#J\u0007\u0003\u0003OQ1!!\u000b\"\u0003\u0019a$o\\8u}%\u0019\u0011QF\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$a\r\u0003\rM#(/\u001b8h\u0015\r\ti#\n\u0015\u0004\u0019\u0005]\u0002\u0003BA\u001d\u0003\u000bj!!a\u000f\u000b\u0007\u001d\fiD\u0003\u0003\u0002@\u0005\u0005\u0013aB7fiJL7m\u001d\u0006\u0004\u0003\u0007z\u0012\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005\u001d\u00131\b\u0002\u0006)&lW\rZ\u0001\u0017C\u0012$G+Y:l%\u0016\u0004xN\u001d;j]\u001e\u0014VmY8sIR1\u0011QJA2\u0003O\u0002b!a\u0014\u0002Z\u0005uSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003/\nAA[1wC&!\u00111LA)\u0005\u0011a\u0015n\u001d;\u0011\t\u00055\u0011qL\u0005\u0005\u0003C\nyAA\nUCN\\'+\u001a9peRLgn\u001a*fG>\u0014H\rC\u0004\u0002f5\u0001\r!!\u0018\u0002\rI,7m\u001c:e\u0011\u001d\tI'\u0004a\u0001\u0003W\n1#\u00199qYf$\u0016m]6BiR\u0014\u0018NY;uKN\u00042\u0001JA7\u0013\r\ty'\n\u0002\b\u0005>|G.Z1oQ\ri\u0011qG\u0001\u0007GJ,\u0017\r^3\u0015\t\u0005-\u0011q\u000f\u0005\b\u0003#q\u0001\u0019AA\u0006Q\rq\u0011qG\u0001\u001cGJ,\u0017\r^3BaBd\u00170\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\r\u00055\u0013qPAA\u0011\u001d\t\tb\u0004a\u0001\u0003;Bq!a!\u0010\u0001\u0004\tY'\u0001\nde\u0016\fG/Z+oG>tg-[4ve\u0016$\u0007fA\b\u00028\u00051A-\u001a7fi\u0016$B!a#\u0002\u0012B\u0019A%!$\n\u0007\u0005=UE\u0001\u0003V]&$\bbBA\u000f!\u0001\u0007\u0011q\u0004\u0015\u0004!\u0005]\u0012AB;qI\u0006$X\r\u0006\u0003\u0002\f\u0005e\u0005bBA\t#\u0001\u0007\u00111\u0002\u0015\u0004#\u0005]\u0012aC5t\u00136lW\u000f^1cY\u0016$B!a\u001b\u0002\"\"9\u0011\u0011\u0003\nA\u0002\u0005-\u0001f\u0001\n\u00028\u000511/Z1sG\"$B!!+\u0002,B1\u0011qJA-\u0003\u0017Aq!!,\u0014\u0001\u0004\ty+A\u0004gS2$XM]:\u0011\t\u0005E\u0016qX\u0007\u0003\u0003gSA!!.\u00028\u0006)am\u001c:ng*!\u0011\u0011XA^\u0003\t1\u0018GC\u0002\u0002>n\t1!\u00199j\u0013\u0011\t\t-a-\u0003\u0019\u0019\u000b7-\u001a;GS2$XM]:)\u0007M\t9$\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003W\nI\rC\u0004\u0002\u001eQ\u0001\r!a\b)\u0007Q\t9$\u0001\nde\u0016\fG/\u001a(foZ\u000b'/[1cY\u0016\u001cHCBAF\u0003#\fi\u000eC\u0004\u0002TV\u0001\r!!6\u0002\u000fI,G.Z1tKB!\u0011q[Am\u001b\t\t\u0019\"\u0003\u0003\u0002\\\u0006M!a\u0002*fY\u0016\f7/\u001a\u0005\b\u0003#)\u0002\u0019AA\u0006\u000359W\r\u001e$bG\u0016$H+\u001f9fgR!\u00111]A~!\u0019\ty%!\u0017\u0002fB!\u0011q]A|\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018a\u0002:fM2,7\r\u001e\u0006\u0005\u0003{\u000byO\u0003\u0003\u0002r\u0006M\u0018A\u00029mk\u001eLgNC\u0002\u0002vv\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003s\fIO\u0001\u0006EKN\u001c'/\u001b9u_JDq!!@\u0017\u0001\u0004\ty\"\u0001\u0005cCN,G+\u001f9fQ\r1\u0012qG\u0001\tm\u0006d\u0017\u000eZ1uKR!\u00111\u0012B\u0003\u0011\u001d\t\tb\u0006a\u0001\u0003\u0017A3\u0001\u0001B\u0005!\u0011\u0011YA!\u0005\u000e\u0005\t5!b\u0001B\bY\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\tM!Q\u0002\u0002\b'\u0016\u0014h/[2f\u0001")
public class FacetService
implements Logging {
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final ReleaseActorService releaseActorService;
    private final TaskAccessService taskAccessService;
    @Autowired(required=false)
    private final FacetConfigurationService facetConfigurationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FacetService facetService = this;
        synchronized (facetService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Facet get(String facetId) {
        return this.facetRepositoryDispatcher.get(facetId, this.facetRepositoryDispatcher.get$default$2());
    }

    @Timed
    public List<TaskReportingRecord> addTaskReportingRecord(TaskReportingRecord record, boolean applyTaskAttributes) {
        return applyTaskAttributes ? this.createApplyingConfiguration(record, true) : Collections.singletonList((TaskReportingRecord)this.create((Facet)record));
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet create(Facet facet) {
        void var3_3;
        this.validate(facet);
        Object task = this.taskRepository.findById(facet.getTargetId(), ResolveOptions$.MODULE$.WITH_DECORATORS());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        facet.setId(Ids.getName((String)this.ciIdService.getUniqueId(Type.valueOf(Facet.class), "")));
        Facet createdFacet = this.facetRepositoryDispatcher.create(facet);
        this.createNewVariables(task.getRelease(), createdFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetCreatedEvent(createdFacet));
        return var3_3;
    }

    @Timed
    public List<TaskReportingRecord> createApplyingConfiguration(TaskReportingRecord facet2, boolean createUnconfigured) {
        List list;
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = this.facetConfigurationService != null ? this.facetConfigurationService.configureFacet(facet2) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TaskReportingRecord[]{facet2})));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean hasConfiguration = tuple2._1$mcZ$sp();
        scala.collection.immutable.Seq facets = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasConfiguration), (Object)facets);
        Tuple2 tuple24 = tuple23;
        boolean hasConfiguration2 = tuple24._1$mcZ$sp();
        scala.collection.immutable.Seq facets2 = (scala.collection.immutable.Seq)tuple24._2();
        if (createUnconfigured || hasConfiguration2) {
            facets2.foreach((Function1 & Serializable)facet -> this.create((Facet)facet));
            this.eventBus.publish((XLReleaseEvent)new FacetConfiguredFacetsCreatedEvent(facet2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets2).asJava(), hasConfiguration2));
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets2).asJava();
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    @Timed
    public void delete(String facetId) {
        Facet facet = this.facetRepositoryDispatcher.get(facetId, this.facetRepositoryDispatcher.get$default$2());
        TaskBasicData taskBasicData = this.taskRepository.findTaskBasicData(facet.getTargetId());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTaskType(taskBasicData.taskType());
        this.facetRepositoryDispatcher.delete(facetId, this.facetRepositoryDispatcher.delete$default$2());
        this.eventBus.publish((XLReleaseEvent)new FacetDeletedEvent(facet));
    }

    @Timed
    public Facet update(Facet facet) {
        this.validate(facet);
        Object task = this.taskRepository.findById(facet.getTargetId(), ResolveOptions$.MODULE$.WITH_DECORATORS());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        Facet originalFacet = this.facetRepositoryDispatcher.get(facet.getId(), this.facetRepositoryDispatcher.get$default$2());
        Facet updatedFacet = this.facetRepositoryDispatcher.update(facet);
        this.createNewVariables(task.getRelease(), updatedFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetUpdatedEvent(originalFacet, updatedFacet));
        return updatedFacet;
    }

    @Timed
    public boolean isImmutable(Facet facet) {
        return facet.getType().instanceOf(Type.valueOf(TaskReportingRecord.class));
    }

    @Timed
    public List<Facet> search(FacetFilters filters) {
        List list;
        String containerId;
        filters.setTypes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Option$.MODULE$.apply((Object)filters.getTypes()).map((Function1 & Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().flatMap((Function1 & Serializable)ciType -> TypeHelper$.MODULE$.getAllSubtypesOf(ciType))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).asJava());
        String string = containerId = filters.getParentId() != null ? filters.getParentId() : filters.getTargetId();
        if (this.archivingService.exists(Ids.releaseIdFrom((String)containerId))) {
            this.logger().debug((Function0 & Serializable)() -> "Search in ARCHIVE for " + filters.getParentId() + "/" + filters.getTargetId() + "/" + filters.getTypes());
            list = CollectionConverters$.MODULE$.SeqHasAsJava(((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.archiveRepository())).search(filters)).asJava();
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Search in LIVE for " + filters.getParentId() + "/" + filters.getTargetId() + "/" + filters.getTypes());
            list = CollectionConverters$.MODULE$.SeqHasAsJava(((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).search(filters)).asJava();
        }
        return list;
    }

    @Timed
    public boolean exists(String facetId) {
        return this.facetRepositoryDispatcher.exists(facetId, this.facetRepositoryDispatcher.exists$default$2());
    }

    private void createNewVariables(Release release, Facet facet) {
        block0: {
            Buffer newVariables = CollectionConverters$.MODULE$.ListHasAsScala(VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)facet, this.ciIdService)).asScala();
            if (!newVariables.nonEmpty()) break block0;
            newVariables.foreach((Function1 & Serializable)v -> $this.releaseActorService.createVariable((Variable)v, release.getId()));
        }
    }

    @Timed
    public List<Descriptor> getFacetTypes(String baseType) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf((String)baseType))).asScala().map((Function1 & Serializable)x$3 -> x$3.getDescriptor())).filter((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$2(desc)))).filterNot((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$3(desc)))).toList().sortBy((Function1 & Serializable)x$4 -> x$4.getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private void validate(Facet facet) {
        FacetScope facetScope = facet.getScope();
        if (!FacetScope.TASK.equals(facetScope)) {
            throw new IllegalArgumentException("Target type " + facet.getScope() + " is not supported.");
        }
        Checks.checkArgument((boolean)Ids.isTaskId((String)facet.getTargetId()), (String)"Target ID is not a valid task ID.", (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(facet.getTargetId()), (String)("Task with the ID '" + facet.getTargetId() + "' does not exist or has been archived."), (Object[])new Object[0]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$2(Descriptor desc) {
        return !desc.isVirtual();
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$3(Descriptor desc) {
        return desc.getType().instanceOf(Type.valueOf(TaskReportingRecord.class));
    }

    @Autowired
    public FacetService(FacetRepositoryDispatcher facetRepositoryDispatcher, TaskRepository taskRepository, XLReleaseEventBus eventBus, ArchivingService archivingService, ReleaseRepository releaseRepository, CiIdService ciIdService, ReleaseVariableRepository variableRepository, ReleaseActorService releaseActorService, TaskAccessService taskAccessService, @Autowired(required=false) FacetConfigurationService facetConfigurationService) {
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.releaseActorService = releaseActorService;
        this.taskAccessService = taskAccessService;
        this.facetConfigurationService = facetConfigurationService;
        Logging.$init$((Logging)this);
    }
}

