/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.authentication.policy.UserProfileCreationPolicy;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0005\t4AAB\u0004\u0001!!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015\u0011\u0006\u0001\"\u0003T\u0005\t\nU\u000f\u001e5f]RL7-\u0019;j_:\u001cVoY2fgN,e/\u001a8u\u0019&\u001cH/\u001a8fe*\u0011\u0001\"C\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tQ1\"A\u0005yYJ,G.Z1tK*\u0011A\"D\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AD\u0001\u0004G>l7\u0001A\n\u0004\u0001EI\u0002C\u0001\n\u0018\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003\u0011a\u0017M\\4\u000b\u0003Y\tAA[1wC&\u0011\u0001d\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007i\t3%D\u0001\u001c\u0015\taR$A\u0004d_:$X\r\u001f;\u000b\u0005yy\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u00113DA\nBaBd\u0017nY1uS>tG*[:uK:,'\u000f\u0005\u0002%U5\tQE\u0003\u0002'O\u0005)QM^3oi*\u0011\u0001\u0002\u000b\u0006\u0003Su\t\u0001b]3dkJLG/_\u0005\u0003W\u0015\u0012!$Q;uQ\u0016tG/[2bi&|gnU;dG\u0016\u001c8/\u0012<f]R\f1$^:feB\u0013xNZ5mK\u000e\u0013X-\u0019;j_:\u0004v\u000e\\5dS\u0016\u001c\bc\u0001\u00182g5\tqF\u0003\u00021+\u0005!Q\u000f^5m\u0013\t\u0011tF\u0001\u0003MSN$\bC\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0019\u0001x\u000e\\5ds*\u0011\u0001\u0002\u000f\u0006\u0003S%I!AO\u001b\u00033U\u001bXM\u001d)s_\u001aLG.Z\"sK\u0006$\u0018n\u001c8Q_2L7-_\u0001\u0013a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\u0005\u0002>\u00036\taH\u0003\u0002*\u007f)\u0011\u0001iC\u0001\tI\u0016\u0004Hn\\=ji&\u0011!I\u0010\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/\u0001\u0004=S:LGO\u0010\u000b\u0004\u000b\u001eC\u0005C\u0001$\u0001\u001b\u00059\u0001\"\u0002\u0017\u0004\u0001\u0004i\u0003\"B\u001e\u0004\u0001\u0004a\u0014AE8o\u0003B\u0004H.[2bi&|g.\u0012<f]R$\"aS)\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\tUs\u0017\u000e\u001e\u0005\u0006M\u0011\u0001\raI\u0001\u0015M&tG-\u00119qY&\u001c\u0017M\u00197f!>d\u0017nY=\u0015\u0005M\"\u0006\"\u0002\u0005\u0006\u0001\u0004)\u0006C\u0001,Z\u001b\u00059&B\u0001-)\u0003\u0011\u0019wN]3\n\u0005i;&AD!vi\",g\u000e^5dCRLwN\u001c\u0015\u0003\u0001q\u0003\"!\u00181\u000e\u0003yS!aX\u000f\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002b=\nI1i\\7q_:,g\u000e\u001e")
public class AuthenticationSuccessEventListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private final List<UserProfileCreationPolicy> userProfileCreationPolicies;
    private final PermissionEnforcer permissionEnforcer;

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        block1: {
            Authentication authentication = event.getAuthentication();
            if (authentication == null || !Strings.isNotEmpty((String)authentication.getName())) break block1;
            boolean hasLoginPermission = this.permissionEnforcer.hasPermission(authentication, new Permission[]{PlatformPermissions.LOGIN});
            if (!hasLoginPermission) {
                throw new DisabledException("The user " + authentication.getName() + " or its group(s) do not have login permission");
            }
            UserProfileCreationPolicy creationPolicy = this.findApplicablePolicy(authentication);
            creationPolicy.createProfile(authentication);
        }
    }

    private UserProfileCreationPolicy findApplicablePolicy(Authentication authentication) {
        return (UserProfileCreationPolicy)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userProfileCreationPolicies).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.policyApplies(authentication))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No UserProfile creation policy applicable for authentication [" + authentication + "]");
        });
    }

    public AuthenticationSuccessEventListener(List<UserProfileCreationPolicy> userProfileCreationPolicies, PermissionEnforcer permissionEnforcer) {
        this.userProfileCreationPolicies = userProfileCreationPolicies;
        this.permissionEnforcer = permissionEnforcer;
    }
}

