package com.xebialabs.xlrelease.security.authentication;

import java.util.Collection;
import java.util.Collections;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;
import org.springframework.util.Assert;

@Transient
public class RunnerAuthenticationToken extends AbstractAuthenticationToken {

    private final String principal;

    private String token;

    public RunnerAuthenticationToken(String token) {
        super(Collections.emptyList());
        Assert.hasText(token, "token cannot be empty");
        this.principal = null;
        this.token = token;
        setAuthenticated(false);
    }

    public RunnerAuthenticationToken(String principal, String token, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        Assert.hasText(principal, "principal cannot be empty");
        Assert.hasText(token, "token cannot be empty");
        this.principal = principal;
        this.token = token;
        setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return this.token;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }

    @Override
    public void eraseCredentials() {
        super.eraseCredentials();
        this.token = null;
    }
}
