package com.xebialabs.xlrelease.events

import javax.annotation.{PostConstruct, PreDestroy}

// used for testing
private[this] trait EventListening {

  def eventBus: XLReleaseEventBus

  @PostConstruct
  def postConstruct(): Unit = {
    eventBus.register(this)
  }

  @PreDestroy
  def preDestroy(): Unit = {
    eventBus.deregister(this)
  }

}
