/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.TeamsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService$FolderAndEvents$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011-d\u0001B+W\u0001}C\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\tk\u0002\u0011\t\u0011)A\u0005m\"A!\u0010\u0001B\u0001B\u0003%1\u0010\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003\u0000\u0011)\t)\u0001\u0001B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001BCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005-\u0002A!A!\u0002\u0013\ti\u0003\u0003\u0006\u0002:\u0001\u0011\t\u0011)A\u0005\u0003wAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0001\u0002^!A\u0011q\u000e\u0001!\u0002\u0013\ty\u0006C\u0005\u0002r\u0001\u0011\r\u0011\"\u0001\u0002^!A\u00111\u000f\u0001!\u0002\u0013\ty\u0006C\u0005\u0002v\u0001\u0011\r\u0011\"\u0001\u0002^!A\u0011q\u000f\u0001!\u0002\u0013\ty\u0006C\u0005\u0002z\u0001\u0011\r\u0011\"\u0001\u0002^!A\u00111\u0010\u0001!\u0002\u0013\ty\u0006C\u0004\u0002~\u0001!\t!a \t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\n\u0003[\u0004\u0011\u0013!C\u0001\u0003_DqAa\u0001\u0001\t\u0003\u0011)\u0001C\u0005\u0003\u0012\u0001\t\n\u0011\"\u0001\u0002p\"I!1\u0003\u0001\u0012\u0002\u0013\u0005!Q\u0003\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011%\u0011Y\u0003AI\u0001\n\u0003\u0011i\u0003C\u0004\u00032\u0001!\tAa\r\t\u0013\t]\u0003!%A\u0005\u0002\tU\u0001\"\u0003B-\u0001E\u0005I\u0011\u0001B\u000b\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0005;BqAa\u001a\u0001\t\u0003\u0011I\u0007C\u0004\u0003t\u0001!\tA!\u001e\t\u0013\t%\u0005!%A\u0005\u0002\tU\u0001b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\n\u0005s\u0003\u0011\u0013!C\u0001\u0005wCqAa0\u0001\t\u0003\u0011\t\rC\u0005\u0003P\u0002\t\n\u0011\"\u0001\u0003\u0016!9!\u0011\u001b\u0001\u0005\u0002\tM\u0007b\u0002Bi\u0001\u0011\u0005!1\u001c\u0005\b\u0005O\u0004A\u0011\u0002Bu\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005c4aAa=\u0001\u0001\nU\bBCAk[\tU\r\u0011\"\u0001\u0004\u0010!Q1\u0011C\u0017\u0003\u0012\u0003\u0006I!a4\t\u0015\u0005MRF!f\u0001\n\u0003\u0019\u0019\u0002\u0003\u0006\u0004&5\u0012\t\u0012)A\u0005\u0007+Aq!!\u0011.\t\u0003\u00199\u0003C\u0005\u000425\n\t\u0011\"\u0001\u00044!I1\u0011H\u0017\u0012\u0002\u0013\u000511\b\u0005\n\u0007\u007fi\u0013\u0013!C\u0001\u0007\u0003B\u0011b!\u0012.\u0003\u0003%\t%!\u0018\t\u0013\r\u001dS&!A\u0005\u0002\r%\u0003\"CB&[\u0005\u0005I\u0011AB'\u0011%\u0019I&LA\u0001\n\u0003\u001aY\u0006C\u0005\u0004j5\n\t\u0011\"\u0001\u0004l!I1qN\u0017\u0002\u0002\u0013\u00053\u0011\u000f\u0005\n\u0007kj\u0013\u0011!C!\u0005cD\u0011ba\u001e.\u0003\u0003%\te!\u001f\t\u0013\rmT&!A\u0005B\rut!CBA\u0001\u0005\u0005\t\u0012ABB\r%\u0011\u0019\u0010AA\u0001\u0012\u0003\u0019)\tC\u0004\u0002B\u0001#\ta!(\t\u0013\r]\u0004)!A\u0005F\re\u0004\"CBP\u0001\u0006\u0005I\u0011QBQ\u0011%\u00199\u000bQI\u0001\n\u0003\u0019\t\u0005C\u0005\u0004*\u0002\u000b\t\u0011\"!\u0004,\"I1Q\u0018!\u0012\u0002\u0013\u00051\u0011\t\u0005\b\u0007\u007f\u0003A\u0011ABa\u0011\u001d\u0019I\r\u0001C\u0001\u0007\u0017Dqa!5\u0001\t\u0013\u0019\u0019\u000eC\u0004\u0004^\u0002!Iaa8\t\u000f\rE\b\u0001\"\u0003\u0004t\"91\u0011 \u0001\u0005\n\rm\bb\u0002C\u0002\u0001\u0011%AQ\u0001\u0005\b\t\u0013\u0001A\u0011\u0002C\u0006\u0011\u001d!)\u0002\u0001C\u0001\t/Aq\u0001\"\r\u0001\t\u0013!\u0019\u0004C\u0004\u0005B\u0001!I\u0001b\u0011\t\u000f\u0011]\u0003\u0001\"\u0003\u0005Z!9Aq\f\u0001\u0005\n\u0011\u0005\u0004b\u0002C3\u0001\u0011%Aq\r\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u000b\u0005]C\u0016aB:feZL7-\u001a\u0006\u00033j\u000b\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005mc\u0016!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0016aA2p[\u000e\u00011c\u0001\u0001aMB\u0011\u0011\rZ\u0007\u0002E*\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\n1\u0011I\\=SK\u001a\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\u000bMdg\r\u000e6\u000b\u0003-\f\u0001b\u001a:jujdW\rZ\u0005\u0003[\"\u0014q\u0001T8hO&tw-A\u0004g_2$WM]:\u0011\u0005A\u001cX\"A9\u000b\u0005ID\u0016A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011A/\u001d\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pef\f1\u0002^3b[N+'O^5dKB\u0011q\u000f_\u0007\u0002-&\u0011\u0011P\u0016\u0002\f)\u0016\fWnU3sm&\u001cW-A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"\u0001\u001d?\n\u0005u\f(!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006YA/Y:l'\u0016\u0014h/[2f!\r9\u0018\u0011A\u0005\u0004\u0003\u00071&a\u0003+bg.\u001cVM\u001d<jG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0007A\fI!C\u0002\u0002\fE\u0014qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002\u0017\rL\u0017\nZ*feZL7-\u001a\t\u0004o\u0006E\u0011bAA\n-\nY1)[%e'\u0016\u0014h/[2f\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKB\u0019q/!\u0007\n\u0007\u0005maK\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\fa\u0016\u0014X.[:tS>t7\u000f\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)\u0003W\u0001\tg\u0016\u001cWO]5us&!\u0011\u0011FA\u0012\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\tKZ,g\u000e\u001e\"vgB!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024a\u000ba!\u001a<f]R\u001c\u0018\u0002BA\u001c\u0003c\u0011\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003A\t'o\u00195jm&twmU3sm&\u001cW\rE\u0002x\u0003{I1!a\u0010W\u0005A\t%o\u00195jm&twmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003\u000b\n9%!\u0013\u0002L\u00055\u0013qJA)\u0003'\n)&a\u0016\u0002ZA\u0011q\u000f\u0001\u0005\u0006].\u0001\ra\u001c\u0005\u0006k.\u0001\rA\u001e\u0005\u0006u.\u0001\ra\u001f\u0005\u0006}.\u0001\ra \u0005\b\u0003\u000bY\u0001\u0019AA\u0004\u0011\u001d\tia\u0003a\u0001\u0003\u001fAq!!\u0006\f\u0001\u0004\t9\u0002C\u0004\u0002\u001e-\u0001\r!a\b\t\u000f\u0005-2\u00021\u0001\u0002.!9\u0011\u0011H\u0006A\u0002\u0005m\u0012!B*M\u0003NCUCAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nA\u0001\\1oO*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002n\u0005\r$AB*ue&tw-\u0001\u0004T\u0019\u0006\u001b\u0006\nI\u0001\r'2\u000b5\u000bS0G\u001f2#UIU\u0001\u000e'2\u000b5\u000bS0G\u001f2#UI\u0015\u0011\u0002\u0017QK\u0006+R0M\u00136KEkU\u0001\r)f\u0003Vi\u0018'J\u001b&#6\u000bI\u0001\u0011\u001b\u0006CvLR(M\t\u0016\u0013v\fR#Q)\"\u000b\u0011#T!Y?\u001a{E\nR#S?\u0012+\u0005\u000b\u0016%!\u0003E\u0019\u0007.Z2l\r>dG-\u001a:Fq&\u001cHo\u001d\u000b\u0005\u0003\u0003\u000b9\tE\u0002b\u0003\u0007K1!!\"c\u0005\u0011)f.\u001b;\t\u000f\u0005%E\u00031\u0001\u0002\f\u0006Aam\u001c7eKJLE\r\u0005\u0003\u0002\u000e\u0006me\u0002BAH\u0003/\u00032!!%c\u001b\t\t\u0019JC\u0002\u0002\u0016z\u000ba\u0001\u0010:p_Rt\u0014bAAME\u00061\u0001K]3eK\u001aLA!!\u001c\u0002\u001e*\u0019\u0011\u0011\u00142)\u0007Q\t\t\u000b\u0005\u0003\u0002$\u0006EVBAAS\u0015\u0011\t9+!+\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002,\u00065\u0016aB7fiJL7m\u001d\u0006\u0004\u0003_c\u0016\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005M\u0016Q\u0015\u0002\u0006)&lW\rZ\u0001\u0007KbL7\u000f^:\u0015\t\u0005e\u0016q\u0018\t\u0004C\u0006m\u0016bAA_E\n9!i\\8mK\u0006t\u0007bBAE+\u0001\u0007\u00111\u0012\u0015\u0004+\u0005\u0005\u0016\u0001C4fiRKG\u000f\\3\u0015\t\u0005-\u0015q\u0019\u0005\b\u0003\u00133\u0002\u0019AAFQ\r1\u0012\u0011U\u0001\tM&tGMQ=JIR1\u0011qZAp\u0003C\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.\u0001\u0004g_2$WM\u001d\u0006\u0004\u00033D\u0016A\u00023p[\u0006Lg.\u0003\u0003\u0002^\u0006M'A\u0002$pY\u0012,'\u000fC\u0004\u0002\n^\u0001\r!a#\t\u0013\u0005\rx\u0003%AA\u0002\u0005\u0015\u0018!\u00023faRD\u0007\u0003BA1\u0003OLA!!;\u0002d\t9\u0011J\u001c;fO\u0016\u0014\bfA\f\u0002\"\u0006\u0011b-\u001b8e\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tP\u000b\u0003\u0002f\u0006M8FAA{!\u0011\t90a@\u000e\u0005\u0005e(\u0002BA~\u0003{\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d&-\u0003\u0003\u0003\u0002\u0005e(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069b-\u001b8e-&,w/\u00192mK\u001a{G\u000eZ3sg\nK\u0018\n\u001a\u000b\t\u0003\u001f\u00149A!\u0003\u0003\f!9\u0011\u0011R\rA\u0002\u0005-\u0005\"CAr3A\u0005\t\u0019AAs\u0011%\u0011i!\u0007I\u0001\u0002\u0004\tI,A\tf]\u001a|'oY3QKJl\u0017n]:j_:D3!GAQ\u0003\u00052\u0017N\u001c3WS\u0016<\u0018M\u00197f\r>dG-\u001a:t\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133\u0003\u00052\u0017N\u001c3WS\u0016<\u0018M\u00197f\r>dG-\u001a:t\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u00119B\u000b\u0003\u0002:\u0006M\u0018A\u00034j]\u0012\u0014\u0015\u0010U1uQR1\u0011q\u001aB\u000f\u0005CAqAa\b\u001d\u0001\u0004\tY)\u0001\u0003qCRD\u0007\"CAr9A\u0005\t\u0019\u0001B\u0012!\r\t'QE\u0005\u0004\u0005O\u0011'aA%oi\"\u001aA$!)\u0002)\u0019Lg\u000e\u001a\"z!\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yC\u000b\u0003\u0003$\u0005M\u0018a\u00057jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cHC\u0003B\u001b\u0005\u0003\u0012)Ea\u0014\u0003TA1!q\u0007B\u001f\u0003\u001fl!A!\u000f\u000b\t\tm\u0012qM\u0001\u0005kRLG.\u0003\u0003\u0003@\te\"\u0001\u0002'jgRDqAa\u0011\u001f\u0001\u0004\tY)\u0001\u0005qCJ,g\u000e^%e\u0011\u001d\u00119E\ba\u0001\u0005\u0013\nA\u0001]1hKB\u0019\u0001Oa\u0013\n\u0007\t5\u0013O\u0001\u0003QC\u001e,\u0007\"\u0003B)=A\u0005\t\u0019AA]\u0003]!WmY8sCR,w+\u001b;i!\u0016\u0014X.[:tS>t7\u000fC\u0005\u0003\u000ey\u0001\n\u00111\u0001\u0002:\"\u001aa$!)\u0002;1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:%I\u00164\u0017-\u001e7uIM\nQ\u0004\\5tiZKWm^1cY\u00164u\u000e\u001c3feN$C-\u001a4bk2$H\u0005N\u0001\u0005[>4X\r\u0006\u0004\u0002P\n}#\u0011\r\u0005\b\u0003\u0013\u000b\u0003\u0019AAF\u0011\u001d\u0011\u0019'\ta\u0001\u0003\u0017\u000b1B\\3x!\u0006\u0014XM\u001c;JI\"\u001a\u0011%!)\u0002\rI,g.Y7f)\u0019\tyMa\u001b\u0003n!9\u0011\u0011\u0012\u0012A\u0002\u0005-\u0005b\u0002B8E\u0001\u0007\u00111R\u0001\b]\u0016<h*Y7fQ\r\u0011\u0013\u0011U\u0001\u0010g\u0016\f'o\u00195UK6\u0004H.\u0019;fgRA!q\u000fBA\u0005\u0007\u0013)\t\u0005\u0004\u00038\tu\"\u0011\u0010\t\u0005\u0005w\u0012i(\u0004\u0002\u0002X&!!qPAl\u0005\u001d\u0011V\r\\3bg\u0016Dq!!#$\u0001\u0004\tY\tC\u0004\u0003H\r\u0002\rA!\u0013\t\u0013\t51\u0005%AA\u0002\u0005e\u0006fA\u0012\u0002\"\u0006I2/Z1sG\"$V-\u001c9mCR,7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019X-\u0019:dQJ+G.Z1tKN$\u0002Ba$\u0003\u001c\nu%Q\u0017\t\u0005\u0005#\u00139*\u0004\u0002\u0003\u0014*\u0019!Q\u0013-\u0002\rM,\u0017M]2i\u0013\u0011\u0011IJa%\u0003'I+G.Z1tKN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\u0005%U\u00051\u0001\u0002\f\"9!qT\u0013A\u0002\t\u0005\u0016a\u00024jYR,'o\u001d\t\u0005\u0005G\u0013\t,\u0004\u0002\u0003&*!!q\u0015BU\u0003\u00151wN]7t\u0015\u0011\u0011YK!,\u0002\u0005Y\f$b\u0001BX1\u0006\u0019\u0011\r]5\n\t\tM&Q\u0015\u0002\u0010%\u0016dW-Y:fg\u001aKG\u000e^3sg\"I!qI\u0013\u0011\u0002\u0003\u0007!\u0011\n\u0015\u0004K\u0005\u0005\u0016\u0001G:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0018\u0016\u0005\u0005\u0013\n\u00190\u0001\u0007n_Z,G+Z7qY\u0006$X\r\u0006\u0005\u0002\f\n\r'Q\u0019Be\u0011\u001d\tIi\na\u0001\u0003\u0017CqAa2(\u0001\u0004\tY)\u0001\u0006uK6\u0004H.\u0019;f\u0013\u0012D\u0011Ba3(!\u0003\u0005\r!!/\u0002!MDw.\u001e7e\u001b\u0016\u0014x-\u001a+fC6\u001c\bfA\u0014\u0002\"\u00061Rn\u001c<f)\u0016l\u0007\u000f\\1uK\u0012\"WMZ1vYR$3'\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003\u001f\u0014)Na6\t\u000f\t\r\u0013\u00061\u0001\u0002\f\"9\u0011Q[\u0015A\u0002\u0005=\u0007fA\u0015\u0002\"RA\u0011q\u001aBo\u0005?\u0014\t\u000fC\u0004\u0003D)\u0002\r!a#\t\u000f\u0005U'\u00061\u0001\u0002P\"9!1\u001d\u0016A\u0002\u0005e\u0016AE2sK\u0006$X\rR3gCVdG\u000fV3b[ND3AKAQ\u0003u1\u0018\r\\5eCR,gi\u001c7eKJ\u001cH)\u001a9uQ\u001a{'/T8wS:<GCBAA\u0005W\u0014i\u000fC\u0004\u0002\n.\u0002\r!a#\t\u000f\t\r4\u00061\u0001\u0002\f\u0006)r-\u001a;BY2|w/\u001a3G_2$WM\u001d#faRDGC\u0001B\u0012\u0005=1u\u000e\u001c3fe\u0006sG-\u0012<f]R\u001c8CB\u0017a\u0005o\u0014i\u0010E\u0002b\u0005sL1Aa?c\u0005\u001d\u0001&o\u001c3vGR\u0004BAa@\u0004\n9!1\u0011AB\u0003\u001d\u0011\t\tja\u0001\n\u0003\rL1aa\u0002c\u0003\u001d\u0001\u0018mY6bO\u0016LAaa\u0003\u0004\u000e\ta1+\u001a:jC2L'0\u00192mK*\u00191q\u00012\u0016\u0005\u0005=\u0017a\u00024pY\u0012,'\u000fI\u000b\u0003\u0007+\u0001bAa@\u0004\u0018\rm\u0011\u0002BB\r\u0007\u001b\u00111aU3r!\u0011\u0019ib!\t\u000e\u0005\r}!\u0002BA\u001a\u0003/LAaa\t\u0004 \tq\u0001\f\u0014*fY\u0016\f7/Z#wK:$\u0018aB3wK:$8\u000f\t\u000b\u0007\u0007S\u0019ica\f\u0011\u0007\r-R&D\u0001\u0001\u0011\u001d\t)N\ra\u0001\u0003\u001fD\u0011\"a\r3!\u0003\u0005\ra!\u0006\u0002\t\r|\u0007/\u001f\u000b\u0007\u0007S\u0019)da\u000e\t\u0013\u0005U7\u0007%AA\u0002\u0005=\u0007\"CA\u001agA\u0005\t\u0019AB\u000b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0010+\t\u0005=\u00171_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019\u0019E\u000b\u0003\u0004\u0016\u0005M\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003$\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB(\u0007+\u00022!YB)\u0013\r\u0019\u0019F\u0019\u0002\u0004\u0003:L\b\"CB,q\u0005\u0005\t\u0019\u0001B\u0012\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\f\t\u0007\u0007?\u001a)ga\u0014\u000e\u0005\r\u0005$bAB2E\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r\u001d4\u0011\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002:\u000e5\u0004\"CB,u\u0005\u0005\t\u0019AB(\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005}31\u000f\u0005\n\u0007/Z\u0014\u0011!a\u0001\u0005G\t\u0001\u0002[1tQ\u000e{G-Z\u0001\ti>\u001cFO]5oOR\u0011\u0011qL\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e6q\u0010\u0005\n\u0007/r\u0014\u0011!a\u0001\u0007\u001f\nqBR8mI\u0016\u0014\u0018I\u001c3Fm\u0016tGo\u001d\t\u0004\u0007W\u00015#\u0002!\u0004\b\u000eM\u0005CCBE\u0007\u001f\u000bym!\u0006\u0004*5\u001111\u0012\u0006\u0004\u0007\u001b\u0013\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007#\u001bYIA\tBEN$(/Y2u\rVt7\r^5p]J\u0002Ba!&\u0004\u001c6\u00111q\u0013\u0006\u0005\u00073\u000b9'\u0001\u0002j_&!11BBL)\t\u0019\u0019)A\u0003baBd\u0017\u0010\u0006\u0004\u0004*\r\r6Q\u0015\u0005\b\u0003+\u001c\u0005\u0019AAh\u0011%\t\u0019d\u0011I\u0001\u0002\u0004\u0019)\"A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$Ba!,\u0004:B)\u0011ma,\u00044&\u00191\u0011\u00172\u0003\r=\u0003H/[8o!\u001d\t7QWAh\u0007+I1aa.c\u0005\u0019!V\u000f\u001d7fe!I11X#\u0002\u0002\u0003\u00071\u0011F\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\fde\u0016\fG/Z,ji\"|W\u000f\u001e)vE2L7\u000f[5oORA1\u0011FBb\u0007\u000b\u001c9\rC\u0004\u0003D\u001d\u0003\r!a#\t\u000f\u0005Uw\t1\u0001\u0002P\"9!1]$A\u0002\u0005e\u0016A\u00023fY\u0016$X\r\u0006\u0003\u0002\u0002\u000e5\u0007bBAE\u0011\u0002\u0007\u00111\u0012\u0015\u0004\u0011\u0006\u0005\u0016aD1sG\"Lg/Z(s\t\u0016dW\r^3\u0015\r\u0005\u00055Q[Bm\u0011\u001d\u00199.\u0013a\u0001\u0005G\t\u0011BZ8mI\u0016\u0014X+\u001b3\t\u000f\rm\u0017\n1\u0001\u0002\f\u0006I!/\u001a7fCN,\u0017\nZ\u0001\u000b[\u0016\u0014x-\u001a+fC6\u001cH\u0003CAA\u0007C\u001c\u0019o!:\t\u000f\u0005%%\n1\u0001\u0002\f\"9!q\u0019&A\u0002\u0005-\u0005bBBt\u0015\u0002\u00071\u0011^\u0001\u000ei\u0016l\u0007\u000f\\1uKR+\u0017-\\:\u0011\r\t}8qCBv!\u0011\u0011Yh!<\n\t\r=\u0018q\u001b\u0002\u0005)\u0016\fW.\u0001\u0007sKBd\u0017mY3UK\u0006l7\u000f\u0006\u0004\u0002\u0002\u000eU8q\u001f\u0005\b\u0003\u0013[\u0005\u0019AAF\u0011\u001d\u00119m\u0013a\u0001\u0003\u0017\u000b1$\\3sO\u0016$V-\u001c9mCR,\u0017I\u001c3G_2$WM\u001d+fC6\u001cHCBBu\u0007{$\t\u0001C\u0004\u0004\u00002\u0003\ra!;\u0002\u0017\u0019|G\u000eZ3s)\u0016\fWn\u001d\u0005\b\u0007Od\u0005\u0019ABu\u00035\u0011Xm]3u)\u0006\u001c8\u000eV3b[R!\u0011\u0011\u0011C\u0004\u0011\u001d\u00119-\u0014a\u0001\u0003\u0017\u000bad\u0019:fCR,G)\u001a4bk2$H+Z1ng\u001a{'\u000f\u00165f\r>dG-\u001a:\u0015\r\u00115A\u0011\u0003C\n!\u0019\u0011y\u0010b\u0004\u0004\u001c%!!qHB\u0007\u0011\u001d\t)N\u0014a\u0001\u0003\u001fDqAa\u0011O\u0001\u0004\tY)A\u0010hKRtuN\\%oQ\u0016\u0014\u0018\u000e^3e\r>dG-\u001a:SK\u001a,'/\u001a8dKN$b\u0001\"\u0007\u0005,\u00115\u0002C\u0002C\u000e\tC!)#\u0004\u0002\u0005\u001e)!AqDB1\u0003\u001diW\u000f^1cY\u0016LA\u0001b\t\u0005\u001e\t\u00191+\u001a;\u0011\t\tmDqE\u0005\u0005\tS\t9NA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:Dq!!#P\u0001\u0004\tY\tC\u0004\u00050=\u0003\r!a#\u0002\u00179,wOZ8mI\u0016\u0014\u0018\nZ\u0001\u0016G\",7m\u001b$pY\u0012,'oQ1o\u0005\u0016luN^3e)!\t\t\t\"\u000e\u00058\u0011u\u0002bBAE!\u0002\u0007\u00111\u0012\u0005\b\ts\u0001\u0006\u0019\u0001C\u001e\u0003EqWm\u001e4pY\u0012,'/\u00133PaRLwN\u001c\t\u0006C\u000e=\u00161\u0012\u0005\b\t\u007f\u0001\u0006\u0019AAF\u0003%y\u0007/\u001a:bi&|g.A\u0007de\u0016\fG/\u001a#fi\u0006LGn\u001d\u000b\t\u0003?\")\u0005b\u0013\u0005P!9AqI)A\u0002\u0011%\u0013AD1di&4XMU3mK\u0006\u001cXm\u001d\t\u0007\u0005\u007f\u001c9B!\u001f\t\u000f\u00115\u0013\u000b1\u0001\u0005J\u0005A\u0012-\u001e;p'R\f'\u000f\u001e)f]\u0012Lgn\u001a*fY\u0016\f7/Z:\t\u000f\u0011E\u0013\u000b1\u0001\u0005T\u0005Y\u0011N\u001c<bY&$'+\u001a4t!\u0019\u0019y\u0006\"\u0016\u0005&%!A1EB1\u0003]\u0019\u0007.Z2l)\u0016l\u0007\u000f\\1uK\u000e\u000bgNQ3N_Z,G\r\u0006\u0004\u0002\u0002\u0012mCQ\f\u0005\b\u0005\u000f\u0014\u0006\u0019AAF\u0011\u001d\tII\u0015a\u0001\u0003\u0017\u000b!cZ3u%Vtg.\u001b8h%\u0016dW-Y:fgR!A\u0011\nC2\u0011\u001d\tIi\u0015a\u0001\u0003\u0017\u000b1dZ3u\u0003V$xn\u0015;beR\u0004VM\u001c3j]\u001e\u0014V\r\\3bg\u0016\u001cH\u0003\u0002C%\tSBq!!#U\u0001\u0004\tY\t")
public class FolderService
implements Logging {
    private volatile FolderService$FolderAndEvents$ FolderAndEvents$module;
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final String SLASH;
    private final String SLASH_FOLDER;
    private final String TYPE_LIMITS;
    private final String MAX_FOLDER_DEPTH;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public FolderService$FolderAndEvents$ FolderAndEvents() {
        if (this.FolderAndEvents$module == null) {
            this.FolderAndEvents$lzycompute$1();
        }
        return this.FolderAndEvents$module;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String SLASH() {
        return this.SLASH;
    }

    public String SLASH_FOLDER() {
        return this.SLASH_FOLDER;
    }

    public String TYPE_LIMITS() {
        return this.TYPE_LIMITS;
    }

    public String MAX_FOLDER_DEPTH() {
        return this.MAX_FOLDER_DEPTH;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringBuilder(23).append("Folder ").append(Ids.ROOT_FOLDER_ID).append(" cannot be found").toString(), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    @Timed
    public Folder findViewableFoldersById(String folderId, Integer depth, boolean enforcePermission) {
        return (Folder)this.folders.findViewableFoldersById(folderId, depth, enforcePermission).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findViewableFoldersById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    public boolean findViewableFoldersById$default$3() {
        return true;
    }

    @Timed
    public Folder findByPath(String path, int depth) {
        return this.folders.findByPath(path, depth);
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public java.util.List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions, boolean enforcePermission) {
        block0: {
            if (!enforcePermission) break block0;
            this.permissions.checkViewFolder(parentId);
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folders.listViewableFolders(parentId, page, decorateWithPermissions, enforcePermission)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public boolean listViewableFolders$default$4() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.validateFoldersDepthForMoving(folderId, newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public java.util.List<Release> searchTemplates(String folderId, Page page, boolean enforcePermission) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth(), enforcePermission).getReleases();
    }

    public boolean searchTemplates$default$3() {
        return true;
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringBuilder(1).append(folderId).append("/").append(Ids.getName((String)templateId)).toString();
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(61).append("Attempted to move template ").append(templateId).append(" to same folder ").append(folderId).append(". Will be ignored.").toString());
            string = templateId;
        } else {
            scala.collection.immutable.Seq templateTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getStoredTeams(templateId)).asScala().toSeq();
            this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateMovingAction(templateId, folderId));
            this.releaseRepository.move(templateId, newTemplateId);
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (scala.collection.immutable.Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        int allowedFolderDepth;
        String[] checkFolderDepth = parentId.split(this.SLASH_FOLDER());
        if (checkFolderDepth.length - 1 > (allowedFolderDepth = this.getAllowedFolderDepth())) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Creating Folder exceeds allowed sub-folder depth ").append(allowedFolderDepth).toString());
        }
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        FolderAndEvents result = this.createWithoutPublishing(parentId, folder, createDefaultTeams);
        result.events().foreach((Function1 & Serializable)event -> {
            this.eventBus.publish(event);
            return BoxedUnit.UNIT;
        });
        return result.folder();
    }

    private void validateFoldersDepthForMoving(String folderId, String newParentId) {
        int newFolderIdSplitLength;
        int allowedFolderDepth = this.getAllowedFolderDepth();
        int newParentIdFolderDepth = newParentId.split(this.SLASH_FOLDER()).length - 1;
        if (newParentIdFolderDepth > allowedFolderDepth) {
            throw new IllegalArgumentException(new StringBuilder(65).append("Moving folder/folders is not within the allowed sub-folder depth ").append(allowedFolderDepth).toString());
        }
        String[] newFolderIdSplit = folderId.split(this.SLASH());
        String newFolderIdInDb = newFolderIdSplit[(newFolderIdSplitLength = newFolderIdSplit.length) - 1];
        int findChildrenOfNewFolder = this.folders.findNumberOfChildrenForAFolder(newFolderIdInDb);
        int newToBeFolderLength = newParentIdFolderDepth + findChildrenOfNewFolder;
        if (newToBeFolderLength > allowedFolderDepth) {
            throw new IllegalArgumentException(new StringBuilder(65).append("Moving folder/folders is not within the allowed sub-folder depth ").append(allowedFolderDepth).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getAllowedFolderDepth() {
        void var2_1;
        Optional<void> optional = this.configurationRepository.findFirstByType(Type.valueOf((String)this.TYPE_LIMITS()));
        FeatureSettings feature = (FeatureSettings)Type.valueOf((String)this.TYPE_LIMITS()).getDescriptor().newInstance("");
        feature.generateId();
        FeatureSettings allLimitsProperty = (FeatureSettings)optional.orElse(var2_1);
        return BoxesRunTime.unboxToInt((Object)allLimitsProperty.getProperty(this.MAX_FOLDER_DEPTH()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public FolderAndEvents createWithoutPublishing(String parentId, Folder folder, boolean createDefaultTeams) {
        Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
        this.checkFolderExists(parentId);
        this.folders.checkNameIsUnique(parentId, folder.getTitle());
        if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
            folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
        } else {
            folder.setId(new StringBuilder(1).append(parentId).append("/").append(Ids.getName((String)folder.getId())).toString());
        }
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(25).append("Creating folder ").append(folder.getTitle()).append(" with id ").append(folder.getId()).toString());
        Folder saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
        scala.collection.immutable.Seq events = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FolderCreatedEvent[]{new FolderCreatedEvent(folder)}));
        if (createDefaultTeams) {
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                events = (scala.collection.immutable.Seq)events.$plus$plus(this.createDefaultTeamsForTheFolder(saved, parentId));
                return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
            }
        }
        events = (scala.collection.immutable.Seq)events.$colon$plus((Object)new TeamsUpdatedEvent(folder.getId()));
        return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(16).append("Deleting folder ").append(folderId).toString());
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(41).append("archiveOrDelete(").append(folderUid).append(", ").append(releaseId).append("): status=").append(status).append(" [inactive? ").append(status.isInactive()).append("]").toString());
        if (status.isInactive()) {
            Release release = this.releaseRepository.findById(releaseId);
            if (this.archivingService.shouldArchive(release)) {
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(16).append("archiveRelease(").append(releaseId).append(")").toString());
            this.archivingService.archiveRelease(releaseId);
        } else {
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(15).append("deleteRelease(").append(releaseId).append(")").toString());
            this.releaseRepository.delete(releaseId, this.releaseRepository.delete$default$2());
        }
    }

    private void mergeTeams(String folderId, String templateId, scala.collection.immutable.Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            scala.collection.immutable.Seq folderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(folderId)).asScala().toSeq();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable)() -> folderId);
            scala.collection.immutable.Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((scala.collection.immutable.Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, CollectionConverters$.MODULE$.SeqHasAsJava(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private scala.collection.immutable.Seq<Team> mergeTemplateAndFolderTeams(scala.collection.immutable.Seq<Team> folderTeams, scala.collection.immutable.Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((IterableOnceOps)folderTeams.map((Function1 & Serializable)team -> new Tuple2((Object)team.getTeamName(), team))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).toSeq());
        templateTeams.foreach((Function1 & Serializable)templateTeam -> {
            Growable growable;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                growable = folderTeamsMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getMembers()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getMembers()).asScala().toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getRoles()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getRoles()).asScala().toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getPermissions()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getPermissions()).asScala().toSet());
                folderTeam.setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)memberSet.toSeq()).asJava());
                folderTeam.setRoles(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)roleSet.toSeq()).asJava());
                folderTeam.setPermissions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)permissionSet.toSeq()).asJava());
                growable = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return growable;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
    }

    private List<XLReleaseEvent> createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getFolderPermissions()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_TRIGGER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        Buffer releaseAdminPermissions = (Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getReleasePermissions()).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getTriggerPermissions()).asScala())).concat((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{XLReleasePermissions.VIEW_FOLDER.getPermissionName()})));
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.addPermissions((String[])releaseAdminPermissions.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        Tuple2<java.util.List<Team>, java.util.List<XLReleaseEvent>> result = this.teamService.saveTeamsToPlatformWithoutPublishing(folder.getId(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava(), true);
        return CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)result._2()).asScala().toList();
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        Buffer releases = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, newfolderId, folderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        scala.collection.immutable.Seq<Release> activeReleases = this.getRunningReleases(folderId);
        scala.collection.immutable.Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Tried to ").append(operation).append(" folder ").append(folderId).append(", which has active releases ").append(((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$2 -> x$2.getId())).mkString(", ")).toString()).append(new StringBuilder(53).append(" or pending releases with auto start option enabled: ").append(((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$3 -> x$3.getId())).mkString(", ")).toString()).toString());
            String details = this.createDetails(activeReleases, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException(new StringBuilder(62).append("You cannot ").append(operation).append(" this folder. The folder or its subfolders contain ").append(details).toString(), new Object[0]);
        }
    }

    private String createDetails(scala.collection.immutable.Seq<Release> activeReleases, scala.collection.immutable.Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        String details;
        block2: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(17).append("active releases: ").append(((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$4 -> x$4.getTitle())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(34).append("pending releases with auto start: ").append(((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$5 -> x$5.getTitle())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (!invalidRefs.nonEmpty()) break block2;
            details = new StringBuilder(0).append(details).append(new StringBuilder(66).append("configuration references not inherited by the destination folder: ").append(((IterableOnceOps)invalidRefs.map((Function1 & Serializable)x$6 -> x$6.getTitle())).mkString("\"", "\", \"", "\"")).toString()).toString();
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$1(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).forall((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$3(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private scala.collection.immutable.Seq<Release> getRunningReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala().toSeq();
    }

    private scala.collection.immutable.Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$4 = true;
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$6 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$5, x$6, true))).asScala().toSeq();
    }

    private final void FolderAndEvents$lzycompute$1() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (this.FolderAndEvents$module == null) {
                this.FolderAndEvents$module = new FolderService$FolderAndEvents$(this);
            }
        }
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String newfolderId$1, String folderId$7, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).foreach((Function1 & Serializable)c -> c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$7) ? BoxesRunTime.boxToBoolean((boolean)res$1.add(c)) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$1(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$3(String folderId$9, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$9.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
        this.SLASH = "/";
        this.SLASH_FOLDER = "/Folder";
        this.TYPE_LIMITS = "xlrelease.Limits";
        this.MAX_FOLDER_DEPTH = "maxFolderDepth";
    }

    public class FolderAndEvents
    implements Product,
    Serializable {
        private final Folder folder;
        private final scala.collection.immutable.Seq<XLReleaseEvent> events;
        public final /* synthetic */ FolderService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Folder folder() {
            return this.folder;
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> events() {
            return this.events;
        }

        public FolderAndEvents copy(Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            return new FolderAndEvents(this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer(), folder, events);
        }

        public Folder copy$default$1() {
            return this.folder();
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> copy$default$2() {
            return this.events();
        }

        public String productPrefix() {
            return "FolderAndEvents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.folder();
                    break;
                }
                case 1: {
                    object = this.events();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FolderAndEvents;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "folder";
                    break;
                }
                case 1: {
                    string = "events";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FolderAndEvents)) return false;
            if (((FolderAndEvents)object).com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() != this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FolderAndEvents folderAndEvents = (FolderAndEvents)x$1;
            Folder folder = this.folder();
            Folder folder2 = folderAndEvents.folder();
            if (folder == null) {
                if (folder2 != null) {
                    return false;
                }
            } else if (!folder.equals(folder2)) return false;
            scala.collection.immutable.Seq<XLReleaseEvent> seq = this.events();
            scala.collection.immutable.Seq<XLReleaseEvent> seq2 = folderAndEvents.events();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!folderAndEvents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FolderService com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() {
            return this.$outer;
        }

        public FolderAndEvents(FolderService $outer, Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            this.folder = folder;
            this.events = events;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

