package com.xebialabs.xlrelease.script;

import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration;

import scala.Option;

import static java.lang.String.format;

@Component
public class UnsupportedScriptService implements ScriptService {
    private static final Logger logger = LoggerFactory.getLogger(UnsupportedScriptService.class);

    public static final String UNSUPPORTED_ENGINE = "unsupported_engine";

    @Override
    public Object executeScript(final XlrScriptContext scriptContext) {
        throw new UnsupportedOperationException("Script execution is not implemented");
    }

    @Override
    public <T extends ResolvableScriptTask> ScriptTaskResult executeScriptTask(T task) {
        return new FailureScriptTaskResult(task.getId(), task.getExecutionId(), onException(task.getId()), Option.empty(), null, null);
    }

    @Override
    public <T extends CustomScriptTask> CustomScriptTaskResult executeCustomScriptTask(T task) {
        return new FailureCustomScriptTaskResult(task.getId(), task.getExecutionId(), onException(task.getId()), Option.empty(), null);
    }

    @Override
    public PreconditionResult executePrecondition(Task task) {
        return new InvalidPreconditionResult(task.getId(), task.getExecutionId(), onException(task.getId()), Option.empty(), null);
    }

    @Override
    public FacetCheckResult executeFacetCheck(Task task) {
        return new FailureFacetCheckResult(task.getId(), task.getExecutionId(), onException(task.getId()), Option.empty(), null);
    }

    @Override
    public FailureHandlerResult executeFailureHandler(Task task) {
        throw new UnsupportedOperationException("executeFailureHandler is not implemented");
    }

    @Override
    public Collection<Object> executeScriptValueProvider(final ScriptValueProviderConfiguration valueProviderConfiguration) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String engine() {
        return UNSUPPORTED_ENGINE;
    }

    @Override
    public boolean accepts(final String filename) {
        return false;
    }

    private String onException(String taskId) {
        String errorMsg = format("Unable to execute '%s', unsupported script engine", taskId);
        logger.warn(errorMsg);
        return errorMsg;
    }
}
