package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.config.XlrConfig;

@Component
public class CsrfFilterPostProcessor implements BeanPostProcessor {

    private XlrConfig xlrConfig;

    @Autowired
    public CsrfFilterPostProcessor(final XlrConfig xlrConfig) {
        this.xlrConfig = xlrConfig;
    }

    @Override
    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        if (!xlrConfig.server_http_csrf_enabled() && bean instanceof DefaultSecurityFilterChain) {
            ((DefaultSecurityFilterChain) bean).getFilters().removeIf(f -> f instanceof CsrfFilter);
        }
        return bean;
    }


}

