package com.xebialabs.xlrelease.upgrade;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.UpgradeStrategy;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.config.XlrConfig;

import static java.util.stream.Collectors.toList;

public class XLReleaseUpgrader extends Upgrader {
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseUpgrader.class);

    public XLReleaseUpgrader(UpgradeStrategy upgradeStrategy, boolean forceUpgrades,
                             RepositoryVersionService repositoryVersionService) {
        super(upgradeStrategy, forceUpgrades, repositoryVersionService);
        addComponent("deployit"); // Needed to migrate pre-3.0 repositories
    }

    @Override
    protected void updateVersion(final Version version, final List<Upgrade> upgrades) {
        XlrConfig xlrConfig = XlrConfig.getInstance();
        List<Upgrade> upgradesToExecute = upgrades;
        if (xlrConfig.getXl().hasPath("upgrader.skip")) {
            List<String> upgradesToSkip = xlrConfig.getXl().getStringList("upgrader.skip");
            upgradesToExecute = upgrades.stream().filter(upgrade -> {
                String upgradeName = upgrade.getClass().getSimpleName();
                if (upgradesToSkip != null && upgradesToSkip.contains(upgradeName)) {
                    logger.warn("Skipping upgrade [{}]", upgradeName);
                    return false;
                } else {
                    return true;
                }
            }).collect(toList());
        }
        super.updateVersion(version, upgradesToExecute);
    }
}
