package com.xebialabs.xlrelease.scheduler.logs

import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository.{FindOperation, UpdateTaskExecutionOperation}
import com.xebialabs.xlrelease.storage.domain.LogEntry

import java.time.Instant

trait TaskExecutionRepository {
  def read(taskId: String, executionId: String): Option[TaskExecutionEntry]

  def update(updateOperation: UpdateTaskExecutionOperation): Option[TaskExecutionEntry]

  def delete(taskId: String, executionId: String): Unit

  def find(findOperation: FindOperation): Seq[TaskExecutionEntry]
}

object TaskExecutionRepository {

  sealed trait FindOperation

  case class ByTaskId(taskId: String) extends FindOperation

  sealed trait UpdateTaskExecutionOperation

  case class FinishExecution(taskId: String, executionId: String, endDate: Instant) extends UpdateTaskExecutionOperation

  case class UpdateWithLogEntry(logEntry: LogEntry) extends UpdateTaskExecutionOperation {

  }
}
