package com.xebialabs.xlrelease.scheduler.logs

import com.xebialabs.xlrelease.repository.sql.persistence.Schema.TASK_EXECUTIONS
import org.springframework.jdbc.core.RowMapper

import java.sql.Timestamp
import java.time.Instant

private[logs] case class TaskExecutionEntry(taskIdHash: String,
                                            executionId: String,
                                            lastJob: Int,
                                            lastChunk: Int,
                                            lastModifiedDate: Instant,
                                            endDate: Instant) {
  def asSqlParamMap(): Map[String, Any] = {
    Map (
      TASK_EXECUTIONS.TASK_ID_HASH -> taskIdHash,
      TASK_EXECUTIONS.EXECUTION_ID -> executionId,
      TASK_EXECUTIONS.LAST_JOB -> lastJob,
      TASK_EXECUTIONS.LAST_CHUNK -> lastChunk,
      TASK_EXECUTIONS.LAST_MODIFIED_DATE -> timestampOrNull(lastModifiedDate),
      TASK_EXECUTIONS.END_DATE -> timestampOrNull(endDate)
    )
  }

  private def timestampOrNull(instant: Instant): Timestamp = {
    if (instant == null) {
      null
    } else {
      Timestamp.from(instant)
    }
  }
}

object TaskExecutionEntry {
  def taskExecutionRowMapper: RowMapper[TaskExecutionEntry] = (rs, _) => {
    TaskExecutionEntry(
      rs.getString(TASK_EXECUTIONS.TASK_ID_HASH),
      rs.getString(TASK_EXECUTIONS.EXECUTION_ID),
      rs.getInt(TASK_EXECUTIONS.LAST_JOB),
      rs.getInt(TASK_EXECUTIONS.LAST_CHUNK),
      Option(rs.getTimestamp(TASK_EXECUTIONS.LAST_MODIFIED_DATE)).map(_.toInstant).orNull,
      Option(rs.getTimestamp(TASK_EXECUTIONS.END_DATE)).map(_.toInstant).orNull
    )
  }
}
