package com.xebialabs.xlrelease.scheduler

import grizzled.slf4j.Logging

import java.util.concurrent.{DelayQueue, TimeUnit}
import java.util.function.Predicate

case class JobRunnerQueue(capabilities: Set[String]) extends Logging {
  def runnerCapabilities: Set[String] = capabilities

  private val internalJobQueue: DelayQueue[Job] = new DelayQueue[Job]()

  private def matches(job: Job): Boolean = {
    logger.trace(s"Job $job matched internal queue $this ")
    val matches = job.capabilities().subsetOf(runnerCapabilities)
    matches
  }

  def offer(job: Job): Unit = {
    // put it into internal queue until someone asks for it
    if (matches(job)) {
      internalJobQueue.add(job)
    }
  }

  def cancelIf(predicate: Predicate[Job]): Unit = {
    internalJobQueue.removeIf(predicate)
  }

  def poll(): Job = {
    internalJobQueue.poll(50, TimeUnit.SECONDS)
  }
}
