package com.xebialabs.xlrelease.events;

import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import static com.xebialabs.xlrelease.events.EventFactoryBeanConfig.EVENT_FACTORY_BEAN;

/**
 * Registers all beans annotated as {@link com.xebialabs.xlrelease.events.EventListener} with the eventBus
 */
@Component
public class EventListenerRegister {

    private static final Logger logger = LoggerFactory.getLogger(EventListenerRegister.class);

    @Resource(name = EVENT_FACTORY_BEAN)
    private List<XLReleaseEventListener> eventListeners;

    @Autowired
    private XLReleaseEventBus eventBus;

    @Autowired
    @EventListener
    private List<Object> annotatedEventListeners;

    @Autowired
    private ApplicationContext ctx;

    public void registerEventListeners() {
        logger.debug("Registering event listeners.");
        annotatedEventListeners.forEach(listener -> {
            logger.debug("Registering event listener {}", listener.getClass().getCanonicalName());
            eventBus.register(listener);
        });
        eventListeners.forEach(listener -> {
            ctx.getAutowireCapableBeanFactory().autowireBean(listener);
            logger.debug("Registering event listener {}", listener.getClass().getCanonicalName());
            eventBus.register(listener);
        });
    }
}
