package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xltype.serialization.json.JsonWriter;

import static com.google.common.base.Charsets.UTF_8;
import static com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter.getClassFromGenericType;
import static com.xebialabs.xlrelease.repository.IdType.DOMAIN;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_HTML})
public class ReleaseAttachmentViewJsonWriter implements MessageBodyWriter<Collection<AttachmentView>> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = getClassFromGenericType(genericType);
        }
        return AttachmentView.class.isAssignableFrom(type);
    }


    @Override
    public long getSize(Collection<AttachmentView> attachmentViews, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<AttachmentView> attachmentViews, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(attachmentViews).getBytes(UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<AttachmentView> attachmentViews) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.array();

        for (AttachmentView attachmentView : attachmentViews) {
            writeReleaseAttachmentView(writer, attachmentView);
        }

        writer.endArray();
        return stringWriter.toString();
    }

    static void writeReleaseAttachmentView(JsonWriter writer, AttachmentView attachmentView) {
        writer.object();

        writer.key("id").value(DOMAIN.convertToViewId(attachmentView.getId()));
        writer.key("filename").value(attachmentView.getFilename());
        writer.key("contentType").value(attachmentView.getContentType());

        writer.endObject();
    }
}
