/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.converters.TaskJobConverter;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskId;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskIdAndExecutionId;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.repository.UpdateJobStatus;
import com.xebialabs.xlrelease.scheduler.repository.UpdateNodeAndStatus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\u0006\r\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)A\u0007\u0001C\u0001k!)!\b\u0001C\u0001w!)a\u0010\u0001C\u0001\u007f\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a\u0019\u0001\t\u0003\t)G\u0001\u0006K_\n\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\u000fM,'O^5dK*\u0011q\u0002E\u0001\ng\u000eDW\rZ;mKJT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!B:mMRR'\"A\u0012\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\n\u0011\u0003\u000f1{wmZ5oO\u0006i!n\u001c2SKB|7/\u001b;pef\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002-S\ti!j\u001c2SKB|7/\u001b;pef\f\u0001\u0003^1tW*{'mQ8om\u0016\u0014H/\u001a:\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005Er\u0011AC2p]Z,'\u000f^3sg&\u00111\u0007\r\u0002\u0011)\u0006\u001c8NS8c\u0007>tg/\u001a:uKJ\fa\u0001P5oSRtDc\u0001\u001c9sA\u0011q\u0007A\u0007\u0002\u0019!)ae\u0001a\u0001O!)Qf\u0001a\u0001]\u0005ya-\u001b8e\u00032dG+Y:l\u0015>\u00147\u000f\u0006\u0003=1\u0002t\u0007cA\u001fF\u0011:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003Z\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005\u0011S\u0012a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u0013A\u0001T5ti*\u0011AI\u0007\u0019\u0003\u0013>\u00032AS&N\u001b\u0005q\u0011B\u0001'\u000f\u0005\u001d!\u0016m]6K_\n\u0004\"AT(\r\u0001\u0011I\u0001\u000bBA\u0001\u0002\u0003\u0015\t!\u0015\u0002\u0004?\u0012\n\u0014C\u0001*V!\tI2+\u0003\u0002U5\t9aj\u001c;iS:<\u0007CA\rW\u0013\t9&DA\u0002B]fDQ!\u0017\u0003A\u0002i\u000b!B[8c\r&dG/\u001a:t!\tYf,D\u0001]\u0015\tif\"A\u0004gS2$XM]:\n\u0005}c&A\u0003&pE\u001aKG\u000e^3sg\")\u0011\r\u0002a\u0001E\u0006A\u0001/Y4fC\ndW\r\u0005\u0002dY6\tAM\u0003\u0002fM\u00061Am\\7bS:T!a\u001a5\u0002\t\u0011\fG/\u0019\u0006\u0003S*\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002W\u0006\u0019qN]4\n\u00055$'\u0001\u0003)bO\u0016\f'\r\\3\t\u000b=$\u0001\u0019\u00019\u0002#%<gn\u001c:f+:\\gn\\<o)f\u0004X\r\u0005\u0002\u001ac&\u0011!O\u0007\u0002\b\u0005>|G.Z1oQ\t!A\u000f\u0005\u0002vy6\taO\u0003\u0002xq\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005eT\u0018aB7fiJL7m\u001d\u0006\u0003wR\t\u0001bY8eC\"\fG.Z\u0005\u0003{Z\u0014Q\u0001V5nK\u0012\fABZ5oI\nKH+Y:l\u0013\u0012$B!!\u0001\u0002\u000eA)\u0011$a\u0001\u0002\b%\u0019\u0011Q\u0001\u000e\u0003\r=\u0003H/[8o!\rQ\u0015\u0011B\u0005\u0004\u0003\u0017q!A\u0002&pEJ{w\u000fC\u0004\u0002\u0010\u0015\u0001\r!!\u0005\u0002\rQ\f7o[%e!\u0011\t\u0019\"a\u0007\u000f\t\u0005U\u0011q\u0003\t\u0003\u007fiI1!!\u0007\u001b\u0003\u0019\u0001&/\u001a3fM&!\u0011QDA\u0010\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0004\u000e)\u0005\u0015!\u0018a\u00054j]\u0012$\u0015n\u001d;j]\u000e$hj\u001c3f\u0013\u0012\u001cHCAA\u0014!\u0019\t\u0019\"!\u000b\u0002\u0012%!\u00111FA\u0010\u0005\r\u0019V\r\u001e\u0015\u0003\rQ\fa\u0002Z3mKR,')\u001f+bg.LE\r\u0006\u0003\u00024\u0005e\u0002cA\r\u00026%\u0019\u0011q\u0007\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001f9\u0001\u0019AA\tQ\t9A/\u0001\u000feK2,G/\u001a\"z)\u0006\u001c8.\u00133B]\u0012,\u00050Z2vi&|g.\u00133\u0015\r\u0005M\u0012\u0011IA\"\u0011\u001d\ty\u0001\u0003a\u0001\u0003#Aq!!\u0012\t\u0001\u0004\t\t\"A\u0006fq\u0016\u001cW\u000f^5p]&#\u0007F\u0001\u0005u\u0003=)\b\u000fZ1uK*{'m\u0015;biV\u001cHCBA\u0001\u0003\u001b\n9\u0006C\u0004\u0002P%\u0001\r!!\u0015\u0002\u0007)|'\rE\u0002K\u0003'J1!!\u0016\u000f\u0005\rQuN\u0019\u0005\b\u00033J\u0001\u0019AA.\u0003%QwNY*uCR,8\u000fE\u0002K\u0003;J1!a\u0018\u000f\u0005%QuNY*uCR,8\u000f\u000b\u0002\ni\u00061R\u000f\u001d3bi\u0016TuN\u0019(pI\u0016\fe\u000eZ*uCR,8\u000f\u0006\u0005\u0002\u0002\u0005\u001d\u0014\u0011NA7\u0011\u001d\tyE\u0003a\u0001\u0003#Bq!a\u001b\u000b\u0001\u0004\t\t\"\u0001\u0003o_\u0012,\u0007bBA-\u0015\u0001\u0007\u00111\f\u0015\u0003\u0015QD3\u0001AA:!\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=Q\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005u\u0014q\u000f\u0002\b'\u0016\u0014h/[2f\u0001")
public class JobService
implements Logging {
    private final JobRepository jobRepository;
    private final TaskJobConverter taskJobConverter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobService jobService = this;
        synchronized (jobService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public List<TaskJob<?>> findAllTaskJobs(JobFilters jobFilters, Pageable pageable, boolean ignoreUnknownType) {
        List foundJobs = CollectionConverters$.MODULE$.ListHasAsScala(this.jobRepository.findAll(jobFilters, pageable).toList()).asScala().toList();
        return foundJobs.map((Function1 & Serializable)jobRow -> {
            TaskJob<?> taskJob;
            try {
                taskJob = $this.taskJobConverter.fromJobRow((JobRow)jobRow, $this.taskJobConverter.fromJobRow$default$2());
            }
            catch (Throwable t) {
                if (ignoreUnknownType) {
                    this.logger().error((Function0 & Serializable)() -> t.getMessage(), (Function0 & Serializable)() -> t);
                    taskJob = null;
                }
                throw t;
            }
            return taskJob;
        }).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JobService.$anonfun$findAllTaskJobs$4(x$1)));
    }

    @Timed
    public Option<JobRow> findByTaskId(String taskId) {
        return this.jobRepository.findByTaskId(taskId);
    }

    @Timed
    public Set<String> findDistinctNodeIds() {
        return this.jobRepository.findDistinctNodeIds();
    }

    @Timed
    public void deleteByTaskId(String taskId) {
        this.jobRepository.delete(new DeleteByTaskId(taskId));
    }

    @Timed
    public void deleteByTaskIdAndExecutionId(String taskId, String executionId) {
        this.jobRepository.delete(new DeleteByTaskIdAndExecutionId(taskId, executionId));
    }

    @Timed
    public Option<JobRow> updateJobStatus(Job job, JobStatus jobStatus) {
        return this.jobRepository.update(new UpdateJobStatus(JobRow$.MODULE$.apply(job), jobStatus)).toOption();
    }

    @Timed
    public Option<JobRow> updateJobNodeAndStatus(Job job, String node, JobStatus jobStatus) {
        return this.jobRepository.update(new UpdateNodeAndStatus(JobRow$.MODULE$.apply(job), node, jobStatus)).toOption();
    }

    public static final /* synthetic */ boolean $anonfun$findAllTaskJobs$4(TaskJob x$1) {
        return x$1 == null;
    }

    public JobService(JobRepository jobRepository, TaskJobConverter taskJobConverter) {
        this.jobRepository = jobRepository;
        this.taskJobConverter = taskJobConverter;
        Logging.$init$((Logging)this);
    }
}

