package com.xebialabs.xlrelease.support.report

import com.xebialabs.xlplatform.support.report.ReportDataProvider
import com.xebialabs.xlplatform.support.report.SupportPackageFileWriter.writeToFile
import com.xebialabs.xlplatform.support.report.render.Templater.processTemplate
import com.xebialabs.xlrelease.support.report.repository.DataStatisticsRepository
import com.xebialabs.xltype.serialization.util.DateUtil
import grizzled.slf4j.Logging
import org.joda.time.DateTime
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.lang.management.ManagementFactory.getThreadMXBean
import java.util.Date
import scala.jdk.CollectionConverters._

@Service
class SystemInformationService @Autowired()(val releaseRepository: DataStatisticsRepository,
                                            val providers: java.util.List[ReportDataProvider]) extends Logging {

  def writeSystemInformationReport(): Unit = {
    //write system information report to file in log directory
    writeToFile(s"log/$SYSTEM_INFORMATION_REPORT_FILE_NAME", generateHtmlReport(Seq.empty))
  }

  def writeThreadDump(): Unit = {
    //write thread dump to file in log directory
    val threadDumpBuilder = new StringBuilder("Generated at: " + DateUtil.toString(DateTime.now()) + "\n\n\n")
    getThreadMXBean.dumpAllThreads(true, true).foreach(ti => threadDumpBuilder.append(ti.toString))
    writeToFile(s"log/$THREAD_DUMP_FILE_NAME", threadDumpBuilder.toString())
  }

  def generateHtmlReport(reports: Seq[String]): String = {
    processTemplate(SYSTEM_INFORMATION_REPORT_TEMPLATE, createReportContext(reports).asJava)
  }

  def generateJsonReport(reports: Seq[String]): java.util.Map[String, Any] = {
    createReportContext(reports).asJava
  }

  protected def createReportContext(reports: Seq[String]): Map[String, Any] = {
    val applicableProviders = providers.asScala
      .filter(provider => reports.isEmpty || reports.contains(provider.name))
    applicableProviders.foldLeft(baseContext)((context, provider) => context ++ provider.collectStatistics)
  }

  protected def baseContext: Map[String, Any] = {
    Map[String, Any]("generatedAt" -> new Date().toString)
  }

}
