package com.xebialabs.xlrelease.script.jython

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.spring.configuration.ScriptingConfiguration
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class JythonScriptingConfiguration {

  @Bean
  def scriptingConfiguration(xlrConfig: XlrConfig): ScriptingConfiguration = {
    ScriptingConfiguration(policyAutoRefresh = true, workDir = "work", sandboxEnabled = xlrConfig.isScriptSandboxEnabled, xlrConfig.jythonSandboxConfiguration)
  }
}

object JythonScriptingConfiguration extends JythonScriptingConfiguration