package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.scheduler.Job
import com.xebialabs.xlrelease.scheduler.workers.Worker.ExecuteJob
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class UnhandledWorker() extends Worker with Logging {

  override def execute: ExecuteJob = {
    case job: Job => {
      throw new IllegalArgumentException(s"Unhandled job $job")
    }
  }

  override def getOrder: Int = Integer.MAX_VALUE

}
