package com.xebialabs.xlrelease.scheduler.storage

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.storage.domain.{StorageEntryCreated, StorageEvent}

import java.net.URI


sealed trait ReleaseStorageEvent extends XLReleaseEvent {
  def uri: URI
}

case class ReleaseStorageEntryCreated(uri: URI) extends ReleaseStorageEvent

object ReleaseStorageEvent {
  def from(event: StorageEvent): ReleaseStorageEvent = {
    event match {
      case StorageEntryCreated(uri) => ReleaseStorageEntryCreated(uri)
    }
  }
}

