package com.xebialabs.xlrelease.scheduler.repository

import com.xebialabs.xlrelease.runner.domain.{JobId, RunnerId}
import com.xebialabs.xlrelease.scheduler.filters.JobFilters
import com.xebialabs.xlrelease.scheduler.{JobOverview, JobRow, JobStatus}
import org.springframework.data.domain.{Pageable, Page => SPage}

import scala.util.Try

trait JobRepository {
  def create(job: JobRow): JobRow

  def replace(job: JobRow): JobRow

  def read(jobId: JobId): JobRow

  def findAll(jobFilters: JobFilters, pageable: Pageable): SPage[JobRow]

  def findAllJobOverview(jobFilters: JobFilters, pageable: Pageable): SPage[JobOverview]

  def findByTaskId(taskId: String): Option[JobRow]

  def findQueuedTaskIdsByReleaseUid(releaseUid: Integer): Seq[String]

  def findDistinctNodeIds(): Set[String]

  def delete(deleteJob: DeleteJob): Unit

  def update(updateJob: UpdateJob): Try[JobRow]
}

sealed trait DeleteJob

case class DeleteById(id: JobId) extends DeleteJob

case class DeleteByTaskId(taskId: String) extends DeleteJob

case class DeleteByTaskIdAndExecutionId(taskId: String, executionId: String) extends DeleteJob

sealed trait UpdateJob {
  val job: JobRow
}

case class UpdateNode(job: JobRow, nodeId: String) extends UpdateJob

case class UpdateJobStatus(job: JobRow, status: JobStatus) extends UpdateJob

case class UpdateNodeAndStatus(job: JobRow, nodeId: String, status: JobStatus) extends UpdateJob

case class ReserveJob(job: JobRow, nodeId: String, runnerId: RunnerId) extends UpdateJob

case class ConfirmJobExecution(job: JobRow, runnerId: RunnerId) extends UpdateJob
