package com.xebialabs.xlrelease.scheduler.logs

import akka.actor.ActorRef
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent
import com.xebialabs.xlrelease.scheduler.logs.JobLogWatchActor._
import com.xebialabs.xlrelease.scheduler.storage.ReleaseStorageEvent
import com.xebialabs.xlrelease.storage.service.StorageService
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension
import com.xebialabs.xlrelease.views.TaskJobLogView
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

import java.io.OutputStream
import javax.ws.rs.sse.{Sse, SseEventSink}
import scala.jdk.CollectionConverters._

@Service
@EventListener
class LogService(springExtension: SpringExtension, storageService: StorageService) extends Logging {

  private lazy val jobLogWatcherActorRef: ActorRef = springExtension.actorOf(classOf[JobLogWatcherSupervisor], s"job-log-watchers")

  def watch(taskId: String, executionId: String, fromStart: Boolean, sink: SseEventSink, sse: Sse): Unit = {
    //TODO:
    // Currently logs are only present for the container-based task.
    // Remove this explicit conversion once it is available as generic solution.
    jobLogWatcherActorRef ! StartWatch(taskId, executionId.toLong, fromStart, sink, sse)
  }

  def fetch(taskId: String, executionId: String, outputStream: OutputStream): Unit = {
    //TODO:
    // Currently logs are only present for the container-based task.
    // Remove this explicit conversion once it is available as generic solution.
    TaskJobLog(taskId, Some(executionId.toLong)).fetch(storageService, outputStream)
  }

  def fetchAllExecutions(taskId: String): java.util.List[TaskJobLogView] = {
    //TODO: Fetch list of executions from the database instead of storage service
    TaskJobLog(taskId, None).fetchJobsIds(storageService).asJava
  }

  @Subscribe
  def onJobFinished(event: JobFinishedEvent): Unit = {
    val jobId = event.jobId
    logger.debug(s"finishing job $jobId")
    jobLogWatcherActorRef ! StopWatching(jobId)
  }

  @Subscribe
  def monitorStorage(storageEvent: ReleaseStorageEvent): Unit = {
    logger.debug(s"processing storage event $storageEvent")
    jobLogWatcherActorRef ! storageEvent
  }
}
