package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.UserToken
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid
import org.springframework.data.domain.{Page, Pageable}

import java.util.Date

trait UserTokenRepository {

  def create(userToken: UserToken, tokenHash: String): CiUid

  def updateLastUsedBatch(entries: Map[Integer, Date]): Int

  def delete(ciUid: CiUid): Unit

  def delete(username: String): Unit

  def findByCiUid(ciUid: CiUid): Option[UserToken]

  def findByUserAndNote(username: String, tokenNote: String): Option[UserToken]

  def findByUserToken(tokenHash: String): Option[UserToken]

  def query(username: String, pageable: Pageable): Page[UserToken]

}
