package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.calendar.Blackout
import com.xebialabs.xlrelease.domain.status.TaskStatus
import com.xebialabs.xlrelease.domain.{Release, Task, TaskContainer}
import com.xebialabs.xlrelease.repository.query.TaskBasicData
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions

import java.util.{Collections, Date, List => JList, Map => JMap, Set => JSet}
import scala.annotation.varargs
import scala.jdk.CollectionConverters._

trait TaskRepository {

  def findById[T <: Task](taskId: String): T

  def findById[T <: Task](taskId: String, resolveOptions: ResolveOptions): T

  def findTaskBasicData(taskId: String): TaskBasicData = {
    findTasksBasicData(Collections.singletonList(taskId)).asScala.headOption
      .getOrElse(throw new NotFoundException(s"Repository entity [$taskId] not found"))
  }

  def findTasksBasicData(taskIds: JList[String]): JList[TaskBasicData]

  def update(task: Task): Task

  @varargs
  def updateTasks(tasks: Task*): Unit

  def updateTaskProperties(task: Task): Unit

  def batchUpdateTaskProperties(tasks: Set[Task]): Unit

  def updateTaskAndReleaseFlagStatus(task: Task, release: Release): Task

  def updateType(task: Task): Task

  def create(newTask: Task): Task

  def delete(task: Task): Unit

  def exists(taskId: String): Boolean

  def moveTask(taskToMove: Task, movedTask: Task, updatedOriginContainer: TaskContainer, updatedTargetContainer: TaskContainer): Task

  def findAffectedByBlackout(blackout: Blackout): JList[String]

  def findPendingTasksWithFacets(): JList[String]

  def getTitle(taskId: String): String

  def getAllTags(limitNumber: Int): JSet[String]

  def findOverdueTaskIds(): Seq[String]

  def findDueSoonTaskIds(): Seq[String]

  def getStatus(taskId: String): TaskStatus

  def getTaskStatuses(releaseId: String): JMap[String, TaskStatus]

  def findTaskIdsByTaskTypeStatusAndStartDate(taskType: Type, taskStatus: TaskStatus, startedBefore: Date): Seq[String]

}
