package com.xebialabs.xlrelease.repository;

import java.util.Collection;
import java.util.Iterator;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;

public class CiListMemoryReader implements CiListReader {

    private final Iterator<ConfigurationItem> iterator;
    protected ConfigurationItem currentCi;

    public CiListMemoryReader(Collection<ConfigurationItem> cis) {
        this.iterator = cis.iterator();
        this.currentCi = null;
    }

    @Override
    public boolean hasMoreChildren() {
        return iterator.hasNext();
    }

    @Override
    public void moveIntoChild() {
        currentCi = iterator.next();
    }

    @Override
    public void moveOutOfChild() {
    }

    @Override
    public CiReader getCurrentCiReader() {
        return new CiMemoryReader(currentCi);
    }
}
