package com.xebialabs.deployit.plumbing;

import java.util.Date;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.rest.mappers.UnhandledExceptionMapper;

import static javax.ws.rs.core.Response.Status.BAD_REQUEST;
import static javax.ws.rs.core.Response.Status.NOT_FOUND;
import static javax.ws.rs.core.Response.fromResponse;

@Provider
@Component
public class UnhandledExceptionMapperProvider extends UnhandledExceptionMapper implements ExceptionMapper<RuntimeException> {

    @Autowired
    public UnhandledExceptionMapperProvider(ServerConfiguration config) {
        super(config);
    }

    @Override
    protected Response handleException(RuntimeException runtimeException) {
        Response response = super.handleException(runtimeException);
        response.getMetadata().add("Date", new Date());

        if (runtimeException instanceof NotFoundException) {
            return fromResponse(response).status(NOT_FOUND).build();
        } else if (runtimeException instanceof IllegalArgumentException) {
            return fromResponse(response).status(BAD_REQUEST).entity(runtimeException.getMessage()).build();
        }

        return response;
    }
}
