/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.principaldata.exceptions.GroupEmailNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class PrincipalDataProviderCache
implements PrincipalDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(PrincipalDataProviderCache.class);
    private PrincipalDataProvider principalDataProvider;
    private XlrConfig xlrConfig;
    private LoadingCache<String, UserData> userDataCache;
    private LoadingCache<String, Collection<? extends GrantedAuthority>> authoritiesCache;
    private LoadingCache<String, String> groupEmailCache;

    PrincipalDataProviderCache(PrincipalDataProvider principalDataProvider, XlrConfig xlrConfig) {
        this.principalDataProvider = principalDataProvider;
        this.xlrConfig = xlrConfig;
        this.initCaches();
    }

    public void clearCache() {
        this.userDataCache.invalidateAll();
        this.groupEmailCache.invalidateAll();
    }

    public void initCaches() {
        this.userDataCache = CacheBuilder.newBuilder().expireAfterWrite(this.xlrConfig.cacheTtl("external-users").toMinutes(), TimeUnit.MINUTES).maximumSize((long)this.xlrConfig.cacheMaxSize("external-users")).build((CacheLoader)new CacheLoader<String, UserData>(){

            public UserData load(String username) throws Exception {
                return PrincipalDataProviderCache.this.principalDataProvider.getUserData(username);
            }
        });
        this.authoritiesCache = CacheBuilder.newBuilder().expireAfterWrite(this.xlrConfig.cacheTtl("external-authorities").toMinutes(), TimeUnit.MINUTES).maximumSize((long)this.xlrConfig.cacheMaxSize("external-authorities")).build((CacheLoader)new CacheLoader<String, Collection<? extends GrantedAuthority>>(){

            public Collection<? extends GrantedAuthority> load(String username) {
                return PrincipalDataProviderCache.this.principalDataProvider.getAuthorities(username);
            }
        });
        this.groupEmailCache = CacheBuilder.newBuilder().expireAfterWrite(this.xlrConfig.cacheTtl("external-group-emails").toMinutes(), TimeUnit.MINUTES).maximumSize((long)this.xlrConfig.cacheMaxSize("external-group-emails")).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String groupName) throws Exception {
                String email = PrincipalDataProviderCache.this.principalDataProvider.getGroupEmail(groupName);
                if (email != null) {
                    return email;
                }
                throw new GroupEmailNotFoundException(groupName);
            }
        });
    }

    @Override
    public UserData getUserData(String username) {
        try {
            return (UserData)this.userDataCache.get((Object)username);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getGroupEmail(String groupName) {
        try {
            return (String)this.groupEmailCache.get((Object)groupName);
        }
        catch (ExecutionException e) {
            logger.warn("Cannot fetch group email: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities(String username) {
        try {
            return (Collection)this.authoritiesCache.get((Object)username);
        }
        catch (ExecutionException e) {
            logger.warn("Cannot fetch authorities: {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    @Override
    public void invalidate(String username) {
        this.userDataCache.invalidate((Object)username);
        this.authoritiesCache.invalidate((Object)username);
    }
}

