/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plumbing.PropertyDescriptorJsonWriter;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class TaskDefinitionJsonWriter
implements MessageBodyWriter<TaskDefinition> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(TaskDefinition object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(TaskDefinition object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            entityStream.write(this.toJson(object).getBytes(StandardCharsets.UTF_8));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    String toJson(TaskDefinition object) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        TaskDefinitionJsonWriter.writeObject(writer, object);
        return stringWriter.toString();
    }

    static void writeObject(JsonWriter writer, TaskDefinition object) throws JSONException {
        writer.object();
        writer.key("typeName").value((Object)object.getTypeName());
        writer.key("displayGroup").value((Object)object.getDisplayGroup());
        writer.key("displayName").value((Object)object.getDisplayName());
        writer.key("isAllowed").value(object.isAllowed());
        if (object instanceof PythonScriptDefinition) {
            PythonScriptDefinition pythonScriptDefinition = (PythonScriptDefinition)object;
            TaskDefinitionJsonWriter.writeProperties(writer, "inputProperties", pythonScriptDefinition.getInputProperties().stream().filter(p -> !p.isHidden()).collect(Collectors.toList()));
            TaskDefinitionJsonWriter.writeProperties(writer, "outputProperties", pythonScriptDefinition.getOutputProperties());
        }
        writer.endObject();
    }

    private static void writeProperties(JsonWriter writer, String jsonKey, Collection<PropertyDescriptor> properties) throws JSONException {
        writer.key(jsonKey);
        writer.array();
        for (PropertyDescriptor propertyDescriptor : properties) {
            PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, propertyDescriptor);
        }
        writer.endArray();
    }
}

