/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.workers;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CreatedFromCreateReleaseTask;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFromCreateReleaseTaskEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.EncryptionHelper$;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.UsernamePassword;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Tuple4;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005faB\f\u0019!\u0003\r\ta\t\u0005\u0006e\u0001!\ta\r\u0005\u0006o\u00011\t\u0001\u000f\u0005\u0006\u007f\u00011\t\u0001\u0011\u0005\u0006\u000f\u00021\t\u0001\u0013\u0005\u0006\u001f\u00021\t\u0001\u0015\u0005\u0006)\u00021\t!\u0016\u0005\u0006=\u00021\ta\u0018\u0005\u0006I\u00021\t!\u001a\u0005\u0006S\u0002!\tA\u001b\u0005\u0006w\u0002!I\u0001 \u0005\u0006}\u0002!Ia \u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u001fAq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA;\u0001\u0011%\u0011q\u000f\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\u001c\u0002!I!!(\u0003-\r\u0013X-\u0019;f%\u0016dW-Y:f)\u0006\u001c8\u000eT8hS\u000eT!!\u0007\u000e\u0002\u000f]|'o[3sg*\u00111\u0004H\u0001\ng\u000eDW\rZ;mKJT!!\b\u0010\u0002\u0013ad'/\u001a7fCN,'BA\u0010!\u0003%AXMY5bY\u0006\u00147OC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013!B:mMRR'\"A\u0018\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\r\u0017\u0003\u000f1{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012\u0001\u000e\t\u0003KUJ!A\u000e\u0014\u0003\tUs\u0017\u000e^\u0001\tKZ,g\u000e\u001e\"vgV\t\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=9\u00051QM^3oiNL!AP\u001e\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-F\u0001B!\t\u0011U)D\u0001D\u0015\t!E$\u0001\u0004bGR|'o]\u0005\u0003\r\u000e\u00131CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\faB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001J!\tQU*D\u0001L\u0015\taE$A\u0004tKJ4\u0018nY3\n\u00059[%A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\fG&LEmU3sm&\u001cW-F\u0001R!\tQ%+\u0003\u0002T\u0017\nY1)[%e'\u0016\u0014h/[2f\u0003U\tW\u000f\u001e5f]RL7-\u0019;j_:\u001cVM\u001d<jG\u0016,\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000ba\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002\\9\u0005A1/Z2ve&$\u00180\u0003\u0002^1\n)\u0012)\u001e;iK:$\u0018nY1uS>t7+\u001a:wS\u000e,\u0017!\u00059fe6L7o]5p]\u000eCWmY6feV\t\u0001\r\u0005\u0002bE6\t!,\u0003\u0002d5\n\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0002\u001d\r|W.\\3oiN+'O^5dKV\ta\r\u0005\u0002KO&\u0011\u0001n\u0013\u0002\u000f\u0007>lW.\u001a8u'\u0016\u0014h/[2f\u0003%\u0019H/\u0019:u)\u0006\u001c8\u000e\u0006\u0002lgB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0005Y\u0006twMC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Il'\u0001\u0002,pS\u0012DQ\u0001^\u0005A\u0002U\fA\u0001^1tWB\u0011a/_\u0007\u0002o*\u0011\u0001\u0010H\u0001\u0007I>l\u0017-\u001b8\n\u0005i<(!E\"sK\u0006$XMU3mK\u0006\u001cX\rV1tW\u0006qb/\u00197jI\u0006$Xm\u0011:fCR,'+\u001a7fCN,'+Z2veNLwN\u001c\u000b\u0003iuDQ\u0001\u001e\u0006A\u0002U\f!D^1mS\u0012\fG/\u001a*fcVL'/\u001a3Qe>\u0004XM\u001d;jKN$2\u0001NA\u0001\u0011\u0015!8\u00021\u0001v\u0003A\u0019\u0007.Z2l!\u0016\u0014X.[:tS>t7\u000f\u0006\u0003\u0002\b\u00055\u0001cA1\u0002\n%\u0019\u00111\u0002.\u0003!U\u001bXM\u001d8b[\u0016\u0004\u0016m]:x_J$\u0007\"\u0002;\r\u0001\u0004)H\u0003CA\u0004\u0003#\t\u0019\"!\f\t\u000bQl\u0001\u0019A;\t\u000f\u0005UQ\u00021\u0001\u0002\u0018\u0005I!/\u001a7fCN,\u0017\n\u001a\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000fM5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0011\u0013A\u0002\u001fs_>$h(C\u0002\u0002&\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013M!9\u0011qF\u0007A\u0002\u0005E\u0012A\u0005:fcVL'/\u001a3QKJl\u0017n]:j_:\u0004B!a\r\u0002@5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0006qKJl\u0017n]:j_:T1aWA\u001e\u0015\r\tiDH\u0001\tI\u0016\u0004Hn\\=ji&!\u0011\u0011IA\u001b\u0005)\u0001VM]7jgNLwN\\\u0001\u000eGJ,\u0017\r^3SK2,\u0017m]3\u0015\r\u0005\u001d\u0013QJA(!\r1\u0018\u0011J\u0005\u0004\u0003\u0017:(a\u0002*fY\u0016\f7/\u001a\u0005\u0006i:\u0001\r!\u001e\u0005\b\u0003#r\u0001\u0019AA\u0004\u0003I\u00198M]5qiV\u001bXM\u001d8b[\u0016\u0004\u0016m]:\u0002\u0019M$\u0018M\u001d;SK2,\u0017m]3\u0015\r\u0005]\u0013QLA0!\r)\u0013\u0011L\u0005\u0004\u000372#a\u0002\"p_2,\u0017M\u001c\u0005\u0006i>\u0001\r!\u001e\u0005\b\u0003Cz\u0001\u0019AA$\u0003)\u0019XO\u0019*fY\u0016\f7/Z\u0001\u001di\"\u0014xn^%g\u001b\u0006D8i\u001c8dkJ\u0014XM\\2z%\u0016\f7\r[3e)\r!\u0014q\r\u0005\b\u0003S\u0002\u0002\u0019AA$\u0003-\u0011xn\u001c;SK2,\u0017m]3\u00027\u001d,GoU;c%\u0016dW-Y:f!\u0006\u0014\u0018-\\:Ge>lG+Y:l)\u0019\t9%a\u001c\u0002r!)A/\u0005a\u0001k\"9\u00111O\tA\u0002\u0005\u001d\u0013AE:vEJ+G.Z1tKR+W\u000e\u001d7bi\u0016\f\u0001e]1wK\u000e\u0013X-\u0019;fIJ+G.Z1tK&#\u0017J\u001c;p-\u0006\u0014\u0018.\u00192mKR)A'!\u001f\u0002|!)AO\u0005a\u0001k\"9\u0011\u0011\r\nA\u0002\u0005\u001d\u0013\u0001H:bm\u0016\u001c%/Z1uK\u0012\u0014V\r\\3bg\u0016LE-\u00138u_R\u000b7o\u001b\u000b\u0006i\u0005\u0005\u00151\u0011\u0005\u0006iN\u0001\r!\u001e\u0005\b\u0003C\u001a\u0002\u0019AA$\u000399W\r\u001e*fY\u0016\f7/\u001a'j].$B!!#\u0002\u000eB\u0019A.a#\n\u0007\u0005%R\u000eC\u0004\u0002\u0010R\u0001\r!a\u0012\u0002\u000fI,G.Z1tK\u0006Aa-Y5m)\u0006\u001c8\u000eF\u00035\u0003+\u000b9\nC\u0003u+\u0001\u0007Q\u000fC\u0004\u0002\u001aV\u0001\r!a\u0006\u0002\u000f5,7o]1hK\u0006a1m\\7qY\u0016$X\rV1tWR\u0019A'a(\t\u000bQ4\u0002\u0019A;")
public interface CreateReleaseTaskLogic
extends Logging {
    public XLReleaseEventBus eventBus();

    public ReleaseActorService releaseActorService();

    public ReleaseService releaseService();

    public CiIdService ciIdService();

    public AuthenticationService authenticationService();

    public PermissionChecker permissionChecker();

    public CommentService commentService();

    public static /* synthetic */ Void startTask$(CreateReleaseTaskLogic $this, CreateReleaseTask task) {
        return $this.startTask(task);
    }

    default public Void startTask(CreateReleaseTask task) {
        block5: {
            try {
                boolean shouldCompleteTask;
                boolean bl;
                this.validateRequiredProperties(task);
                UsernamePassword scriptUserPass = this.checkPermissions(task);
                this.validateCreateReleaseRecursion(task);
                Release subRelease = this.createRelease(task, scriptUserPass);
                this.saveCreatedReleaseIdIntoVariable(task, subRelease);
                if (task.getStartRelease()) {
                    this.checkPermissions(task, subRelease.getId(), XLReleasePermissions.START_RELEASE);
                    bl = this.startRelease(task, subRelease);
                } else {
                    bl = shouldCompleteTask = true;
                }
                if (shouldCompleteTask) {
                    this.saveCreatedReleaseIdIntoTask(task, subRelease);
                    this.completeTask(task);
                    break block5;
                }
                this.failTask(task, String.format("Release '%s' could not be started", subRelease.getTitle()));
            }
            catch (Exception ex) {
                this.logger().error((Function0 & Serializable)() -> String.format("Exception occurred while creating a release. Reason: %s.", ex.getMessage()), (Function0 & Serializable)() -> ex);
                this.failTask(task, ex.getMessage());
            }
        }
        return null;
    }

    private void validateCreateReleaseRecursion(CreateReleaseTask task) {
        if (Strings.isNotBlank((String)task.getTemplateIdVariable()) && Strings.isNotBlank((String)task.getRelease().getOriginTemplateId())) {
            String string = task.getRelease().getOriginTemplateId();
            String string2 = task.getTemplateId();
            Preconditions.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (Object)"The template that will be used to create a new release must be different from the template used to create the current release.");
            return;
        }
    }

    private void validateRequiredProperties(CreateReleaseTask task) {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)task.getNewReleaseTitle()), (Object)"Title of the release to be created cannot be empty.");
        String errorMessageTemplate = Strings.isNotBlank((String)task.getTemplateIdVariable()) ? new StringBuilder(81).append("Template that will be used to create a release couldn't be derived from variable ").append(task.getTemplateIdVariable()).toString() : "Template that will be used to create a release must be specified.";
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)task.getTemplateId()), (Object)errorMessageTemplate);
        Preconditions.checkArgument((boolean)this.releaseService().exists(task.getTemplateId()), (Object)new StringBuilder(59).append("Template provided in variable ").append(task.getTemplateIdVariable()).append(" must be a valid template id.").toString());
    }

    private UsernamePassword checkPermissions(CreateReleaseTask task) {
        return this.checkPermissions(task, task.getTemplateId(), null);
    }

    private UsernamePassword checkPermissions(CreateReleaseTask task, String releaseId, Permission requiredPermission) {
        UsernamePassword usernamePass = null;
        try {
            usernamePass = this.authenticationService().loginScriptUser((Task)task);
            String templateId = this.releaseService().getFullId(Ids.getFolderlessId((String)task.getTemplateId()));
            String targetFolderId = !Ids.isNullId((String)task.getFolderId()) ? task.getFolderId() : Ids.findFolderId((String)templateId);
            this.permissionChecker().checkIsAllowedToCreateReleaseFromTemplate(templateId, targetFolderId);
            if (requiredPermission != null) {
                this.permissionChecker().check(requiredPermission, releaseId);
            }
        }
        finally {
            this.authenticationService().logoutScriptUser();
        }
        return usernamePass;
    }

    private Release createRelease(CreateReleaseTask task, UsernamePassword scriptUsernamePass) {
        Release subReleaseTemplate = this.releaseService().findById(task.getTemplateId());
        Release releaseMetadata = this.getSubReleaseParamsFromTask(task, subReleaseTemplate);
        String rootReleaseId = Optional.ofNullable(task.getRelease().getRootReleaseId()).orElse(task.getRelease().getId());
        try {
            this.throwIfMaxConcurrencyReached(this.releaseService().findByIdIncludingArchived(rootReleaseId));
        }
        catch (NotFoundException ex) {
            this.logger().debug((Function0 & Serializable)() -> String.format("Root release not found. Missing release max concurrency check. Reason: %s.", ex.getMessage()), (Function0 & Serializable)() -> ex);
        }
        releaseMetadata.setRootReleaseId(rootReleaseId);
        releaseMetadata.setOwner(scriptUsernamePass.username());
        releaseMetadata.setScriptUsername(scriptUsernamePass.username());
        releaseMetadata.setScriptUserPassword(scriptUsernamePass.password());
        EncryptionHelper$.MODULE$.decrypt((ConfigurationItem)releaseMetadata);
        Release subRelease = this.releaseService().createFromTemplate(task.getTemplateId(), releaseMetadata, task.getFolderId());
        this.commentService().create((Task)task, String.format("Created release %s.", this.getReleaseLink(subRelease)), User.AUTHENTICATED_USER, true);
        this.eventBus().publish((XLReleaseEvent)new ReleaseCreatedEvent(subRelease, (ReleaseCreationSource)new CreatedFromCreateReleaseTask(task, subReleaseTemplate.getId())));
        return subRelease;
    }

    private boolean startRelease(CreateReleaseTask task, Release subRelease) {
        boolean hasBeenStarted;
        block0: {
            Release startedRelease = this.releaseActorService().startRelease(subRelease.getId(), User.SYSTEM);
            hasBeenStarted = startedRelease.getStatus().hasBeenStarted();
            if (!hasBeenStarted) break block0;
            this.commentService().create(task.getId(), String.format("Started release %s.", this.getReleaseLink(startedRelease)), User.AUTHENTICATED_USER, true);
            this.eventBus().publish((XLReleaseEvent)new ReleaseStartedFromCreateReleaseTaskEvent(task, subRelease));
        }
        return hasBeenStarted;
    }

    private void throwIfMaxConcurrencyReached(Release rootRelease) {
        int maxConcurrency = rootRelease.getMaxConcurrentReleases();
        List<Release> spawnedReleases = this.releaseService().findSpawnedReleases(rootRelease.getId(), maxConcurrency);
        int rootCount = rootRelease.isDefunct() ? 0 : 1;
        int currentlyRunning = spawnedReleases.size() + rootCount;
        this.logger().debug((Function0 & Serializable)() -> new Tuple4((Object)"maxConcurrency: {}, currently running releases ({}): {}", (Object)BoxesRunTime.boxToInteger((int)maxConcurrency), (Object)BoxesRunTime.boxToInteger((int)currentlyRunning), (Object)spawnedReleases));
        if (currentlyRunning >= maxConcurrency) {
            throw new IllegalStateException(String.format("Exceeded maximum number of concurrent releases created from %s. Current maximum is %s. This value can be configured in deployit-defaults.properties: xlrelease.Release.maxConcurrentReleases", rootRelease.getTitle(), BoxesRunTime.boxToInteger((int)maxConcurrency)));
        }
    }

    private Release getSubReleaseParamsFromTask(CreateReleaseTask task, Release subReleaseTemplate) {
        Map templateVariables = VariableHelper$.MODULE$.indexByKey(subReleaseTemplate.getVariables());
        List variablesShownOnReleaseStart = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().filter((Function1 & Serializable)variable -> BoxesRunTime.boxToBoolean((boolean)CreateReleaseTaskLogic.$anonfun$getSubReleaseParamsFromTask$1(templateVariables, variable)))).asJava();
        List variables = VariableHelper$.MODULE$.fillVariableValues(subReleaseTemplate.getVariables(), variablesShownOnReleaseStart);
        ArrayList subReleaseTags = new ArrayList(subReleaseTemplate.getTags());
        subReleaseTags.addAll(task.getReleaseTags());
        Release release = ReleaseBuilder.newRelease().withVariables(variables).withOriginTemplateId(task.getTemplateId()).withTitle(task.getNewReleaseTitle()).withOwner(task.getRelease().getScriptUsername()).withScriptUsername(task.getRelease().getScriptUsername()).withScriptUserPassword(task.getRelease().getScriptUserPassword()).withDisableNotifications(task.getRelease().isDisableNotifications()).withTags(subReleaseTags).build();
        release.setProperty("riskProfile", task.getProperty("riskProfile"));
        this.releaseService().setDatesFromTemplate(release, subReleaseTemplate);
        release.setStartedFromTaskId(task.getId());
        release.setAbortOnFailure(subReleaseTemplate.isAbortOnFailure());
        release.setAllowPasswordsInAllFields(subReleaseTemplate.isAllowPasswordsInAllFields());
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService());
        return release;
    }

    private void saveCreatedReleaseIdIntoVariable(CreateReleaseTask task, Release subRelease) {
        String variableKey;
        String variableName = "";
        if (VariableHelper$.MODULE$.containsOnlyVariable(task.getCreatedReleaseId())) {
            variableName = task.getCreatedReleaseId();
        }
        if (task.getVariableMapping().containsKey("createdReleaseId")) {
            variableName = (String)task.getVariableMapping().get("createdReleaseId");
        }
        String createdReleaseId = subRelease.getId();
        Map variablesByKeys = task.getRelease().getVariablesByKeys();
        if (variablesByKeys.containsKey(variableKey = VariableHelper$.MODULE$.withoutVariableSyntax(variableName))) {
            Variable variable = (Variable)variablesByKeys.get(variableKey);
            variable.setUntypedValue((Object)createdReleaseId);
            this.releaseActorService().updateVariable(variable.getId(), variable);
            return;
        }
    }

    private void saveCreatedReleaseIdIntoTask(CreateReleaseTask task, Release subRelease) {
        Object object = task.getVariableMapping().containsKey("createdReleaseId") ? task.getVariableMapping().remove("createdReleaseId") : BoxedUnit.UNIT;
        task.setCreatedReleaseId(subRelease.getId());
        this.releaseActorService().updateTask(task.getId(), (Task)task, Collections.singleton(TaskUpdateDirective.UPDATE_RELEASE_TASK), true);
    }

    private String getReleaseLink(Release release) {
        return String.format("[%s](#/releases/%s)", release.getTitle(), IdType.DOMAIN.convertToViewId(release.getId()));
    }

    private void failTask(CreateReleaseTask task, String message) {
        this.releaseActorService().failTaskAsync(task.getId(), FailureReasons.CREATE_RELEASE_TASK_FAILED.format(new Object[]{message}), User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)Option$.MODULE$.empty());
    }

    private void completeTask(CreateReleaseTask task) {
        this.releaseActorService().markTaskAsDoneAsync(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
    }

    public static /* synthetic */ boolean $anonfun$getSubReleaseParamsFromTask$1(Map templateVariables$1, Variable variable) {
        return templateVariables$1.containsKey(variable.getKey()) && ((Variable)templateVariables$1.get(variable.getKey())).getShowOnReleaseStart();
    }

    public static void $init$(CreateReleaseTaskLogic $this) {
    }
}

