/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.utils.ArchivedReleaseExporter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\u000e\u001d\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005m!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011M\u0003!Q1A\u0005\u0002QC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\u00069\u0002!\t!\u0018\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u001d\t)\u0001\u0001Q\u0001\nYD\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005]\u0001\u0001)A\u0005\u0003\u0017Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005M\u0002\u0001\"\u0001\u0002R!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!a3\u0001\t\u0013\ti\rC\u0004\u0002`\u0002!I!!9\t\u000f\u0005\r\b\u0001\"\u0003\u00026!9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBAv\u0001\u0011%\u0011Q\u0007\u0005\b\u0003[\u0004A\u0011BA\u001b\u0005u\t%o\u00195jm\u0016\u0004VO]4j]\u001e\u001c6\r[3ek2,7+\u001a:wS\u000e,'BA\u000f\u001f\u0003\u001d\u0019XM\u001d<jG\u0016T!a\b\u0011\u0002\u0013ad'/\u001a7fCN,'BA\u0011#\u0003%AXMY5bY\u0006\u00147OC\u0001$\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:mMRR'\"A\u0019\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\r\u0018\u0003\u000f1{wmZ5oO\u0006\u0001\u0012M]2iSZLgnZ*feZL7-Z\u000b\u0002mA\u0011q\u0007O\u0007\u00029%\u0011\u0011\b\b\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\f\u0011#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3!\u0003=\t'o\u00195jm&twmQ8oM&<W#A\u001f\u0011\u0005y\nU\"A \u000b\u0005\u0001s\u0012AB2p]\u001aLw-\u0003\u0002C\u007f\tA\u0012I]2iSZLgnZ*fiRLgnZ:NC:\fw-\u001a:\u0002!\u0005\u00148\r[5wS:<7i\u001c8gS\u001e\u0004\u0013!\u0006:fa>\u0014H/\u001b8h\u0015\u0012\u00147\rV3na2\fG/Z\u000b\u0002\rB\u0011q\tU\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005G>\u0014XM\u0003\u0002L\u0019\u0006!!\u000e\u001a2d\u0015\tie*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005y\u0015aA8sO&\u0011\u0011\u000b\u0013\u0002\r\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u0017e\u0016\u0004xN\u001d;j]\u001eTEMY2UK6\u0004H.\u0019;fA\u0005\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001LH\u0001\u0003I\nL!AW,\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u00051A(\u001b8jiz\"RAX0aC>\u0004\"a\u000e\u0001\t\u000bQJ\u0001\u0019\u0001\u001c\t\u000bmJ\u0001\u0019A\u001f\t\u000b\u0011K\u0001\u0019\u0001$)\t\u0005\u001cWN\u001c\t\u0003I.l\u0011!\u001a\u0006\u0003M\u001e\f!\"\u00198o_R\fG/[8o\u0015\tA\u0017.A\u0004gC\u000e$xN]=\u000b\u0005)d\u0015!\u00022fC:\u001c\u0018B\u00017f\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001E\u0011\u0015\u0019\u0016\u00021\u0001VQ\tI\u0011\u000f\u0005\u0002ee&\u00111/\u001a\u0002\n\u0003V$xn^5sK\u0012\f\u0011#[:DC:\u001cW\r\u001c*fcV,7\u000f^3e+\u00051\bcA<\u0002\u00025\t\u0001P\u0003\u0002zu\u00061\u0011\r^8nS\u000eT!a\u001f?\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002~}\u0006!Q\u000f^5m\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001y\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u0011\u0012n]\"b]\u000e,GNU3rk\u0016\u001cH/\u001a3!\u0003M\u0001XO]4f\u0013:\u0004&o\\4sKN\u001cHj\\2l+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tB`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0016\u0005=!AB(cU\u0016\u001cG/\u0001\u000bqkJ<W-\u00138Qe><'/Z:t\u0019>\u001c7\u000eI\u0001\u0010O\u0016$8I]8o'\u000eDW\rZ;mKV\u0011\u0011Q\u0004\t\u0005\u0003?\tiC\u0004\u0003\u0002\"\u0005%\u0002cAA\u0012Q5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0013A\u0002\u001fs_>$h(C\u0002\u0002,!\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0018\u0003c\u0011aa\u0015;sS:<'bAA\u0016Q\u0005a\u0001/\u001e:hK\u0006\u00138\r[5wKR\u0011\u0011q\u0007\t\u0004O\u0005e\u0012bAA\u001eQ\t!QK\\5uQ\ry\u0011q\b\t\u0005\u0003\u0003\ni%\u0004\u0002\u0002D)\u0019a-!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\b[\u0016$(/[2t\u0015\r\tYEI\u0001\tG>$\u0017\r[1mK&!\u0011qJA\"\u0005\u0015!\u0016.\\3e)\u0011\t9$a\u0015\t\u000f\u0005U\u0003\u00031\u0001\u0002X\u0005y!/\u001a;f]RLwN\u001c)fe&|G\r\u0005\u0003\u0002\u000e\u0005e\u0013\u0002BA.\u0003\u001f\u0011q!\u00138uK\u001e,'\u000fK\u0002\u0011\u0003\u007f\tQb\u0019:fCR,'k\\8u\t&\u0014H\u0003BA2\u0003_\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003Sr\u0018AA5p\u0013\u0011\ti'a\u001a\u0003\t\u0019KG.\u001a\u0005\b\u0003c\n\u0002\u0019AA\u000f\u0003\u0011\u0001\u0018\r\u001e5\u0002\u0015\u001d,GOU8pi\u0012K'\u000f\u0006\u0002\u0002xA)q%!\u001f\u0002d%\u0019\u00111\u0010\u0015\u0003\r=\u0003H/[8o\u0003y1\u0017N\u001c3B]\u0012\u0004&o\\2fgN\u0004VO]4bE2,'+\u001a7fCN,7\u000f\u0006\u0003\u0002\u0002\u0006\u001d\u0005cA\u0014\u0002\u0004&\u0019\u0011Q\u0011\u0015\u0003\u0007%sG\u000fC\u0004\u0002\nN\u0001\r!a#\u0002\t\u0011\fG/\u001a\t\u0005\u0003\u001b\u000by)D\u0001}\u0013\r\t\t\n \u0002\u0005\t\u0006$X-A\bqe>\u001cWm]:SK2,\u0017m]3t))\t9*!(\u00024\u0006u\u0016q\u0019\t\u0004O\u0005e\u0015bAANQ\t9!i\\8mK\u0006t\u0007bBAP)\u0001\u0007\u0011\u0011U\u0001\u000be\u0016dW-Y:f\u0013\u0012\u001c\bCBAR\u0003[\u000biB\u0004\u0003\u0002&\u0006%f\u0002BA\u0012\u0003OK\u0011!K\u0005\u0004\u0003WC\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003_\u000b\tL\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tY\u000b\u000b\u0005\b\u0003k#\u0002\u0019AA\\\u0003\u0015\u0019w.\u001e8u!\r9\u0018\u0011X\u0005\u0004\u0003wC(!D!u_6L7-\u00138uK\u001e,'\u000fC\u0004\u0002@R\u0001\r!!1\u0002%I,hn\u0015;beR$\u0016.\\3NS2d\u0017n\u001d\t\u0004O\u0005\r\u0017bAAcQ\t!Aj\u001c8h\u0011\u001d\tI\r\u0006a\u0001\u0003o\nqA]8pi\u0012K'/\u0001\u0007qkJ<WMU3mK\u0006\u001cX\r\u0006\u0004\u0002P\u0006e\u0017Q\u001c\t\u0007\u0003#\f).a\u000e\u000e\u0005\u0005M'BA?)\u0013\u0011\t9.a5\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002\\V\u0001\r!!\b\u0002\u0013I,G.Z1tK&#\u0007bBAe+\u0001\u0007\u0011qO\u0001\u0012O\u0016$8+Z1sG\"\u0004\u0016mZ3TSj,WCAAA\u00035\u0019H.Z3q\u0013\u001atU-\u001a3fI\u0006Q!/\u00198U_>duN\\4\u0015\t\u0005]\u0015\u0011\u001e\u0005\b\u0003\u007fC\u0002\u0019AAa\u0003\rygMZ\u0001\u000baJ,G)Z:ue>L\bf\u0001\u000e\u0002rB!\u00111_A~\u001b\t\t)PC\u0002g\u0003oT!!!?\u0002\u000b)\fg/\u0019=\n\t\u0005u\u0018Q\u001f\u0002\u000b!J,G)Z:ue>L\bf\u0001\u0001\u0003\u0002A!!1\u0001B\u0005\u001b\t\u0011)AC\u0002\u0003\b1\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011YA!\u0002\u0003\u000fM+'O^5dK\u0002")
public class ArchivePurgingScheduleService
implements Logging {
    private final ArchivingService archivingService;
    private final ArchivingSettingsManager archivingConfig;
    private final JdbcTemplate reportingJdbcTemplate;
    private final ArchivedReleases archivedReleases;
    private final AtomicBoolean isCancelRequested;
    private final Object purgeInProgressLock;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivePurgingScheduleService archivePurgingScheduleService = this;
        synchronized (archivePurgingScheduleService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ArchivingSettingsManager archivingConfig() {
        return this.archivingConfig;
    }

    public JdbcTemplate reportingJdbcTemplate() {
        return this.reportingJdbcTemplate;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    private AtomicBoolean isCancelRequested() {
        return this.isCancelRequested;
    }

    private Object purgeInProgressLock() {
        return this.purgeInProgressLock;
    }

    public String getCronSchedule() {
        return this.archivingConfig().getPurgingJobCronSchedule();
    }

    @Timed
    public void purgeArchive() {
        this.purgeArchive(this.archivingConfig().getMaximumArchiveRetentionPeriod());
    }

    @Timed
    public void purgeArchive(Integer retentionPeriod) {
        if (this.archivingConfig().getPurgingEnabled()) {
            long startPurging = System.currentTimeMillis();
            Date expirationDate = LocalDateTime.now().minusHours(Predef$.MODULE$.Integer2int(retentionPeriod)).toDate();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(62).append("Purging archived releases older than ").append(retentionPeriod).append(" hours (ended before ").append(expirationDate).append(")...").toString());
            Object object = this.purgeInProgressLock();
            synchronized (object) {
                int count = this.findAndProcessPurgableReleases(expirationDate);
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Purged ").append(count).append(" releases in ").append(System.currentTimeMillis() - startPurging).append(" ms").toString());
            }
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Purging archive is not enabled.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private File createRootDir(String path) {
        void var2_2;
        File rootDir = new File(path);
        if (!rootDir.exists()) {
            try {
                rootDir.mkdirs();
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(74).append("Created root directory for purged releases at '").append(rootDir.getAbsolutePath()).append("' based on provided path '").append(path).append("'").toString());
            }
            catch (Exception e) {
                String msg = new StringBuilder(55).append("Unable to create root directory for purged releases '").append(path).append("'.").toString();
                throw new IllegalStateException(msg, e);
            }
        }
        if (!rootDir.isDirectory()) {
            String msg = new StringBuilder(76).append("Purged release storage root directory path '").append(path).append("' does not point to a directory.").toString();
            throw new IllegalStateException(msg);
        }
        return var2_2;
    }

    private Option<File> getRootDir() {
        return this.archivingConfig().getExportOnPurgeEnabled() ? new Some((Object)this.createRootDir(this.archivingConfig().getPurgeExportPath())) : None$.MODULE$;
    }

    private int findAndProcessPurgableReleases(Date date) {
        AtomicInteger count;
        block3: {
            Option<File> rootDir = this.getRootDir();
            long runStartTimeMillis = System.currentTimeMillis();
            count = new AtomicInteger(0);
            boolean done = false;
            while (!done && !this.isCancelRequested().get()) {
                int pageSize = this.getSearchPageSize();
                this.logger().debug((Function0 & Serializable)() -> "Searching for releases that can be purged from the archive");
                Seq<String> releaseIds = this.archivingService().findPurgableReleaseIds(date, Predef$.MODULE$.int2Integer(pageSize));
                if (releaseIds.nonEmpty() && count.get() == 0) {
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(35).append("Purging releases that ended before ").append(date).toString());
                }
                if (done = this.processReleases((Iterable<String>)releaseIds, count, runStartTimeMillis, rootDir)) continue;
                if (releaseIds.isEmpty() || releaseIds.size() < pageSize) {
                    this.logger().debug((Function0 & Serializable)() -> new StringBuilder(59).append("Processed only ").append(releaseIds.size()).append(" finished releases on this page: we're done.").toString());
                    done = true;
                    continue;
                }
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(59).append("Purged ").append(count.get()).append(" releases that completed before ").append(date).append(", fetching the next ").append(pageSize).toString());
            }
            if (count.get() <= 0) break block3;
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(39).append("Purged ").append(count.get()).append(" releases that completed before ").append(date).toString());
        }
        return count.get();
    }

    private boolean processReleases(Iterable<String> releaseIds, AtomicInteger count, long runStartTimeMillis, Option<File> rootDir) {
        boolean bl;
        Object object = new Object();
        try {
            releaseIds.foreach((Function1 & Serializable)releaseId -> {
                ArchivePurgingScheduleService.$anonfun$processReleases$1(this, object, count, rootDir, runStartTimeMillis, releaseId);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private Try<BoxedUnit> purgeRelease(String releaseId, Option<File> rootDir) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option option = rootDir;
            if (option instanceof Some) {
                Some some = (Some)option;
                File dir = (File)some.value();
                ArchivedReleaseExporter exporter = new ArchivedReleaseExporter(this.reportingJdbcTemplate(), dir, this.archivedReleases());
                String path = exporter.exportReleaseData(releaseId);
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(54).append("Purging release [").append(releaseId).append("] from the archive, data exported to ").append(path).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            long s = System.currentTimeMillis();
            this.archivingService().purgeArchivedRelease(releaseId);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(41).append("Purged release [").append(releaseId).append("] from the archive in ").append(System.currentTimeMillis() - s).append(" ms").toString());
        }).recoverWith((PartialFunction)new Serializable(this, releaseId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivePurgingScheduleService $outer;
            private final String releaseId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable)() -> new StringBuilder(45).append("Could not purge release [").append($this.releaseId$1).append("] from the archive: ").append(exception.getMessage()).toString(), (Function0 & Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$1 = releaseId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivePurgingScheduleService$$anonfun$purgeRelease$4 java.lang.Exception ), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int getSearchPageSize() {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getPurgingSearchPageSize()) > 0 ? Predef$.MODULE$.Integer2int(this.archivingConfig().getPurgingSearchPageSize()) : 20;
    }

    private void sleepIfNeeded() {
        block2: {
            if (Predef$.MODULE$.Integer2int(this.archivingConfig().getPurgingSleepSecondsBetweenReleases()) <= 0) break block2;
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(53).append("Sleeping for ").append(this.archivingConfig().getPurgingSleepSecondsBetweenReleases()).append(" seconds before purging the next release").toString());
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int(this.archivingConfig().getPurgingSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Sleeping for ").append(this.archivingConfig().getPurgingSleepSecondsBetweenReleases()).append(" seconds was interrupted").toString());
            }
        }
    }

    private boolean ranTooLong(long runStartTimeMillis) {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getPurgingMaxSecondsPerRun()) > 0 ? System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int(this.archivingConfig().getPurgingMaxSecondsPerRun()) * 1000) : false;
    }

    private void off() {
        this.isCancelRequested().set(true);
        this.logger().debug((Function0 & Serializable)() -> "Waiting until no purging is in progress");
        Object object = this.purgeInProgressLock();
        synchronized (object) {
            this.logger().debug((Function0 & Serializable)() -> "Purging done, destroying ArchivePurgingScheduleService");
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.off();
    }

    public static final /* synthetic */ void $anonfun$processReleases$1(ArchivePurgingScheduleService $this, Object nonLocalReturnKey1$1, AtomicInteger count$3, Option rootDir$2, long runStartTimeMillis$1, String releaseId) {
        if ($this.isCancelRequested().get()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        if (count$3.get() > 0) {
            $this.sleepIfNeeded();
        }
        $this.purgeRelease(releaseId, (Option<File>)rootDir$2);
        count$3.incrementAndGet();
        if ($this.ranTooLong(runStartTimeMillis$1)) {
            $this.logger().warn((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(54).append("Purging paused because it ran for more than ").append($this.archivingConfig().getMaxSecondsPerRun()).append(" seconds. ").toString()).append("Purging will continue in the next run").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    @Autowired
    public ArchivePurgingScheduleService(ArchivingService archivingService, ArchivingSettingsManager archivingConfig, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate, ArchivedReleases archivedReleases) {
        this.archivingService = archivingService;
        this.archivingConfig = archivingConfig;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        this.archivedReleases = archivedReleases;
        Logging.$init$((Logging)this);
        this.isCancelRequested = new AtomicBoolean(false);
        this.purgeInProgressLock = new Object();
    }
}

