/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.json.JsonKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TemplateJsonHelper {
    private static final Set<String> DEFAULT_PROPERTIES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"id", "type"}));

    public static boolean isCustomScriptTask(JSONObject task) throws JSONException {
        return task.getString("type").equals(Type.valueOf(CustomScriptTask.class).toString());
    }

    public static boolean typeNotFound(JSONObject pythonScript) throws JSONException {
        return !Type.valueOf((String)pythonScript.getString("type")).exists();
    }

    public static boolean typeNotFound(ObjectNode pythonScript) {
        return !Type.valueOf((String)pythonScript.get("type").asText()).exists();
    }

    public static void resetToManualTask(JSONObject task) throws JSONException {
        Type manualTaskType = Type.valueOf(Task.class);
        task.put("type", (Object)manualTaskType.toString());
        HashSet propertiesOnManualTask = Sets.newHashSet();
        for (PropertyDescriptor propertyDescriptor : manualTaskType.getDescriptor().getPropertyDescriptors()) {
            propertiesOnManualTask.add(propertyDescriptor.getName());
        }
        HashSet propertiesOnUnknownTask = Sets.newHashSet();
        Iterator i = task.keys();
        while (i.hasNext()) {
            propertiesOnUnknownTask.add((String)i.next());
        }
        for (String property : propertiesOnUnknownTask) {
            if (propertiesOnManualTask.contains(property) || DEFAULT_PROPERTIES.contains(property)) continue;
            task.remove(property);
        }
    }

    public static void flagTask(JSONObject task, String warningMessage) throws JSONException {
        task.put("flagStatus", (Object)FlagStatus.ATTENTION_NEEDED);
        task.put("flagComment", (Object)warningMessage);
    }

    public static void flagTask(ObjectNode task, String warningMessage) {
        task.put("flagStatus", FlagStatus.ATTENTION_NEEDED.toString());
        task.put("flagComment", warningMessage);
    }

    public static List<JSONObject> getTasksFromRelease(JSONObject releaseJson) throws JSONException {
        ArrayList allTasks = Lists.newArrayList();
        if (!releaseJson.has("phases")) {
            return allTasks;
        }
        JSONArray phases = releaseJson.getJSONArray("phases");
        for (int i = 0; i < phases.length(); ++i) {
            JSONObject phaseJson = phases.getJSONObject(i);
            TemplateJsonHelper.getAllTasks(phaseJson, allTasks);
        }
        return allTasks;
    }

    public static List<ObjectNode> getTasksFromRelease(ObjectNode releaseJson) {
        ArrayList allTasks = Lists.newArrayList();
        if (!releaseJson.has("phases")) {
            return allTasks;
        }
        Iterator phases = releaseJson.get("phases").elements();
        while (phases.hasNext()) {
            JsonNode phaseJson = (JsonNode)phases.next();
            if (!(phaseJson instanceof ObjectNode)) continue;
            TemplateJsonHelper.getAllTasks((ObjectNode)phaseJson, allTasks);
        }
        return allTasks;
    }

    public static List<JSONObject> getDashboardsFromRelease(JSONObject releaseJson) throws JSONException {
        ArrayList allDashboards = Lists.newArrayList();
        if (!releaseJson.has(JsonKeys.extensions())) {
            return allDashboards;
        }
        JSONArray extensions = releaseJson.getJSONArray(JsonKeys.extensions());
        for (int i = 0; i < extensions.length(); ++i) {
            JSONObject extension = extensions.getJSONObject(i);
            if (!extension.has(JsonKeys.tiles()) || !extension.has("rows") || !extension.has("columns")) continue;
            allDashboards.add(extension);
        }
        return allDashboards;
    }

    private static void getAllTasks(ObjectNode containerJson, List<ObjectNode> allTasks) {
        if (containerJson.has("tasks")) {
            Iterator tasks = containerJson.get("tasks").elements();
            while (tasks.hasNext()) {
                JsonNode taskJson = (JsonNode)tasks.next();
                if (!(taskJson instanceof ObjectNode)) continue;
                allTasks.add((ObjectNode)taskJson);
                TemplateJsonHelper.getAllTasks((ObjectNode)taskJson, allTasks);
            }
        }
    }

    private static List<JSONObject> getAllTasks(JSONObject containerJson, List<JSONObject> allTasks) throws JSONException {
        if (!containerJson.has("tasks")) {
            return allTasks;
        }
        JSONArray tasks = containerJson.getJSONArray("tasks");
        for (int j = 0; j < tasks.length(); ++j) {
            JSONObject taskJson = tasks.getJSONObject(j);
            allTasks.add(taskJson);
            TemplateJsonHelper.getAllTasks(taskJson, allTasks);
        }
        return allTasks;
    }

    public static JSONObject getPhase(JSONObject taskJson, JSONObject releaseJson) throws JSONException {
        if (!releaseJson.has("phases")) {
            return null;
        }
        JSONArray phases = releaseJson.getJSONArray("phases");
        for (int i = 0; i < phases.length(); ++i) {
            JSONObject phaseJson = phases.getJSONObject(i);
            if (!TemplateJsonHelper.containsTask(phaseJson, taskJson)) continue;
            return phaseJson;
        }
        return null;
    }

    public static ObjectNode getPhase(ObjectNode taskJson, ObjectNode releaseJson) {
        if (!releaseJson.has("phases")) {
            return null;
        }
        Iterator phases = releaseJson.get("phases").elements();
        while (phases.hasNext()) {
            JsonNode phaseJson = (JsonNode)phases.next();
            if (!(phaseJson instanceof ObjectNode) || !TemplateJsonHelper.containsTask((ObjectNode)phaseJson, taskJson)) continue;
            return (ObjectNode)phaseJson;
        }
        return null;
    }

    private static boolean containsTask(JSONObject containerJson, JSONObject taskToFind) throws JSONException {
        if (!containerJson.has("tasks")) {
            return false;
        }
        JSONArray tasks = containerJson.getJSONArray("tasks");
        for (int j = 0; j < tasks.length(); ++j) {
            JSONObject taskJson = tasks.getJSONObject(j);
            if (taskToFind == taskJson) {
                return true;
            }
            if (!TemplateJsonHelper.containsTask(taskJson, taskToFind)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTask(ObjectNode containerJson, ObjectNode taskToFind) {
        if (!containerJson.has("tasks")) {
            return false;
        }
        Iterator tasks = containerJson.get("tasks").elements();
        while (tasks.hasNext()) {
            JsonNode taskJson = (JsonNode)tasks.next();
            if (!(taskJson instanceof ObjectNode)) continue;
            if (taskToFind == taskJson) {
                return true;
            }
            if (!TemplateJsonHelper.containsTask((ObjectNode)taskJson, taskToFind)) continue;
            return true;
        }
        return false;
    }
}

