/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.upgrade;

import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$TASKS$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$TASK_JOBS$;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NextCustomScriptTaskJob$;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.ResultSet;
import java.time.Instant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\b\u0010\u0001iA\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\ty\u0001\u0011\t\u0011)A\u0005a!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003@\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b=\u0003A\u0011\u0001)\t\u000b!\u0004A\u0011I5\t\u000b5\u0004A\u0011\t8\t\u000bU\u0004A\u0011\u0002<\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA\u001c\u0001\u0011%\u0011\u0011\b\u0002\u0015%\u0016\u001cwN^3ss\u0006\u001bGo\u001c:Va\u001e\u0014\u0018\rZ3\u000b\u0005A\t\u0012aB;qOJ\fG-\u001a\u0006\u0003%M\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005Q)\u0012!\u0003=me\u0016dW-Y:f\u0015\t1r#A\u0005yK\nL\u0017\r\\1cg*\t\u0001$A\u0002d_6\u001c\u0001aE\u0002\u00017\u0019\u0002\"\u0001\b\u0013\u000e\u0003uQ!\u0001\u0005\u0010\u000b\u0005}\u0001\u0013aA1qS*\u0011\u0011EI\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\r*\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005\u0015j\"aB+qOJ\fG-\u001a\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nQa\u001d7gi)T\u0011aK\u0001\tOJL'P\u001f7fI&\u0011Q\u0006\u000b\u0002\b\u0019><w-\u001b8h\u00031QGMY2UK6\u0004H.\u0019;f+\u0005\u0001\u0004CA\u0019;\u001b\u0005\u0011$BA\u001a5\u0003\u0011\u0019wN]3\u000b\u0005U2\u0014\u0001\u00026eE\u000eT!a\u000e\u001d\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!O\u0001\u0004_J<\u0017BA\u001e3\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,W#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t\u001b\u0012aB:feZL7-Z\u0005\u0003\t\u0006\u0013aBU3mK\u0006\u001cXmU3sm&\u001cW-A\bsK2,\u0017m]3TKJ4\u0018nY3!\u00035QwN\u0019*fa>\u001c\u0018\u000e^8ssV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002L#\u0005Q!/\u001a9pg&$xN]=\n\u00055S%!\u0004&pEJ+\u0007o\\:ji>\u0014\u00180\u0001\bk_\n\u0014V\r]8tSR|'/\u001f\u0011\u0002\rqJg.\u001b;?)\u0011\t6KY2\u0011\u0005I\u0003Q\"A\b\t\u000b9:\u0001\u0019\u0001\u0019)\tM+v\f\u0019\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000b!\"\u00198o_R\fG/[8o\u0015\tQ6,A\u0004gC\u000e$xN]=\u000b\u0005q3\u0014!\u00022fC:\u001c\u0018B\u00010X\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001b\u0003eAHN\u001d*fa>\u001c\u0018\u000e^8ss*#'m\u0019+f[Bd\u0017\r^3\t\u000bu:\u0001\u0019A \t\u000b\u0019;\u0001\u0019\u0001%)\u0005\u001d)\u0007C\u0001,g\u0013\t9wKA\u0005BkR|w/\u001b:fI\u0006qQ\u000f]4sC\u0012,g+\u001a:tS>tG#\u00016\u0011\u0005qY\u0017B\u00017\u001e\u0005\u001d1VM]:j_:\f\u0011\u0002Z8Va\u001e\u0014\u0018\rZ3\u0015\u0003=\u0004\"\u0001]:\u000e\u0003ET\u0011A]\u0001\u0006g\u000e\fG.Y\u0005\u0003iF\u0014qAQ8pY\u0016\fg.\u0001\bva\u001e\u0014\u0018\rZ3SK2,\u0017m]3\u0015\r]T\u0018qBA\r!\t\u0001\b0\u0003\u0002zc\n!QK\\5u\u0011\u0015Y(\u00021\u0001}\u0003%\u0011X\r\\3bg\u0016LE\rE\u0002~\u0003\u0013q1A`A\u0003!\ty\u0018/\u0004\u0002\u0002\u0002)\u0019\u00111A\r\u0002\rq\u0012xn\u001c;?\u0013\r\t9!]\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\u0011\u000fC\u0004\u0002\u0012)\u0001\r!a\u0005\u0002\u000fQ\f7o[%egB!Q0!\u0006}\u0013\u0011\t9\"!\u0004\u0003\u0007M+G\u000fC\u0004\u0002\u001c)\u0001\r!a\u0005\u0002'Q\f7o[%egRC\u0017\r\u001e%bm\u0016TuNY:\u0002!I,7/^7f\u001f:\u0014VmY8wKJLHcA8\u0002\"!9\u00111E\u0006A\u0002\u0005\u0015\u0012\u0001\u0002;bg.\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\u0019\u0012A\u00023p[\u0006Lg.\u0003\u0003\u00020\u0005%\"\u0001\u0002+bg.\faBZ1jY>s'+Z2pm\u0016\u0014\u0018\u0010F\u0002p\u0003kAq!a\t\r\u0001\u0004\t)#A\u0004uCN\\'+\u001a4\u0016\t\u0005m\u0012Q\n\u000b\u0005\u0003{\tI\u0006\u0005\u0004\u0002@\u0005\u0015\u0013\u0011J\u0007\u0003\u0003\u0003R1!a\u0011\u0014\u0003\u0019\u00198M]5qi&!\u0011qIA!\u0005E!\u0016m]6T_\u001a$(+\u001a4fe\u0016t7-\u001a\t\u0005\u0003\u0017\ni\u0005\u0004\u0001\u0005\u000f\u0005=SB1\u0001\u0002R\t\tA+\u0005\u0003\u0002T\u0005\u0015\u0002c\u00019\u0002V%\u0019\u0011qK9\u0003\u000f9{G\u000f[5oO\"9\u00111E\u0007A\u0002\u0005%\u0003")
public class RecoveryActorUpgrade
extends Upgrade
implements Logging {
    private final JdbcTemplate jdbcTemplate;
    private final ReleaseService releaseService;
    private final JobRepository jobRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RecoveryActorUpgrade recoveryActorUpgrade = this;
        synchronized (recoveryActorUpgrade) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)"10.3.0#2");
    }

    public boolean doUpgrade() {
        this.logger().info((Function0 & Serializable)() -> "Finding tasks, that should be executed, but do not have relevant jobs in the queue");
        Map taskIdsToCheckByReleaseId = CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n         |SELECT ").append(Schema$TASKS$.MODULE$.TASK_ID()).append("\n         |FROM ").append(Schema$TASKS$.MODULE$.TABLE()).append("\n         |WHERE ").append(Schema$TASKS$.MODULE$.STATUS()).append(" = '").append(TaskStatus.IN_PROGRESS.value()).append("'\n         |   OR ").append(Schema$TASKS$.MODULE$.STATUS()).append(" = '").append(TaskStatus.ABORT_SCRIPT_IN_PROGRESS.value()).append("'\n         |   OR ").append(Schema$TASKS$.MODULE$.STATUS()).append(" = '").append(TaskStatus.FAILURE_HANDLER_IN_PROGRESS.value()).append("'\n         |   OR ").append(Schema$TASKS$.MODULE$.STATUS()).append(" = '").append(TaskStatus.FACET_CHECK_IN_PROGRESS.value()).append("'\n         |   OR ").append(Schema$TASKS$.MODULE$.STATUS()).append(" = '").append(TaskStatus.PRECONDITION_IN_PROGRESS.value()).append("'\n         |").toString())), (RowMapper)new RowMapper<String>(null){

            public String mapRow(ResultSet rs, int rowNum) {
                return rs.getString(1);
            }
        })).asScala().groupBy((Function1 & Serializable)x$1 -> Ids.releaseIdFrom((String)x$1));
        Set taskIdsThatHaveJobs = CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(45).append("\n         |SELECT ").append(Schema$TASK_JOBS$.MODULE$.TASK_ID()).append("\n         |FROM ").append(Schema$TASK_JOBS$.MODULE$.TABLE()).append("\n         |").toString())), (RowMapper)new RowMapper<String>(null){

            public String mapRow(ResultSet rs, int rowNum) {
                return Ids.getFolderlessId((String)rs.getString(1));
            }
        })).asScala().toSet();
        taskIdsToCheckByReleaseId.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String releaseId = (String)tuple2._1();
                Buffer taskIds = (Buffer)tuple2._2();
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.upgradeRelease(releaseId, (Set<String>)taskIds.toSet(), (Set<String>)taskIdsThatHaveJobs)).recover((PartialFunction)new Serializable(this, releaseId){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ RecoveryActorUpgrade $outer;
                    private final String releaseId$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                        A1 A1 = e;
                        this.$outer.logger().error((Function0 & Serializable)() -> new StringBuilder(37).append("Unable to process release ").append($this.releaseId$1).append(", giving up").toString(), (Function0 & Serializable)() -> e);
                        return (B1)BoxedUnit.UNIT;
                    }

                    public final boolean isDefinedAt(Throwable e) {
                        Throwable throwable = e;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.releaseId$1 = releaseId$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.upgrade.RecoveryActorUpgrade$$anonfun$$nestedInanonfun$doUpgrade$3$1 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                    }
                });
            }
            throw new MatchError((Object)tuple2);
        });
        this.logger().info((Function0 & Serializable)() -> "Done");
        return true;
    }

    private void upgradeRelease(String releaseId, Set<String> taskIds, Set<String> taskIdsThatHaveJobs) {
        Release release = this.releaseService().findById(releaseId);
        Seq tasksToCheck = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)RecoveryActorUpgrade.$anonfun$upgradeRelease$1(taskIds, taskIdsThatHaveJobs, task)))).toSeq();
        tasksToCheck.foreach((Function1 & Serializable)task -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.resumeOnRecovery((Task)task)) {
                this.jobRepository().create(JobRow$.MODULE$.apply(NextCustomScriptTaskJob$.MODULE$.apply(this.taskRef((CustomScriptTask)task), (Duration)Duration$.MODULE$.Zero())));
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(23).append("Task ").append(task.getId()).append(" will be recovered").toString());
                return;
            }
            if (this.failOnRecovery((Task)task)) {
                Some some;
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(20).append("Task ").append(task.getId()).append(" will be failed").toString());
                TaskStatus taskStatus = task.getStatus();
                if (TaskStatus.PRECONDITION_IN_PROGRESS.equals(taskStatus)) {
                    some = new Some((Object)new PreconditionJob(this.taskRef(task)));
                } else if (TaskStatus.FAILURE_HANDLER_IN_PROGRESS.equals(taskStatus)) {
                    some = new Some((Object)new FailureHandlerJob(this.taskRef(task)));
                } else if (TaskStatus.FACET_CHECK_IN_PROGRESS.equals(taskStatus)) {
                    some = new Some((Object)new FacetCheckJob(this.taskRef(task)));
                } else if (TaskStatus.ABORT_SCRIPT_IN_PROGRESS.equals(taskStatus)) {
                    some = new Some((Object)new CustomScriptTaskJob(this.taskRef((CustomScriptTask)task)));
                } else if (TaskStatus.IN_PROGRESS.equals(taskStatus)) {
                    Task task = task;
                    if (task instanceof CustomScriptTask) {
                        CustomScriptTask customScriptTask = (CustomScriptTask)task;
                        some = new Some((Object)new CustomScriptTaskJob(this.taskRef(customScriptTask)));
                    } else if (task instanceof ResolvableScriptTask) {
                        ResolvableScriptTask resolvableScriptTask = (ResolvableScriptTask)task;
                        some = new Some((Object)new ScriptTaskJob(this.taskRef(resolvableScriptTask)));
                    } else if (task instanceof CreateReleaseTask) {
                        CreateReleaseTask createReleaseTask = (CreateReleaseTask)task;
                        some = new Some((Object)new CreateReleaseTaskJob(this.taskRef(createReleaseTask)));
                    } else if (task instanceof NotificationTask) {
                        NotificationTask notificationTask = (NotificationTask)task;
                        some = new Some((Object)new NotificationTaskJob(this.taskRef(notificationTask)));
                    } else {
                        some = None$.MODULE$;
                    }
                } else {
                    some = None$.MODULE$;
                }
                some.map((Function1 & Serializable)taskJob -> {
                    JobRow qual$1 = JobRow$.MODULE$.apply((Job)taskJob);
                    JobStatus x$1 = JobStatus.RESERVED;
                    long x$2 = qual$1.copy$default$1();
                    String x$3 = qual$1.copy$default$2();
                    JobType x$4 = qual$1.copy$default$3();
                    long x$5 = qual$1.copy$default$5();
                    Instant x$6 = qual$1.copy$default$6();
                    Instant x$7 = qual$1.copy$default$7();
                    Instant x$8 = qual$1.copy$default$8();
                    String x$9 = qual$1.copy$default$9();
                    Integer x$10 = qual$1.copy$default$10();
                    String x$11 = qual$1.copy$default$11();
                    JobRow jobRow = qual$1.copy(x$2, x$3, x$4, JobStatus.RESERVED, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
                    return new Tuple2(taskJob, (Object)jobRow);
                }).foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        JobRow jobRow = (JobRow)tuple2._2();
                        return this.jobRepository().create(jobRow);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
        }).recover((PartialFunction)new Serializable(this, (Task)task){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RecoveryActorUpgrade $outer;
            private final Task task$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                this.$outer.logger().error((Function0 & Serializable)() -> new StringBuilder(34).append("Unable to process task ").append($this.task$1.getId()).append(", giving up").toString(), (Function0 & Serializable)() -> e);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(com.xebialabs.xlrelease.scheduler.upgrade.RecoveryActorUpgrade$$anonfun$$nestedInanonfun$upgradeRelease$2$1 ), $anonfun$applyOrElse$4(java.lang.Throwable )}, serializedLambda);
            }
        }));
    }

    private boolean resumeOnRecovery(Task task) {
        CustomScriptTask customScriptTask;
        Task task2 = task;
        return task2 instanceof CustomScriptTask && ((customScriptTask = (CustomScriptTask)task2).hasNextScriptToExecute() || customScriptTask.isWaitingForSignal());
    }

    private boolean failOnRecovery(Task task) {
        Task task2 = task;
        if (task.isFailureHandlerInProgress() || task.isFacetInProgress() || task.isPreconditionInProgress()) {
            return true;
        }
        if (task instanceof TaskGroup) {
            return false;
        }
        return task.isAutomated() && (task.isInProgress() || task.isAbortScriptInProgress());
    }

    private <T extends Task> TaskSoftReference<T> taskRef(T task) {
        return new TaskSoftReference<Task>(task, () -> task);
    }

    public static final /* synthetic */ boolean $anonfun$upgradeRelease$1(Set taskIds$2, Set taskIdsThatHaveJobs$2, Task task) {
        String taskFolderlessId = Ids.getFolderlessId((String)task.getId());
        return taskIds$2.contains((Object)taskFolderlessId) && !taskIdsThatHaveJobs$2.contains((Object)taskFolderlessId);
    }

    @Autowired
    public RecoveryActorUpgrade(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, ReleaseService releaseService, JobRepository jobRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.releaseService = releaseService;
        this.jobRepository = jobRepository;
        Logging.$init$((Logging)this);
    }
}

