/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivedReleaseDeserialization;
import com.xebialabs.xlrelease.service.ArchivedReleaseReader;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0005\u0011}t!B\u001e=\u0011\u0003)e!B$=\u0011\u0003A\u0005\"B,\u0002\t\u0003A\u0006\"B-\u0002\t\u0003Qf\u0001B$=\u0001ID\u0001B\u001e\u0003\u0003\u0006\u0004%\ta\u001e\u0005\t}\u0012\u0011\t\u0011)A\u0005q\"Iq\u0010\u0002B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u000f!!\u0011!Q\u0001\n\u0005%\u0001BCA\b\t\t\u0015\r\u0011\"\u0001\u0002\u0012!Q\u00111\u0005\u0003\u0003\u0002\u0003\u0006I!a\u0005\t\u0015\u0005\u0015BA!A!\u0002\u0013\t9\u0003\u0003\u0006\u0002.\u0011\u0011\t\u0011)A\u0005\u0003_A!\"!\u000f\u0005\u0005\u0003\u0005\u000b\u0011BA\u001e\u0011)\t\t\u0005\u0002B\u0001B\u0003%\u00111\t\u0005\u000b\u0003\u001f\"!\u0011!Q\u0001\n\u0005E\u0003BCA,\t\t\u0005\t\u0015!\u0003\u0002Z!Q\u0011q\f\u0003\u0003\u0002\u0003\u0006I!!\u0019\t\u0015\u0005\u001dDA!A!\u0002\u0013\tI\u0007\u0003\u0006\u0002p\u0011\u0011\t\u0011)A\u0005\u0003cBaa\u0016\u0003\u0005\u0002\u0005]\u0004bBAX\t\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003#$A\u0011BAj\u0011\u001d\t9\u000f\u0002C\u0005\u0003SDq!!<\u0005\t\u0013\ty\u000fC\u0004\u0002t\u0012!\t!!>\t\u000f\t\u0005A\u0001\"\u0001\u0003\u0004!9!\u0011\u0002\u0003\u0005\u0002\t-\u0001b\u0002B\b\t\u0011\u0005!\u0011\u0003\u0005\b\u0005\u001f!A\u0011\u0001B\u000b\u0011\u001d\u0011y\u0002\u0002C\u0001\u0005CAqAa\n\u0005\t\u0003\u0011I\u0003C\u0004\u00038\u0011!\tA!\u000f\t\u000f\t\u001dC\u0001\"\u0001\u0003J!9!Q\f\u0003\u0005\u0002\t}\u0003b\u0002B4\t\u0011\u0005!\u0011\u000e\u0005\b\u0005_\"A\u0011\u0001B9\u0011\u001d\u0011I\b\u0002C\u0001\u0005wBqA!!\u0005\t\u0003\u0011\u0019\tC\u0004\u0003\f\u0012!\tA!$\t\u000f\teE\u0001\"\u0001\u0003\u001c\"9!q\u0015\u0003\u0005\u0002\t%\u0006b\u0002BT\t\u0011\u0005!Q\u001b\u0005\b\u0005S$A\u0011\u0001Bv\u0011%\u0019y\u0004BI\u0001\n\u0003\u0019\t\u0005C\u0005\u0004V\u0011\t\n\u0011\"\u0001\u0004B!91q\u000b\u0003\u0005\u0002\re\u0003bBB<\t\u0011\u00051\u0011\u0010\u0005\b\u0007\u007f\"A\u0011ABA\u0011\u001d\u0019\t\u000b\u0002C\u0001\u0007GCqaa+\u0005\t\u0003\u0019i\u000bC\u0004\u00044\u0012!\ta!.\t\u000f\rmF\u0001\"\u0001\u0004>\"9!q\u0015\u0003\u0005\n\r-\u0007bBBj\t\u0011\u00051Q\u001b\u0005\b\u0007;$A\u0011ABp\u0011\u001d\u0019\t\u0010\u0002C\u0005\u0007gDq\u0001\"\t\u0005\t\u0013!\u0019\u0003C\u0004\u0005*\u0011!I\u0001b\u000b\u0002!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,'BA\u001f?\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0010!\u0002\u0013ad'/\u001a7fCN,'BA!C\u0003%AXMY5bY\u0006\u00147OC\u0001D\u0003\r\u0019w.\\\u0002\u0001!\t1\u0015!D\u0001=\u0005A\t%o\u00195jm&twmU3sm&\u001cWmE\u0002\u0002\u0013>\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013a!\u00118z%\u00164\u0007C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0016\u0001C4sSjTH.\u001a3\n\u0005Y\u000b&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u000bAbZ3u\u001b>tG\u000f[-fCJ$\"a\u00174\u0011\u0005q\u001bgBA/b!\tq6*D\u0001`\u0015\t\u0001G)\u0001\u0004=e>|GOP\u0005\u0003E.\u000ba\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!m\u0013\u0005\u0006O\u000e\u0001\r\u0001[\u0001\ngR\f'\u000f\u001e#bi\u0016\u0004\"!\u001b9\u000e\u0003)T!a\u001b7\u0002\tQLW.\u001a\u0006\u0003[:\fAA[8eC*\tq.A\u0002pe\u001eL!!\u001d6\u0003\u0011\u0011\u000bG/\u001a+j[\u0016\u001cB\u0001B%t\u001fB\u0011a\t^\u0005\u0003kr\u0012Q#\u0011:dQ&4X\r\u001a*fY\u0016\f7/\u001a*fC\u0012,'/\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\t\u0001\u0010\u0005\u0002zy6\t!P\u0003\u0002|}\u0005\u0011AMY\u0005\u0003{j\u0014\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002#\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b%\u0001\fbe\u000eD\u0017N^3e%\u0016dW-Y:fgN+\u0017M]2i!\rI\u00181A\u0005\u0004\u0003\u000bQ(AF!sG\"Lg/\u001a3SK2,\u0017m]3t'\u0016\f'o\u00195\u0002=\u0005\u00148\r[5wK\u0012\f5\r^5wSRLHj\\4t'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bc\u0001$\u0002\f%\u0019\u0011Q\u0002\u001f\u0003=\u0005\u00138\r[5wK\u0012\f5\r^5wSRLHj\\4t'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0004\u0003;\u0001\u0015\u0001\u00033fa2|\u00170\u001b;\n\t\u0005\u0005\u0012q\u0003\u0002\u0012%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\nadY8na2,G/\u001a3SK2,\u0017m]3t\u000bb\u0004xN\u001d;TKJ4\u0018nY3\u0011\u0007\u0019\u000bI#C\u0002\u0002,q\u0012QdQ8na2,G/\u001a3SK2,\u0017m]3FqB|'\u000f^*feZL7-Z\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b\u0003BA\u0019\u0003ki!!a\r\u000b\u0007\u0005ea(\u0003\u0003\u00028\u0005M\"!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006!B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\u0004B!!\r\u0002>%!\u0011qHA\u001a\u0005Q!U\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss\u0006\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB!\u0011QIA&\u001b\t\t9EC\u0002\u0002Jy\na!Y2u_J\u001c\u0018\u0002BA'\u0003\u000f\u00121CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fa\u0002^3b[J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u00022\u0005M\u0013\u0002BA+\u0003g\u0011a\u0002V3b[J+\u0007o\\:ji>\u0014\u00180\u0001\u0006tK\u000e,(/\u001a3DSN\u0004B!!\r\u0002\\%!\u0011QLA\u001a\u0005)\u0019VmY;sK\u0012\u001c\u0015n]\u0001\u001ce\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u0011\t\u0005E\u00121M\u0005\u0005\u0003K\n\u0019DA\u000eSK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/_\u0001\u000fG>lW.\u001a8u'\u0016\u0014h/[2f!\r1\u00151N\u0005\u0004\u0003[b$AD\"p[6,g\u000e^*feZL7-Z\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000f\u0005\u0003\u00022\u0005M\u0014\u0002BA;\u0003g\u0011\u0011DR1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195feRa\u0012\u0011PA>\u0003{\ny(!!\u0002\u0004\u0006\u0015\u0015qQAE\u0003\u0017\u000bi)a$\u0002\u0012\u0006M\u0005C\u0001$\u0005\u0011\u00151H\u00031\u0001y\u0011\u0019yH\u00031\u0001\u0002\u0002!9\u0011q\u0001\u000bA\u0002\u0005%\u0001bBA\b)\u0001\u0007\u00111\u0003\u0005\b\u0003K!\u0002\u0019AA\u0014\u0011\u001d\ti\u0003\u0006a\u0001\u0003_Aq!!\u000f\u0015\u0001\u0004\tY\u0004C\u0004\u0002BQ\u0001\r!a\u0011\t\u000f\u0005=C\u00031\u0001\u0002R!9\u0011q\u000b\u000bA\u0002\u0005e\u0003bBA0)\u0001\u0007\u0011\u0011\r\u0005\b\u0003O\"\u0002\u0019AA5\u0011\u001d\ty\u0007\u0006a\u0001\u0003cB3\u0001FAL!\u0011\tI*a+\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\t\t+a)\u0002\u000f\u0019\f7\r^8ss*!\u0011QUAT\u0003\u0015\u0011W-\u00198t\u0015\r\tIK\\\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u0011QVAN\u0005%\tU\u000f^8xSJ,G-\u0001\bbe\u000eD\u0017N^3SK2,\u0017m]3\u0015\t\u0005M\u0016\u0011\u0018\t\u0004\u0015\u0006U\u0016bAA\\\u0017\n!QK\\5u\u0011\u0019\tY,\u0006a\u00017\u0006I!/\u001a7fCN,\u0017\n\u001a\u0015\u0004+\u0005}\u0006\u0003BAa\u0003\u001bl!!a1\u000b\t\u0005u\u0015Q\u0019\u0006\u0005\u0003\u000f\fI-A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005-')\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ty-a1\u0003\u000bQKW.\u001a3\u0002\u001b\u0011,G.\u001a;f%\u0016dW-Y:f)\u0019\t\u0019,!6\u0002X\"1\u00111\u0018\fA\u0002mCq!!7\u0017\u0001\u0004\tY.A\u0004sK2,\u0017m]3\u0011\t\u0005u\u00171]\u0007\u0003\u0003?T1!!9?\u0003\u0019!w.\\1j]&!\u0011Q]Ap\u0005\u001d\u0011V\r\\3bg\u0016\f!#\u0019:dQ&4X-\u0011;uC\u000eDW.\u001a8ugR!\u00111WAv\u0011\u001d\tIn\u0006a\u0001\u00037\f1#\u0019:dQ&4X\rR3qK:$WM\\2jKN$B!a-\u0002r\"9\u0011\u0011\u001c\rA\u0002\u0005m\u0017a\u00063fY\u0016$X\r\u0015:f\u0003J\u001c\u0007.\u001b<f%\u0016dW-Y:f)\u0011\t90!@\u0011\u0007)\u000bI0C\u0002\u0002|.\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002<f\u0001\ra\u0017\u0015\u00043\u0005}\u0016!\u00059sK\u0006\u00138\r[5wKJ+G.Z1tKR!\u00111\u0017B\u0003\u0011\u001d\tIN\u0007a\u0001\u00037D3AGA`\u00035\u0019\bn\\;mI\u0006\u00138\r[5wKR!\u0011q\u001fB\u0007\u0011\u001d\tIn\u0007a\u0001\u00037\f!bZ3u%\u0016dW-Y:f)\u0011\tYNa\u0005\t\r\u0005mF\u00041\u0001\\)\u0019\tYNa\u0006\u0003\u001a!1\u00111X\u000fA\u0002mCqAa\u0007\u001e\u0001\u0004\t90\u0001\nj]\u000edW\u000fZ3Qe\u0016\f%o\u00195jm\u0016$\u0007fA\u000f\u0002@\u0006yq-\u001a;SK2,\u0017m]3USRdW\rF\u0002\\\u0005GAa!a/\u001f\u0001\u0004Y\u0006f\u0001\u0010\u0002@\u0006Aq-\u001a;QQ\u0006\u001cX\r\u0006\u0003\u0003,\tE\u0002\u0003BAo\u0005[IAAa\f\u0002`\n)\u0001\u000b[1tK\"1!1G\u0010A\u0002m\u000bq\u0001\u001d5bg\u0016LE\rK\u0002 \u0003\u007f\u000bqaZ3u)\u0006\u001c8\u000e\u0006\u0003\u0003<\t\u0005\u0003\u0003BAo\u0005{IAAa\u0010\u0002`\n!A+Y:l\u0011\u0019\u0011\u0019\u0005\ta\u00017\u00061A/Y:l\u0013\u0012D3\u0001IA`\u0003-9W\r\u001e,be&\f'\r\\3\u0015\t\t-#q\u000b\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)!!\u0011KAp\u0003%1\u0018M]5bE2,7/\u0003\u0003\u0003V\t=#\u0001\u0003,be&\f'\r\\3\t\r\te\u0013\u00051\u0001\\\u0003)1\u0018M]5bE2,\u0017\n\u001a\u0015\u0004C\u0005}\u0016AB3ySN$8\u000f\u0006\u0003\u0002x\n\u0005\u0004B\u0002B2E\u0001\u00071,\u0001\u0003dS&#\u0007f\u0001\u0012\u0002@\u0006\tR\r_5tiN\u0004&/Z!sG\"Lg/\u001a3\u0015\t\u0005](1\u000e\u0005\u0007\u0005G\u001a\u0003\u0019A.)\u0007\r\ny,\u0001\u0007fq&\u001cHo\u001d\"z\u001d\u0006lW\r\u0006\u0003\u0002x\nM\u0004B\u0002B;I\u0001\u00071,A\u0006sK2,\u0017m]3OC6,\u0007f\u0001\u0013\u0002@\u0006\u00012\r[3dW:{G/\u0011:dQ&4X\r\u001a\u000b\u0005\u0003g\u0013i\b\u0003\u0004\u0003d\u0015\u0002\ra\u0017\u0015\u0004K\u0005}\u0016\u0001E1ui\u0006\u001c\u0007.\\3oi\u0016C\u0018n\u001d;t)\u0011\t9P!\"\t\r\t\u001de\u00051\u0001\\\u00031\tG\u000f^1dQ6,g\u000e^%eQ\r1\u0013qX\u0001\u000eO\u0016$\u0018\t\u001e;bG\"lWM\u001c;\u0015\t\t=%Q\u0013\t\u0005\u0003;\u0014\t*\u0003\u0003\u0003\u0014\u0006}'AC!ui\u0006\u001c\u0007.\\3oi\"1!qQ\u0014A\u0002mC3aJA`\u0003M9W\r^!ui\u0006\u001c\u0007.\\3oi>\u0003H/[8o)\u0011\u0011iJa)\u0011\u000b)\u0013yJa$\n\u0007\t\u00056J\u0001\u0004PaRLwN\u001c\u0005\u0007\u0005\u000fC\u0003\u0019A.)\u0007!\ny,\u0001\btK\u0006\u00148\r\u001b*fY\u0016\f7/Z:\u0015\t\t-&1\u0018\t\u0007\u0005[\u00139,a7\u000e\u0005\t=&\u0002\u0002BY\u0005g\u000bA!\u001e;jY*\u0011!QW\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003:\n=&\u0001\u0002'jgRDqA!0*\u0001\u0004\u0011y,A\u0004gS2$XM]:\u0011\t\t\u0005'qZ\u0007\u0003\u0005\u0007TAA!2\u0003H\u0006)am\u001c:ng*!!\u0011\u001aBf\u0003\t1\u0018GC\u0002\u0003Nz\n1!\u00199j\u0013\u0011\u0011\tNa1\u0003\u001fI+G.Z1tKN4\u0015\u000e\u001c;feND3!KA`)!\u0011YKa6\u0003Z\n\r\bb\u0002B_U\u0001\u0007!q\u0018\u0005\b\u00057T\u0003\u0019\u0001Bo\u0003\u0015a\u0017.\\5u!\rQ%q\\\u0005\u0004\u0005C\\%\u0001\u0002'p]\u001eDqA!:+\u0001\u0004\u0011i.\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0004U\u0005}\u0016A\r4j]\u0012\u001c\u0006n\u001c:u%\u0016dW-Y:f\u0013\u0012\u001cx+\u001b;i\r>dG-\u001a:OC6,\u0017I\u001c3Pe\u0012,'o\u0011:ji\u0016\u0014\u0018n\u001c8\u0015\u0015\t58QCB\u0016\u0007o\u0019Y\u0004\u0005\u0004\u0003p\ne(Q \b\u0005\u0005c\u0014)PD\u0002_\u0005gL\u0011\u0001T\u0005\u0004\u0005o\\\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005s\u0013YPC\u0002\u0003x.\u0003rA\u0013B\u0000\u0007\u0007\u0019y!C\u0002\u0004\u0002-\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BB\u0003\u0007\u0017i!aa\u0002\u000b\t\r%\u0011q\\\u0001\u0006kRLGn]\u0005\u0005\u0007\u001b\u00199AA\tBI\u0006\u0004H/\u001b<f%\u0016dW-Y:f\u0013\u0012\u00042ASB\t\u0013\r\u0019\u0019b\u0013\u0002\u0004\u0003:L\bb\u0002B_W\u0001\u00071q\u0003\t\u0007\u0005_\u001cIb!\b\n\t\rm!1 \u0002\u0004'\u0016\f\b\u0003BB\u0010\u0007Oi!a!\t\u000b\t\tu61\u0005\u0006\u0004\u0007Kq\u0014a\u0002:fa>\u0014Ho]\u0005\u0005\u0007S\u0019\tC\u0001\u0007SKB|'\u000f\u001e$jYR,'\u000fC\u0004\u0004.-\u0002\raa\f\u0002\u000b=\u0014H-\u001a:\u0011\u000b)\u0013yj!\r\u0011\t\t\u000571G\u0005\u0005\u0007k\u0011\u0019M\u0001\tSK2,\u0017m]3Pe\u0012,'/T8eK\"I!1\\\u0016\u0011\u0002\u0003\u00071\u0011\b\t\u0006\u0015\n}%Q\u001c\u0005\n\u0005K\\\u0003\u0013!a\u0001\u0007sA3aKA`\u0003q2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\r#\u0006BB\u001d\u0007\u000bZ#aa\u0012\u0011\t\r%3\u0011K\u0007\u0003\u0007\u0017RAa!\u0014\u0004P\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;[\u0015\u0002BB*\u0007\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tG\u0005Z3gCVdG\u000f\n\u001b\u0002+\r|WO\u001c;SK2,\u0017m]3t\u0005f\u001cF/\u0019;vgR!11LB:!\u001da6QLB1\u0007[J1aa\u0018f\u0005\ri\u0015\r\u001d\t\u0005\u0007G\u001aI'\u0004\u0002\u0004f)!1qMAp\u0003\u0019\u0019H/\u0019;vg&!11NB3\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vgB\u0019!ja\u001c\n\u0007\rE4JA\u0002J]RDqA!0/\u0001\u0004\u0011y\fK\u0002/\u0003\u007f\u000bQbY8v]R\u0014V\r\\3bg\u0016\u001cH\u0003BB.\u0007wBqA!00\u0001\u0004\u00199\u0002K\u00020\u0003\u007f\u000b\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0019\u0019i!\"\u0004\u0010B)!q^B\r7\"91q\u0011\u0019A\u0002\r%\u0015\u0001\u00023bi\u0016\u0004BA!,\u0004\f&!1Q\u0012BX\u0005\u0011!\u0015\r^3\t\u000f\rE\u0005\u00071\u0001\u0004\u0014\u0006A\u0001/Y4f'&TX\r\u0005\u0003\u0004\u0016\u000emUBABL\u0015\u0011\u0019IJa-\u0002\t1\fgnZ\u0005\u0005\u0007;\u001b9JA\u0004J]R,w-\u001a:)\u0007A\ny,\u0001\fgS:$\u0007+\u001e:hC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0019\u0019i!*\u0004(\"91qQ\u0019A\u0002\r%\u0005bBBIc\u0001\u000711\u0013\u0015\u0004c\u0005}\u0016\u0001\u00069ve\u001e,\u0017I]2iSZ,GMU3mK\u0006\u001cX\r\u0006\u0003\u00024\u000e=\u0006BBA^e\u0001\u00071\fK\u00023\u0003\u007f\u000ba$\u0019:dQ&4X-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005M6q\u0017\u0005\u0007\u0003w\u001b\u0004\u0019A.)\u0007M\ny,\u0001\u0006hKR\fE\u000e\u001c+bON$Baa0\u0004FB)!QVBa7&!11\u0019BX\u0005\r\u0019V\r\u001e\u0005\b\u0007\u000f$\u0004\u0019AB7\u0003-a\u0017.\\5u\u001dVl'-\u001a:)\u0007Q\ny\f\u0006\u0005\u0003,\u000e57qZBi\u0011\u001d\u0011i,\u000ea\u0001\u0005\u007fCqAa76\u0001\u0004\u0019I\u0004C\u0004\u0003fV\u0002\ra!\u000f\u00025M,\u0017M]2i%\u0016dW-Y:fg\nK(+\u001a7fCN,\u0017\nZ:\u0015\t\r]7\u0011\u001c\t\u0007\u0005_\u001cI\"a7\t\u000f\rmg\u00071\u0001\u0004\u0004\u0006Q!/\u001a7fCN,\u0017\nZ:\u0002EM,\u0017M]2i%\u0016dW-Y:fg\n\u000b7/[2FqR\u0014\u0015PU3mK\u0006\u001cX-\u00133t)\u0011\u0019\toa<\u0011\r\t=8\u0011DBr!\u0011\u0019)oa;\u000e\u0005\r\u001d(\u0002BBu\u0003g\tQ!];fefLAa!<\u0004h\n\u0019\"+\u001a7fCN,')Y:jG\u0012\u000bG/Y#yi\"911\\\u001cA\u0002\r\r\u0015AD4fiJ+G.Z1tK&#X-\\\u000b\u0005\u0007k\u001cy\u0010\u0006\u0003\u0004x\u0012uA\u0003BB}\t#\u0001RA\u0013BP\u0007w\u0004Ba!@\u0004\u00002\u0001Aa\u0002C\u0001q\t\u0007A1\u0001\u0002\u0002)F!AQ\u0001C\u0006!\rQEqA\u0005\u0004\t\u0013Y%a\u0002(pi\"Lgn\u001a\t\u0005\u0003;$i!\u0003\u0003\u0005\u0010\u0005}'\u0001\u0003)mC:LE/Z7\t\u000f\u0011M\u0001\b1\u0001\u0005\u0016\u00059q-\u001a;Ji\u0016l\u0007c\u0002&\u0005\u0018\u0005mG1D\u0005\u0004\t3Y%!\u0003$v]\u000e$\u0018n\u001c82!\u0019QEqC.\u0004|\"1Aq\u0004\u001dA\u0002m\u000ba!\u001b;f[&#\u0017!E4fiZ\u000b'/[1cY\u0016|\u0005\u000f^5p]R!AQ\u0005C\u0014!\u0015Q%q\u0014B&\u0011\u0019\u0011I&\u000fa\u00017\u0006q\u0012M]2iSZ,\u0017\t\u001c7PkR<w.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\t[!)\u0004\u0005\u0004\u0003p\u000eeAq\u0006\t\u0005\u0003;$\t$\u0003\u0003\u00054\u0005}'A\u0003#fa\u0016tG-\u001a8ds\"9\u0011\u0011\u001c\u001eA\u0002\u0005m\u0007f\u0005\u0003\u0005:\u0011\u001dC\u0011\nC'\t\u001f\"I\u0006b\u0017\u0005f\u0011\u001d\u0004\u0003\u0002C\u001e\t\u0007j!\u0001\"\u0010\u000b\t\u0005uEq\b\u0006\u0005\t\u0003\n9+A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002C#\t{\u0011Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017!\u0002<bYV,\u0017E\u0001C&\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006Y\u0001O]8qC\u001e\fG/[8oI\t!\t&\u0003\u0003\u0005T\u0011U\u0013\u0001\u0003*F#VK%+\u0012#\u000b\t\u0011]CQH\u0001\f!J|\u0007/Y4bi&|g.A\u0005jg>d\u0017\r^5p]\u0012\u0012AQL\u0005\u0005\t?\"\t'\u0001\bS\u000b\u0006#ulQ(N\u001b&#F+\u0012#\u000b\t\u0011\rDQH\u0001\n\u0013N|G.\u0019;j_:\f1B]8mY\n\f7m\u001b$pe2\u0012A\u0011N\u0012\u0003\tW\u0002BAa<\u0005n%!Aq\u000eB~\u0005%!\u0006N]8xC\ndW\rK\u0002\u0005\tg\u0002B\u0001\"\u001e\u0005|5\u0011Aq\u000f\u0006\u0005\ts\n9+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA\u0001\" \u0005x\t91+\u001a:wS\u000e,\u0007")
public class ArchivingService
implements ArchivedReleaseReader {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime startDate) {
        return ArchivingService$.MODULE$.getMonthYear(startDate);
    }

    @Override
    public Option<Release> getReleaseOption(String releaseId, boolean includePreArchived, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseReader.getReleaseOption$(this, releaseId, includePreArchived, ciConverter);
    }

    @Override
    public boolean getReleaseOption$default$2() {
        return ArchivedReleaseReader.getReleaseOption$default$2$(this);
    }

    @Override
    public ConfigurationItemConverter getReleaseOption$default$3() {
        return ArchivedReleaseReader.getReleaseOption$default$3$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeArchivedRelease(String releaseJson, RepositoryAdapter repository, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseDeserialization.deserializeArchivedRelease$(this, releaseJson, repository, ciConverter);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (this.releaseRepository.exists(releaseId) || !this.existsPreArchived(releaseId)) return;
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
            this.archivedReleases().setPreArchived(releaseId, false);
            return;
        } else if (!this.shouldArchive(release)) {
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(57).append("Removing non archive-able release '").append(releaseId).append("' from active database").toString());
            this.deleteRelease(releaseId, release);
            return;
        } else if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES), (Object)release.getStatus())) {
            if (!this.existsPreArchived(releaseId)) throw new IllegalStateException("Only pre-archived releases can be archived");
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
            this.releaseExtensionsRepository.decorate(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                this.commentService.decorate(task);
                return BoxedUnit.UNIT;
            });
            java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
            release.setTeams(updatedTeams);
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveRelease$7(task, x$1)))).asJava()));
                return BoxedUnit.UNIT;
            });
            this.archiveAttachments(release);
            this.archiveDependencies(release);
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
            if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
            } else {
                this.archivedReleases().updateViewers(releaseId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(updatedTeams).asScala().toSeq());
            }
            this.deleteRelease(releaseId, release);
            return;
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void deleteRelease(String releaseId, Release release) {
        block0: {
            if (!this.releaseRepository.exists(releaseId)) break block0;
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
            this.releaseRepository.delete(releaseId, this.releaseRepository.delete$default$2());
            ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).foreach((Function1 & Serializable)facet -> {
                ArchivingService.$anonfun$deleteRelease$2(this, facet);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        Option previousWorkDirContext = Option$.MODULE$.apply((Object)WorkDirContext.get());
        WorkDirContext.initWorkdir();
        try {
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAttachments()).asScala().foreach((Function1 & Serializable)attachment -> {
                ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Option$.MODULE$.apply((Object)WorkDirContext.get()).foreach((Function1 & Serializable)x$2 -> {
                x$2.delete();
                return BoxedUnit.UNIT;
            });
            WorkDirContext.clear();
            previousWorkDirContext.foreach((Function1 & Serializable)x$1 -> {
                ArchivingService.$anonfun$archiveAttachments$6(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveDependencies(Release release) {
        scala.collection.immutable.Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public boolean deletePreArchiveRelease(String releaseId) {
        return this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$3(task, x$3)))).asJava()));
                return BoxedUnit.UNIT;
            });
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (this.shouldArchive(release)) {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
                ((IterableOnceOps)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$5(specialTypes, facet)))).foreach((Function1 & Serializable)liveFacet -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet));
                this.releaseRepository.setPreArchived(release.getId(), true);
            }
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public boolean shouldArchive(Release release) {
        return !release.isTutorial() && release.isArchiveRelease();
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived, this.getReleaseOption$default$3()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable)x$4 -> (Function1 & Serializable)x$1 -> x$4.getPhase(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable)x$5 -> (Function1 & Serializable)x$1 -> x$5.getTask(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$6 -> (Function1 & Serializable)x$1 -> x$6.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$7 -> (Function1 & Serializable)x$1 -> x$7.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(scala.collection.immutable.Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(scala.collection.immutable.Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public scala.collection.immutable.Seq<String> findPurgableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findPurgableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void purgeArchivedRelease(String releaseId) {
        this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        scala.collection.immutable.Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()))).asJava();
    }

    public scala.collection.immutable.Seq<Release> searchReleasesByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        scala.collection.immutable.Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (scala.collection.immutable.Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()));
    }

    public scala.collection.immutable.Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIds.map((Function1 & Serializable)x$9 -> FullReleaseId$.MODULE$.apply((String)x$9).withOnlyOneParentOrApplicationsForArchiveDb())));
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$10))));
    }

    private scala.collection.immutable.Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        Buffer dependencies = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$12)));
        dependencies.foreach((Function1 & Serializable)x$13 -> {
            x$13.archive();
            return BoxedUnit.UNIT;
        });
        return dependencies.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$archiveRelease$7(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$deleteRelease$2(ArchivingService $this, Facet facet) {
        ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete(facet.getId(), ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete$default$2());
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$6(WorkDir x$1) {
        WorkDirContext.setWorkDir((WorkDir)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$3(Task task$2, Facet x$3) {
        String string = x$3.getTargetId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$5(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        scala.collection.immutable.Seq rawDependenciesToArchive = (scala.collection.immutable.Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)rawDependenciesToArchive.map((Function1 & Serializable)x$8 -> x$8.getId())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$10) {
        String string = x$10.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$12) {
        return !x$12.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        ArchivedReleaseDeserialization.$init$(this);
        Logging.$init$((Logging)this);
        ArchivedReleaseReader.$init$(this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
    }
}

