/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolverRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xltype.serialization.CiReference;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005U4Aa\u0002\u0005\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!9\u0003A!A!\u0002\u0013A\u0003\"\u0002\u0018\u0001\t\u0003y\u0003\"B\"\u0001\t\u0003!\u0005\"\u0002.\u0001\t\u0013Y&\u0001\u0007#fa\u0016tG-\u001a8dsR\u000b'oZ3u%\u0016\u001cx\u000e\u001c<fe*\u0011\u0011BC\u0001\u000be\u0016\u0004xn]5u_JL(BA\u0006\r\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u000e\u001d\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0002%Ad\u0017M\\%uK6\u0014V\r]8tSR|'/\u001f\t\u00035mi\u0011\u0001C\u0005\u00039!\u0011!\u0003\u00157b]&#X-\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0011\"/Z:pYZ,'OU3q_NLGo\u001c:z!\tyR%D\u0001!\u0015\tI\u0011E\u0003\u0002#G\u0005!!n]8o\u0015\t!#\"A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0003M\u0001\u0012!CU3t_24XM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003W)\tqa]3sm&\u001cW-\u0003\u0002.U\t\u0001\u0012I]2iSZLgnZ*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tA\n$g\r\t\u00035\u0001AQ\u0001\u0007\u0003A\u0002eAQ!\b\u0003A\u0002yAQa\n\u0003A\u0002!B#\u0001B\u001b\u0011\u0005Y\nU\"A\u001c\u000b\u0005aJ\u0014AC1o]>$\u0018\r^5p]*\u0011!hO\u0001\bM\u0006\u001cGo\u001c:z\u0015\taT(A\u0003cK\u0006t7O\u0003\u0002?\u007f\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001A\u0003\ry'oZ\u0005\u0003\u0005^\u0012\u0011\"Q;u_^L'/\u001a3\u0002\u001bI,7o\u001c7wKR\u000b'oZ3u)\t)\u0005\n\u0005\u0002\u0014\r&\u0011q\t\u0006\u0002\u0005+:LG\u000fC\u0003J\u000b\u0001\u0007!*\u0001\u0006eKB,g\u000eZ3oGf\u0004\"a\u0013(\u000e\u00031S!!\u0014\u0006\u0002\r\u0011|W.Y5o\u0013\tyEJ\u0001\u0006EKB,g\u000eZ3oGfD#!B)\u0011\u0005ICV\"A*\u000b\u0005a\"&BA+W\u0003\u001diW\r\u001e:jGNT!a\u0016\b\u0002\u0011\r|G-\u00195bY\u0016L!!W*\u0003\u000bQKW.\u001a3\u0002+I,7o\u001c7wK\u0006\u00138\r[5wK\u0012$\u0016M]4fiR\u0019Al\u00187\u0011\u0005-k\u0016B\u00010M\u0005!\u0001F.\u00198Ji\u0016l\u0007\"\u00021\u0007\u0001\u0004\t\u0017\u0001\u0003;be\u001e,G/\u00133\u0011\u0005\tLgBA2h!\t!G#D\u0001f\u0015\t1\u0007#\u0001\u0004=e>|GOP\u0005\u0003QR\ta\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000e\u0006\u0005\u0006[\u001a\u0001\r!Y\u0001\rI\u0016\u0004XM\u001c3f]\u000eL\u0018\n\u001a\u0015\u0003\u0001=\u0004\"\u0001]:\u000e\u0003ET!A]\u001f\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002uc\nI1i\\7q_:,g\u000e\u001e")
public class DependencyTargetResolver {
    private final PlanItemRepository planItemRepository;
    private final ResolverRepository resolverRepository;
    private final ArchivingService archivingService;

    @Timed
    public void resolveTarget(Dependency dependency) {
        block0: {
            boolean dependencyTargetResolved;
            String targetId = dependency.getTargetId();
            if (!Strings.isNotEmpty((String)targetId) || VariableHelper$.MODULE$.containsVariables(targetId) || dependency.isArchived() || (dependencyTargetResolved = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                boolean bl;
                PropertyDescriptor targetProperty = dependency.getType().getDescriptor().getPropertyDescriptor("target");
                CiReference ciRef = new CiReference((ConfigurationItem)dependency, targetProperty, targetId);
                PlanItem planItem = (PlanItem)$this.resolverRepository.resolve(targetId, ciRef);
                if ($this.planItemRepository.exists(targetId)) {
                    dependency.setTarget(planItem);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)))) break block0;
            Try$.MODULE$.apply((Function0 & Serializable)() -> this.resolveArchivedTarget(targetId, dependency.getId())).map((Function1 & Serializable)target -> {
                DependencyTargetResolver.$anonfun$resolveTarget$4(dependency, target);
                return BoxedUnit.UNIT;
            }).recoverWith((PartialFunction)new Serializable(null, dependency, targetId){
                private static final long serialVersionUID = 0L;
                private final Dependency dependency$1;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof NotFoundException ? new Failure((Throwable)new TargetIdResolutionFailedException(new StringBuilder(43).append("Could not find target on dependency ").append(this.dependency$1.getId()).append(" by ID ").append(this.targetId$1).toString())) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof NotFoundException;
                    return bl;
                }
                {
                    this.dependency$1 = dependency$1;
                    this.targetId$1 = targetId$1;
                }
            }).get();
        }
    }

    private PlanItem resolveArchivedTarget(String targetId, String dependencyId) {
        Option option;
        Option option2;
        Release release;
        Option option3;
        String string = targetId;
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            release = this.archivingService.getRelease(targetId);
        } else if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            release = this.archivingService.getPhase(targetId);
        } else if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            release = this.archivingService.getTask(targetId);
        } else {
            throw new TargetIdResolutionFailedException(new StringBuilder(0).append(new StringBuilder(40).append("Invalid archived target on dependency ").append(dependencyId).append(", ").toString()).append(new StringBuilder(23).append("it is not a plan item: ").append(targetId).toString()).toString());
        }
        return release;
    }

    public static final /* synthetic */ void $anonfun$resolveTarget$4(Dependency dependency$1, PlanItem target) {
        dependency$1.setTarget(target);
        dependency$1.archive();
    }

    @Autowired
    public DependencyTargetResolver(PlanItemRepository planItemRepository, ResolverRepository resolverRepository, ArchivingService archivingService) {
        this.planItemRepository = planItemRepository;
        this.resolverRepository = resolverRepository;
        this.archivingService = archivingService;
    }
}

