/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005maa\u0002\u0007\u000e!\u0003\r\tA\u0006\u0005\u0006S\u0001!\tA\u000b\u0005\u0006]\u00011\ta\f\u0005\u0006g\u00011\t\u0001\u000e\u0005\u0006w\u00011\t\u0001\u0010\u0005\u0006\u0007\u00021\t\u0001\u0012\u0005\u0006\u0011\u0002!\tB\u000b\u0005\u0006\u0013\u0002!\tB\u0013\u0005\u00061\u0002!I!\u0017\u0005\u0006e\u0002!Ia\u001d\u0005\u0006w\u0002!I\u0001 \u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0005AQuN\u0019*fG>4XM]=M_\u001eL7M\u0003\u0002\u000f\u001f\u0005I1o\u00195fIVdWM\u001d\u0006\u0003!E\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005I\u0019\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005!\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u0018;\u0015\u0002\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0013\u0001C4sSjTH.\u001a3\n\u0005\u0011z\"a\u0002'pO\u001eLgn\u001a\t\u0003M\u001dj\u0011!D\u0005\u0003Q5\u0011aAT8eK&#\u0017A\u0002\u0013j]&$H\u0005F\u0001,!\tAB&\u0003\u0002.3\t!QK\\5u\u0003!QwNY)vKV,W#\u0001\u0019\u0011\u0005\u0019\n\u0014B\u0001\u001a\u000e\u0005!QuNY)vKV,\u0017A\u00036pEN+'O^5dKV\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029\u001b\u000591/\u001a:wS\u000e,\u0017B\u0001\u001e8\u0005)QuNY*feZL7-Z\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iD\u0001\u0007C\u000e$xN]:\n\u0005\t{$a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017!E1di>\u00148+_:uK6Du\u000e\u001c3feV\tQ\t\u0005\u0002?\r&\u0011qi\u0010\u0002\u0012\u0003\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\u0018A\u0004:fG>4XM]!mY*{'m]\u0001\fe\u0016\u001cwN^3s\u0015>\u00147\u000f\u0006\u0002,\u0017\")Aj\u0002a\u0001\u001b\u00061an\u001c3f\u0013\u0012\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)\u001a\u001b\u0005\t&B\u0001*\u0016\u0003\u0019a$o\\8u}%\u0011A+G\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U3\u0005Ya-\u001b8e\u00032d'j\u001c2t)\u0005Q\u0006cA.aG:\u0011AL\u0018\b\u0003!vK\u0011AG\u0005\u0003?f\tq\u0001]1dW\u0006<W-\u0003\u0002bE\n!A*[:u\u0015\ty\u0016\u0004\r\u0002eSB\u0019a%Z4\n\u0005\u0019l!a\u0002+bg.TuN\u0019\t\u0003Q&d\u0001\u0001B\u0005k\u0011\u0005\u0005\t\u0011!B\u0001W\n\u0019q\fJ\u0019\u0012\u00051|\u0007C\u0001\rn\u0013\tq\u0017DA\u0004O_RD\u0017N\\4\u0011\u0005a\u0001\u0018BA9\u001a\u0005\r\te._\u0001\u0010M&tGMS8cg\u001a{'OT8eKR\u0011AO\u001f\t\u00047\u0002,\bG\u0001<y!\r1Sm\u001e\t\u0003Qb$\u0011\"_\u0005\u0002\u0002\u0003\u0005)\u0011A6\u0003\u0007}##\u0007C\u0003M\u0013\u0001\u0007Q*A\rgC&dwJ\u001d*fG>4XM]!cC:$wN\\3e\u0015>\u0014GCA\u0016~\u0011\u0015q(\u00021\u0001\u0000\u0003\rQwN\u0019\u0019\u0005\u0003\u0003\t)\u0001\u0005\u0003'K\u0006\r\u0001c\u00015\u0002\u0006\u0011Q\u0011qA?\u0002\u0002\u0003\u0005)\u0011A6\u0003\u0007}#3'A\u0004sK\u000e|g/\u001a:\u0015\u0007-\ni\u0001C\u0004\u0002\u0010-\u0001\r!!\u0005\u0002\u0019)|'\rV8SK\u000e|g/\u001a:1\t\u0005M\u0011q\u0003\t\u0005M\u0015\f)\u0002E\u0002i\u0003/!1\"!\u0007\u0002\u000e\u0005\u0005\t\u0011!B\u0001W\n\u0019q\f\n\u001b")
public interface JobRecoveryLogic
extends Logging,
NodeId {
    public JobQueue jobQueue();

    public JobService jobService();

    public ReleaseActorService releaseActorService();

    @Override
    public ActorSystemHolder actorSystemHolder();

    public static /* synthetic */ void recoverAllJobs$(JobRecoveryLogic $this) {
        $this.recoverAllJobs();
    }

    default public void recoverAllJobs() {
        List<TaskJob<?>> foundJobs = this.findAllJobs();
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(47).append("Found ").append(foundJobs.size()).append(" jobs, that should be failed or recovered").toString());
        foundJobs.foreach((Function1 & Serializable)job -> {
            this.failOrRecoverAbandonedJob(job);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void recoverJobs$(JobRecoveryLogic $this, String nodeId) {
        $this.recoverJobs(nodeId);
    }

    default public void recoverJobs(String nodeId) {
        List<TaskJob<?>> foundJobs = this.findJobsForNode(nodeId);
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(67).append("Found ").append(foundJobs.size()).append(" jobs assigned to node = ").append(nodeId).append(", that should be failed or recovered").toString());
        foundJobs.foreach((Function1 & Serializable)job -> {
            this.failOrRecoverAbandonedJob(job);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private List<TaskJob<?>> findAllJobs() {
        void var2_2;
        JobFilters filters = new JobFilters();
        filters.node_$eq(null);
        filters.withoutNode_$eq(false);
        List<TaskJob<?>> jobs = this.jobService().findAllTaskJobs(filters, Pageable.unpaged(), true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private List<TaskJob<?>> findJobsForNode(String nodeId) {
        void var3_3;
        JobFilters filters = new JobFilters();
        filters.node_$eq(nodeId);
        if (nodeId == null) {
            filters.withoutNode_$eq(true);
        }
        List<TaskJob<?>> jobs = this.jobService().findAllTaskJobs(filters, Pageable.unpaged(), true);
        return var3_3;
    }

    private void failOrRecoverAbandonedJob(TaskJob<?> job) {
        block6: {
            try {
                boolean bl = false;
                JobStatus jobStatus = null;
                JobStatus jobStatus2 = job.status();
                if (((Object)((Object)JobStatus.QUEUED)).equals((Object)jobStatus2)) {
                    this.recover(job);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (((Object)((Object)JobStatus.RESERVED)).equals((Object)jobStatus2)) {
                    bl = true;
                    jobStatus = jobStatus2;
                    JobType jobType = job.jobType();
                    JobType jobType2 = JobType.NEXT_CUSTOM_SCRIPT_TASK;
                    if (!(jobType != null ? !((Object)((Object)jobType)).equals((Object)jobType2) : jobType2 != null)) {
                        this.recover(job);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                }
                if (bl) {
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(59).append("Failing abandoned task ").append(job.taskId()).append(" of type ").append((Object)job.jobType()).append(", that was launched at ").append(job.startTime()).append(" on ").append(job.node()).toString());
                    this.releaseActorService().failTaskWithRetry(job.taskId(), "Task failed. It was interrupted by a server restart.", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$, job.taskRef().getExecutionId());
                    this.jobService().deleteByTaskIdAndExecutionId(job.taskId(), job.taskRef().getExecutionId());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(60).append("Unable to recover job ").append(job).append(". Please inspect it in 'Task Manager'.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(29).append("Error during recovery of job ").append(job).toString(), (Function0 & Serializable)() -> t);
                Try$.MODULE$.apply((Function0 & Serializable)() -> this.jobService().updateJobStatus(job, JobStatus.FAILED));
            }
        }
    }

    private void recover(TaskJob<?> jobToRecover) {
        Some some;
        JobRow jobRow;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Recovering task '").append(jobToRecover.taskId()).append("'").toString());
        Option<JobRow> option = this.jobService().updateJobNodeAndStatus(jobToRecover, this.nodeId(), JobStatus.QUEUED);
        if (option instanceof Some && (jobRow = (JobRow)(some = (Some)option).value()) != null) {
            JobRow jobRow2 = jobRow;
            jobToRecover.version_$eq(jobRow2.version());
            jobToRecover.node_$eq(jobRow2.node());
            jobToRecover.status_$eq(jobRow2.status());
            this.jobQueue().submitExisting(jobToRecover);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(78).append("Unable to re-assign abandoned job ").append(jobToRecover).append(", maybe it was already taken by another node").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static void $init$(JobRecoveryLogic $this) {
    }
}

