/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivedReleaseDeserialization;
import com.xebialabs.xlrelease.service.ArchivedReleaseReader;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0005\u00115t!B\u001d;\u0011\u0003\u0019e!B#;\u0011\u00031\u0005\"B+\u0002\t\u00031\u0006\"B,\u0002\t\u0003Af\u0001B#;\u0001AD\u0001\u0002\u001e\u0003\u0003\u0006\u0004%\t!\u001e\u0005\ty\u0012\u0011\t\u0011)A\u0005m\"AQ\u0010\u0002B\u0001B\u0003%a\u0010\u0003\u0006\u0002\u0004\u0011\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0003\u0005\u0005\u000b\u0007I\u0011AA\u0007\u0011)\ty\u0002\u0002B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003C!!\u0011!Q\u0001\n\u0005\r\u0002BCA\u0015\t\t\u0005\t\u0015!\u0003\u0002,!Q\u0011Q\u0007\u0003\u0003\u0002\u0003\u0006I!a\u000e\t\u0015\u0005uBA!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002L\u0011\u0011\t\u0011)A\u0005\u0003\u001bB!\"a\u0015\u0005\u0005\u0003\u0005\u000b\u0011BA+\u0011)\tY\u0006\u0002B\u0001B\u0003%\u0011Q\f\u0005\u000b\u0003G\"!\u0011!Q\u0001\n\u0005\u0015\u0004BCA6\t\t\u0005\t\u0015!\u0003\u0002n!1Q\u000b\u0002C\u0001\u0003gBq!a+\u0005\t\u0003\ti\u000bC\u0004\u0002N\u0012!I!a4\t\u000f\u0005\u0005H\u0001\"\u0003\u0002d\"9\u0011q\u001d\u0003\u0005\u0002\u0005%\bbBA{\t\u0011\u0005\u0011q\u001f\u0005\b\u0003{$A\u0011AA\u0000\u0011\u001d\ti\u0010\u0002C\u0001\u0005\u0007AqA!\u0004\u0005\t\u0003\u0011y\u0001C\u0004\u0003\u0016\u0011!\tAa\u0006\t\u000f\t\u0015B\u0001\"\u0001\u0003(!9!Q\u0007\u0003\u0005\u0002\t]\u0002b\u0002B&\t\u0011\u0005!Q\n\u0005\b\u0005+\"A\u0011\u0001B,\u0011\u001d\u0011i\u0006\u0002C\u0001\u0005?BqAa\u001a\u0005\t\u0003\u0011I\u0007C\u0004\u0003p\u0011!\tA!\u001d\t\u000f\teD\u0001\"\u0001\u0003|!9!q\u0011\u0003\u0005\u0002\t%\u0005b\u0002BK\t\u0011\u0005!q\u0013\u0005\b\u0005+#A\u0011\u0001Bb\u0011\u001d\u00119\u000e\u0002C\u0001\u00053D\u0011b!\f\u0005#\u0003%\taa\f\t\u0013\r\rC!%A\u0005\u0002\r=\u0002bBB#\t\u0011\u00051q\t\u0005\b\u0007K\"A\u0011AB4\u0011\u001d\u0019i\u0007\u0002C\u0001\u0007_Bqaa$\u0005\t\u0003\u0019\t\nC\u0004\u0004\u001a\u0012!\taa'\t\u000f\r\u0005F\u0001\"\u0001\u0004$\"91\u0011\u0016\u0003\u0005\u0002\r-\u0006b\u0002BK\t\u0011%1\u0011\u0018\u0005\b\u0007\u0003$A\u0011ABb\u0011\u001d\u0019Y\r\u0002C\u0001\u0007\u001bDqaa8\u0005\t\u0013\u0019\t\u000fC\u0004\u0005\u0010\u0011!I\u0001\"\u0005\t\u000f\u0011]A\u0001\"\u0003\u0005\u001a\u0005\u0001\u0012I]2iSZLgnZ*feZL7-\u001a\u0006\u0003wq\nqa]3sm&\u001cWM\u0003\u0002>}\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u007f\u0001\u000b\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0005\u000b1aY8n\u0007\u0001\u0001\"\u0001R\u0001\u000e\u0003i\u0012\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0014\u0007\u00059U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bQa\u001d7gi)T\u0011AU\u0001\tOJL'P\u001f7fI&\u0011Ak\u0014\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1)\u0001\u0007hKRluN\u001c;i3\u0016\f'\u000f\u0006\u0002ZIB\u0011!,\u0019\b\u00037~\u0003\"\u0001X%\u000e\u0003uS!A\u0018\"\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0017*\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011J\u0011\u0015)7\u00011\u0001g\u0003%\u0019H/\u0019:u\t\u0006$X\r\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006!A/[7f\u0015\tYG.\u0001\u0003k_\u0012\f'\"A7\u0002\u0007=\u0014x-\u0003\u0002pQ\nAA)\u0019;f)&lWm\u0005\u0003\u0005\u000fFl\u0005C\u0001#s\u0013\t\u0019(HA\u000bBe\u000eD\u0017N^3e%\u0016dW-Y:f%\u0016\fG-\u001a:\u0002!\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001cX#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005ed\u0014A\u00013c\u0013\tY\bP\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\u0006\t\u0012M]2iSZ,GMU3mK\u0006\u001cXm\u001d\u0011\u0002-\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c8+Z1sG\"\u0004\"a^@\n\u0007\u0005\u0005\u0001P\u0001\fBe\u000eD\u0017N^3e%\u0016dW-Y:fgN+\u0017M]2i\u0003y\t'o\u00195jm\u0016$\u0017i\u0019;jm&$\u0018\u0010T8hgN+'/[1mSj,'\u000fE\u0002E\u0003\u000fI1!!\u0003;\u0005y\t%o\u00195jm\u0016$\u0017i\u0019;jm&$\u0018\u0010T8hgN+'/[1mSj,'/A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\"!a\u0004\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005Q!/\u001a9pg&$xN]=\u000b\u0007\u0005ea(\u0001\u0005eKBdw._5u\u0013\u0011\ti\"a\u0005\u0003#I+\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0001\nsKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0013AH2p[BdW\r^3e%\u0016dW-Y:fg\u0016C\bo\u001c:u'\u0016\u0014h/[2f!\r!\u0015QE\u0005\u0004\u0003OQ$!H\"p[BdW\r^3e%\u0016dW-Y:f\u000bb\u0004xN\u001d;TKJ4\u0018nY3\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002.\u0005ERBAA\u0018\u0015\r\t)\u0002P\u0005\u0005\u0003g\tyCA\tSK2,\u0017m]3SKB|7/\u001b;pef\fA\u0003Z3qK:$WM\\2z%\u0016\u0004xn]5u_JL\b\u0003BA\u0017\u0003sIA!a\u000f\u00020\t!B)\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\f1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bb\u0014AB1di>\u00148/\u0003\u0003\u0002J\u0005\r#a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017A\u0004;fC6\u0014V\r]8tSR|'/\u001f\t\u0005\u0003[\ty%\u0003\u0003\u0002R\u0005=\"A\u0004+fC6\u0014V\r]8tSR|'/_\u0001\u000bg\u0016\u001cWO]3e\u0007&\u001c\b\u0003BA\u0017\u0003/JA!!\u0017\u00020\tQ1+Z2ve\u0016$7)[:\u00027I,G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:z!\u0011\ti#a\u0018\n\t\u0005\u0005\u0014q\u0006\u0002\u001c%\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u0002\u001d\r|W.\\3oiN+'O^5dKB\u0019A)a\u001a\n\u0007\u0005%$H\u0001\bD_6lWM\u001c;TKJ4\u0018nY3\u00023\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\t\u0005\u0003[\ty'\u0003\u0003\u0002r\u0005=\"!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ$B$!\u001e\u0002x\u0005e\u00141PA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b\u000by\t\u0005\u0002E\t!)A\u000f\u0006a\u0001m\")Q\u0010\u0006a\u0001}\"9\u00111\u0001\u000bA\u0002\u0005\u0015\u0001bBA\u0006)\u0001\u0007\u0011q\u0002\u0005\b\u0003C!\u0002\u0019AA\u0012\u0011\u001d\tI\u0003\u0006a\u0001\u0003WAq!!\u000e\u0015\u0001\u0004\t9\u0004C\u0004\u0002>Q\u0001\r!a\u0010\t\u000f\u0005-C\u00031\u0001\u0002N!9\u00111\u000b\u000bA\u0002\u0005U\u0003bBA.)\u0001\u0007\u0011Q\f\u0005\b\u0003G\"\u0002\u0019AA3\u0011\u001d\tY\u0007\u0006a\u0001\u0003[B3\u0001FAJ!\u0011\t)*a*\u000e\u0005\u0005]%\u0002BAM\u00037\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\ti*a(\u0002\u000f\u0019\f7\r^8ss*!\u0011\u0011UAR\u0003\u0015\u0011W-\u00198t\u0015\r\t)\u000b\\\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u0011\u0011VAL\u0005%\tU\u000f^8xSJ,G-\u0001\bbe\u000eD\u0017N^3SK2,\u0017m]3\u0015\t\u0005=\u0016Q\u0017\t\u0004\u0011\u0006E\u0016bAAZ\u0013\n!QK\\5u\u0011\u0019\t9,\u0006a\u00013\u0006I!/\u001a7fCN,\u0017\n\u001a\u0015\u0004+\u0005m\u0006\u0003BA_\u0003\u0013l!!a0\u000b\t\u0005e\u0015\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005\u001d\u0007)\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\tY-a0\u0003\u000bQKW.\u001a3\u0002%\u0005\u00148\r[5wK\u0006#H/Y2i[\u0016tGo\u001d\u000b\u0005\u0003_\u000b\t\u000eC\u0004\u0002TZ\u0001\r!!6\u0002\u000fI,G.Z1tKB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\r\na\u0001Z8nC&t\u0017\u0002BAp\u00033\u0014qAU3mK\u0006\u001cX-A\nbe\u000eD\u0017N^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u00020\u0006\u0015\bbBAj/\u0001\u0007\u0011Q[\u0001\u0018I\u0016dW\r^3Qe\u0016\f%o\u00195jm\u0016\u0014V\r\\3bg\u0016$B!a;\u0002rB\u0019\u0001*!<\n\u0007\u0005=\u0018JA\u0004C_>dW-\u00198\t\r\u0005]\u0006\u00041\u0001ZQ\rA\u00121X\u0001\u0012aJ,\u0017I]2iSZ,'+\u001a7fCN,G\u0003BAX\u0003sDq!a5\u001a\u0001\u0004\t)\u000eK\u0002\u001a\u0003w\u000b!bZ3u%\u0016dW-Y:f)\u0011\t)N!\u0001\t\r\u0005]&\u00041\u0001Z)\u0019\t)N!\u0002\u0003\b!1\u0011qW\u000eA\u0002eCqA!\u0003\u001c\u0001\u0004\tY/\u0001\nj]\u000edW\u000fZ3Qe\u0016\f%o\u00195jm\u0016$\u0007fA\u000e\u0002<\u0006yq-\u001a;SK2,\u0017m]3USRdW\rF\u0002Z\u0005#Aa!a.\u001d\u0001\u0004I\u0006f\u0001\u000f\u0002<\u0006Aq-\u001a;QQ\u0006\u001cX\r\u0006\u0003\u0003\u001a\t}\u0001\u0003BAl\u00057IAA!\b\u0002Z\n)\u0001\u000b[1tK\"1!\u0011E\u000fA\u0002e\u000bq\u0001\u001d5bg\u0016LE\rK\u0002\u001e\u0003w\u000bqaZ3u)\u0006\u001c8\u000e\u0006\u0003\u0003*\t=\u0002\u0003BAl\u0005WIAA!\f\u0002Z\n!A+Y:l\u0011\u0019\u0011\tD\ba\u00013\u00061A/Y:l\u0013\u0012D3AHA^\u0003-9W\r\u001e,be&\f'\r\\3\u0015\t\te\"Q\t\t\u0005\u0005w\u0011\t%\u0004\u0002\u0003>)!!qHAm\u0003%1\u0018M]5bE2,7/\u0003\u0003\u0003D\tu\"\u0001\u0003,be&\f'\r\\3\t\r\t\u001ds\u00041\u0001Z\u0003)1\u0018M]5bE2,\u0017\n\u001a\u0015\u0004?\u0005m\u0016AB3ySN$8\u000f\u0006\u0003\u0002l\n=\u0003B\u0002B)A\u0001\u0007\u0011,\u0001\u0003dS&#\u0007f\u0001\u0011\u0002<\u0006\tR\r_5tiN\u0004&/Z!sG\"Lg/\u001a3\u0015\t\u0005-(\u0011\f\u0005\u0007\u0005#\n\u0003\u0019A-)\u0007\u0005\nY,\u0001\u0007fq&\u001cHo\u001d\"z\u001d\u0006lW\r\u0006\u0003\u0002l\n\u0005\u0004B\u0002B2E\u0001\u0007\u0011,A\u0006sK2,\u0017m]3OC6,\u0007f\u0001\u0012\u0002<\u0006\u00012\r[3dW:{G/\u0011:dQ&4X\r\u001a\u000b\u0005\u0003_\u0013Y\u0007\u0003\u0004\u0003R\r\u0002\r!\u0017\u0015\u0004G\u0005m\u0016\u0001E1ui\u0006\u001c\u0007.\\3oi\u0016C\u0018n\u001d;t)\u0011\tYOa\u001d\t\r\tUD\u00051\u0001Z\u00031\tG\u000f^1dQ6,g\u000e^%eQ\r!\u00131X\u0001\u000eO\u0016$\u0018\t\u001e;bG\"lWM\u001c;\u0015\t\tu$1\u0011\t\u0005\u0003/\u0014y(\u0003\u0003\u0003\u0002\u0006e'AC!ui\u0006\u001c\u0007.\\3oi\"1!QO\u0013A\u0002eC3!JA^\u0003M9W\r^!ui\u0006\u001c\u0007.\\3oi>\u0003H/[8o)\u0011\u0011YI!%\u0011\u000b!\u0013iI! \n\u0007\t=\u0015J\u0001\u0004PaRLwN\u001c\u0005\u0007\u0005k2\u0003\u0019A-)\u0007\u0019\nY,\u0001\btK\u0006\u00148\r\u001b*fY\u0016\f7/Z:\u0015\t\te%\u0011\u0016\t\u0007\u00057\u0013)+!6\u000e\u0005\tu%\u0002\u0002BP\u0005C\u000bA!\u001e;jY*\u0011!1U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003(\nu%\u0001\u0002'jgRDqAa+(\u0001\u0004\u0011i+A\u0004gS2$XM]:\u0011\t\t=&QX\u0007\u0003\u0005cSAAa-\u00036\u0006)am\u001c:ng*!!q\u0017B]\u0003\t1\u0018GC\u0002\u0003<r\n1!\u00199j\u0013\u0011\u0011yL!-\u0003\u001fI+G.Z1tKN4\u0015\u000e\u001c;feND3aJA^)!\u0011IJ!2\u0003H\nE\u0007b\u0002BVQ\u0001\u0007!Q\u0016\u0005\b\u0005\u0013D\u0003\u0019\u0001Bf\u0003\u0015a\u0017.\\5u!\rA%QZ\u0005\u0004\u0005\u001fL%\u0001\u0002'p]\u001eDqAa5)\u0001\u0004\u0011Y-\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0004Q\u0005m\u0016A\r4j]\u0012\u001c\u0006n\u001c:u%\u0016dW-Y:f\u0013\u0012\u001cx+\u001b;i\r>dG-\u001a:OC6,\u0017I\u001c3Pe\u0012,'o\u0011:ji\u0016\u0014\u0018n\u001c8\u0015\u0015\tm71AB\r\u0007K\u0019I\u0003\u0005\u0004\u0003^\n\u001d(1\u001e\b\u0005\u0005?\u0014\u0019OD\u0002]\u0005CL\u0011AS\u0005\u0004\u0005KL\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0013IOC\u0002\u0003f&\u0003r\u0001\u0013Bw\u0005c\u0014i0C\u0002\u0003p&\u0013a\u0001V;qY\u0016\u0014\u0004\u0003\u0002Bz\u0005sl!A!>\u000b\t\t]\u0018\u0011\\\u0001\u0006kRLGn]\u0005\u0005\u0005w\u0014)PA\tBI\u0006\u0004H/\u001b<f%\u0016dW-Y:f\u0013\u0012\u00042\u0001\u0013B\u0000\u0013\r\u0019\t!\u0013\u0002\u0004\u0003:L\bb\u0002BVS\u0001\u00071Q\u0001\t\u0007\u0005;\u001c9aa\u0003\n\t\r%!\u0011\u001e\u0002\u0004'\u0016\f\b\u0003BB\u0007\u0007+i!aa\u0004\u000b\t\t-6\u0011\u0003\u0006\u0004\u0007'a\u0014a\u0002:fa>\u0014Ho]\u0005\u0005\u0007/\u0019yA\u0001\u0007SKB|'\u000f\u001e$jYR,'\u000fC\u0004\u0004\u001c%\u0002\ra!\b\u0002\u000b=\u0014H-\u001a:\u0011\u000b!\u0013iia\b\u0011\t\t=6\u0011E\u0005\u0005\u0007G\u0011\tL\u0001\tSK2,\u0017m]3Pe\u0012,'/T8eK\"I!\u0011Z\u0015\u0011\u0002\u0003\u00071q\u0005\t\u0006\u0011\n5%1\u001a\u0005\n\u0005'L\u0003\u0013!a\u0001\u0007OA3!KA^\u0003q2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rE\"\u0006BB\u0014\u0007gY#a!\u000e\u0011\t\r]2qH\u0007\u0003\u0007sQAaa\u000f\u0004>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033K\u0015\u0002BB!\u0007s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tG\u0005Z3gCVdG\u000f\n\u001b\u0002+\r|WO\u001c;SK2,\u0017m]3t\u0005f\u001cF/\u0019;vgR!1\u0011JB1!\u001dQ61JB(\u00077J1a!\u0014d\u0005\ri\u0015\r\u001d\t\u0005\u0007#\u001a9&\u0004\u0002\u0004T)!1QKAm\u0003\u0019\u0019H/\u0019;vg&!1\u0011LB*\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vgB\u0019\u0001j!\u0018\n\u0007\r}\u0013JA\u0002J]RDqAa+-\u0001\u0004\u0011i\u000bK\u0002-\u0003w\u000bQbY8v]R\u0014V\r\\3bg\u0016\u001cH\u0003BB%\u0007SBqAa+.\u0001\u0004\u0019)\u0001K\u0002.\u0003w\u000b\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0019\tha\u001d\u0004~A)!Q\\B\u00043\"91Q\u000f\u0018A\u0002\r]\u0014\u0001\u00023bi\u0016\u0004BAa'\u0004z%!11\u0010BO\u0005\u0011!\u0015\r^3\t\u000f\r}d\u00061\u0001\u0004\u0002\u0006A\u0001/Y4f'&TX\r\u0005\u0003\u0004\u0004\u000e%UBABC\u0015\u0011\u00199I!)\u0002\t1\fgnZ\u0005\u0005\u0007\u0017\u001b)IA\u0004J]R,w-\u001a:)\u00079\nY,\u0001\fgS:$\u0007+\u001e:hC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0019\tha%\u0004\u0016\"91QO\u0018A\u0002\r]\u0004bBB@_\u0001\u00071\u0011\u0011\u0015\u0004_\u0005m\u0016\u0001\u00069ve\u001e,\u0017I]2iSZ,GMU3mK\u0006\u001cX\r\u0006\u0003\u00020\u000eu\u0005BBA\\a\u0001\u0007\u0011\fK\u00021\u0003w\u000ba$\u0019:dQ&4X-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005=6Q\u0015\u0005\u0007\u0003o\u000b\u0004\u0019A-)\u0007E\nY,\u0001\u0006hKR\fE\u000e\u001c+bON$Ba!,\u00044B)!1TBX3&!1\u0011\u0017BO\u0005\r\u0019V\r\u001e\u0005\b\u0007k\u0013\u0004\u0019AB.\u0003-a\u0017.\\5u\u001dVl'-\u001a:)\u0007I\nY\f\u0006\u0005\u0003\u001a\u000em6QXB`\u0011\u001d\u0011Yk\ra\u0001\u0005[CqA!34\u0001\u0004\u00199\u0003C\u0004\u0003TN\u0002\raa\n\u00025M,\u0017M]2i%\u0016dW-Y:fg\nK(+\u001a7fCN,\u0017\nZ:\u0015\t\r\u00157q\u0019\t\u0007\u0005;\u001c9!!6\t\u000f\r%G\u00071\u0001\u0004r\u0005Q!/\u001a7fCN,\u0017\nZ:\u0002EM,\u0017M]2i%\u0016dW-Y:fg\n\u000b7/[2FqR\u0014\u0015PU3mK\u0006\u001cX-\u00133t)\u0011\u0019ym!8\u0011\r\tu7qABi!\u0011\u0019\u0019n!7\u000e\u0005\rU'\u0002BBl\u0003_\tQ!];fefLAaa7\u0004V\n\u0019\"+\u001a7fCN,')Y:jG\u0012\u000bG/Y#yi\"91\u0011Z\u001bA\u0002\rE\u0014AD4fiJ+G.Z1tK&#X-\\\u000b\u0005\u0007G\u001ci\u000f\u0006\u0003\u0004f\u0012-A\u0003BBt\u0007\u007f\u0004R\u0001\u0013BG\u0007S\u0004Baa;\u0004n2\u0001AaBBxm\t\u00071\u0011\u001f\u0002\u0002)F!11_B}!\rA5Q_\u0005\u0004\u0007oL%a\u0002(pi\"Lgn\u001a\t\u0005\u0003/\u001cY0\u0003\u0003\u0004~\u0006e'\u0001\u0003)mC:LE/Z7\t\u000f\u0011\u0005a\u00071\u0001\u0005\u0004\u00059q-\u001a;Ji\u0016l\u0007c\u0002%\u0005\u0006\u0005UG\u0011B\u0005\u0004\t\u000fI%!\u0003$v]\u000e$\u0018n\u001c82!\u0019AEQA-\u0004j\"1AQ\u0002\u001cA\u0002e\u000ba!\u001b;f[&#\u0017!E4fiZ\u000b'/[1cY\u0016|\u0005\u000f^5p]R!A1\u0003C\u000b!\u0015A%Q\u0012B\u001d\u0011\u0019\u00119e\u000ea\u00013\u0006q\u0012M]2iSZ,\u0017\t\u001c7PkR<w.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\t7!\u0019\u0003\u0005\u0004\u0003^\u000e\u001dAQ\u0004\t\u0005\u0003/$y\"\u0003\u0003\u0005\"\u0005e'A\u0003#fa\u0016tG-\u001a8ds\"9\u00111\u001b\u001dA\u0002\u0005U\u0007f\u0005\u0003\u0005(\u0011UBq\u0007C\u001e\t{!9\u0005\"\u0013\u0005T\u0011U\u0003\u0003\u0002C\u0015\tci!\u0001b\u000b\u000b\t\u0005eEQ\u0006\u0006\u0005\t_\t\u0019+A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002C\u001a\tW\u0011Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017!\u0002<bYV,\u0017E\u0001C\u001d\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006Y\u0001O]8qC\u001e\fG/[8oI\t!y$\u0003\u0003\u0005B\u0011\r\u0013\u0001\u0003*F#VK%+\u0012#\u000b\t\u0011\u0015C1F\u0001\f!J|\u0007/Y4bi&|g.A\u0005jg>d\u0017\r^5p]\u0012\u0012A1J\u0005\u0005\t\u001b\"y%\u0001\bS\u000b\u0006#ulQ(N\u001b&#F+\u0012#\u000b\t\u0011EC1F\u0001\n\u0013N|G.\u0019;j_:\f1B]8mY\n\f7m\u001b$pe2\u0012AqK\u0012\u0003\t3\u0002BA!8\u0005\\%!AQ\fBu\u0005%!\u0006N]8xC\ndW\rK\u0002\u0005\tC\u0002B\u0001b\u0019\u0005j5\u0011AQ\r\u0006\u0005\tO\n\u0019+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA\u0001b\u001b\u0005f\t91+\u001a:wS\u000e,\u0007")
public class ArchivingService
implements ArchivedReleaseReader {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime startDate) {
        return ArchivingService$.MODULE$.getMonthYear(startDate);
    }

    @Override
    public Option<Release> getReleaseOption(String releaseId, boolean includePreArchived, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseReader.getReleaseOption$(this, releaseId, includePreArchived, ciConverter);
    }

    @Override
    public boolean getReleaseOption$default$2() {
        return ArchivedReleaseReader.getReleaseOption$default$2$(this);
    }

    @Override
    public ConfigurationItemConverter getReleaseOption$default$3() {
        return ArchivedReleaseReader.getReleaseOption$default$3$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeArchivedRelease(String releaseJson, RepositoryAdapter repository, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseDeserialization.deserializeArchivedRelease$(this, releaseJson, repository, ciConverter);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES), (Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.releaseExtensionsRepository.decorate(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveRelease$6(task, x$1)))).asJava()));
                    return BoxedUnit.UNIT;
                });
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(updatedTeams).asScala().toSeq());
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId, this.releaseRepository.delete$default$2());
                    ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).foreach((Function1 & Serializable)facet -> {
                        ArchivingService.$anonfun$archiveRelease$10(this, facet);
                        return BoxedUnit.UNIT;
                    });
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        Option previousWorkDirContext = Option$.MODULE$.apply((Object)WorkDirContext.get());
        WorkDirContext.initWorkdir();
        try {
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAttachments()).asScala().foreach((Function1 & Serializable)attachment -> {
                ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Option$.MODULE$.apply((Object)WorkDirContext.get()).foreach((Function1 & Serializable)x$2 -> {
                x$2.delete();
                return BoxedUnit.UNIT;
            });
            WorkDirContext.clear();
            previousWorkDirContext.foreach((Function1 & Serializable)x$1 -> {
                ArchivingService.$anonfun$archiveAttachments$6(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveDependencies(Release release) {
        scala.collection.immutable.Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public boolean deletePreArchiveRelease(String releaseId) {
        return this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$3(task, x$3)))).asJava()));
                return BoxedUnit.UNIT;
            });
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
                ((IterableOnceOps)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$5(specialTypes, facet)))).foreach((Function1 & Serializable)liveFacet -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet));
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId(), this.releaseRepository.delete$default$2());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived, this.getReleaseOption$default$3()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable)x$4 -> (Function1 & Serializable)x$1 -> x$4.getPhase(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable)x$5 -> (Function1 & Serializable)x$1 -> x$5.getTask(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$6 -> (Function1 & Serializable)x$1 -> x$6.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$7 -> (Function1 & Serializable)x$1 -> x$7.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(scala.collection.immutable.Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(scala.collection.immutable.Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public scala.collection.immutable.Seq<String> findPurgableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findPurgableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void purgeArchivedRelease(String releaseId) {
        this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        scala.collection.immutable.Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()))).asJava();
    }

    public scala.collection.immutable.Seq<Release> searchReleasesByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        scala.collection.immutable.Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (scala.collection.immutable.Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()));
    }

    public scala.collection.immutable.Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIds.map((Function1 & Serializable)x$9 -> FullReleaseId$.MODULE$.apply((String)x$9).withOnlyOneParentOrApplicationsForArchiveDb())));
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$10))));
    }

    private scala.collection.immutable.Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        Buffer dependencies = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$12)));
        dependencies.foreach((Function1 & Serializable)x$13 -> {
            x$13.archive();
            return BoxedUnit.UNIT;
        });
        return dependencies.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$archiveRelease$6(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$10(ArchivingService $this, Facet facet) {
        ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete(facet.getId(), ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete$default$2());
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$6(WorkDir x$1) {
        WorkDirContext.setWorkDir((WorkDir)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$3(Task task$2, Facet x$3) {
        String string = x$3.getTargetId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$5(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        scala.collection.immutable.Seq rawDependenciesToArchive = (scala.collection.immutable.Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)rawDependenciesToArchive.map((Function1 & Serializable)x$8 -> x$8.getId())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$10) {
        String string = x$10.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$12) {
        return !x$12.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        ArchivedReleaseDeserialization.$init$(this);
        Logging.$init$((Logging)this);
        ArchivedReleaseReader.$init$(this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
    }
}

