/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivedReleaseDeserialization;
import com.xebialabs.xlrelease.service.ArchivedReleaseReader;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0005\u00115s!\u0002\u001c8\u0011\u0003\u0001e!\u0002\"8\u0011\u0003\u0019\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0003)f\u0001\u0002\"8\u00015D\u0001\"\u001d\u0003\u0003\u0006\u0004%\tA\u001d\u0005\ts\u0012\u0011\t\u0011)A\u0005g\"A!\u0010\u0002B\u0001B\u0003%1\u0010\u0003\u0005\u007f\t\t\u0005\t\u0015!\u0003\u0000\u0011)\t)\u0001\u0002BC\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u00033!!\u0011!Q\u0001\n\u0005%\u0001BCA\u000e\t\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u00111\u0005\u0003\u0003\u0002\u0003\u0006I!!\n\t\u0015\u0005=BA!A!\u0002\u0013\t\t\u0004\u0003\u0006\u00028\u0011\u0011\t\u0011)A\u0005\u0003sA!\"!\u0012\u0005\u0005\u0003\u0005\u000b\u0011BA$\u0011)\ti\u0005\u0002B\u0001B\u0003%\u0011q\n\u0005\u000b\u0003+\"!\u0011!Q\u0001\n\u0005]\u0003BCA/\t\t\u0005\t\u0015!\u0003\u0002`!Q\u0011Q\r\u0003\u0003\u0002\u0003\u0006I!a\u001a\t\rI#A\u0011AA7\u0011\u001d\t)\u000b\u0002C\u0001\u0003OCq!a2\u0005\t\u0013\tI\rC\u0004\u0002\\\u0012!I!!8\t\u000f\u0005\u0005H\u0001\"\u0001\u0002d\"9\u0011q\u001e\u0003\u0005\u0002\u0005E\bbBA|\t\u0011\u0005\u0011\u0011 \u0005\b\u0003o$A\u0011AA\u007f\u0011\u001d\u00119\u0001\u0002C\u0001\u0005\u0013AqAa\u0004\u0005\t\u0003\u0011\t\u0002C\u0004\u0003 \u0011!\tA!\t\t\u000f\t=B\u0001\"\u0001\u00032!9!Q\t\u0003\u0005\u0002\t\u001d\u0003b\u0002B(\t\u0011\u0005!\u0011\u000b\u0005\b\u0005/\"A\u0011\u0001B-\u0011\u001d\u0011\t\u0007\u0002C\u0001\u0005GBqAa\u001b\u0005\t\u0003\u0011i\u0007C\u0004\u0003z\u0011!\tAa\u001f\t\u000f\t\u001dE\u0001\"\u0001\u0003\n\"9!q\u0011\u0003\u0005\u0002\tU\u0006b\u0002Be\t\u0011\u0005!1\u001a\u0005\n\u0007?!\u0011\u0013!C\u0001\u0007CA\u0011b!\u000e\u0005#\u0003%\ta!\t\t\u000f\r]B\u0001\"\u0001\u0004:!91q\u000b\u0003\u0005\u0002\re\u0003bBB0\t\u0011\u00051\u0011\r\u0005\b\u0007\u0003#A\u0011ABB\u0011\u001d\u0019I\t\u0002C\u0001\u0007\u0017CqAa\"\u0005\t\u0013\u0019I\nC\u0004\u0004\"\u0012!\taa)\t\u000f\r-F\u0001\"\u0001\u0004.\"91q\u0018\u0003\u0005\n\r\u0005\u0007bBBx\t\u0011%1\u0011\u001f\u0005\b\u0007o$A\u0011BB}\u0003A\t%o\u00195jm&twmU3sm&\u001cWM\u0003\u00029s\u000591/\u001a:wS\u000e,'B\u0001\u001e<\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002={\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002}\u0005\u00191m\\7\u0004\u0001A\u0011\u0011)A\u0007\u0002o\t\u0001\u0012I]2iSZLgnZ*feZL7-Z\n\u0004\u0003\u0011S\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g\r\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006)1\u000f\u001c45U*\tq*\u0001\u0005he&T(\u0010\\3e\u0013\t\tFJA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0001\u0015\u0001D4fi6{g\u000e\u001e5ZK\u0006\u0014HC\u0001,b!\t9fL\u0004\u0002Y9B\u0011\u0011LR\u0007\u00025*\u00111lP\u0001\u0007yI|w\u000e\u001e \n\u0005u3\u0015A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018$\t\u000b\t\u001c\u0001\u0019A2\u0002\u0013M$\u0018M\u001d;ECR,\u0007C\u00013l\u001b\u0005)'B\u00014h\u0003\u0011!\u0018.\\3\u000b\u0005!L\u0017\u0001\u00026pI\u0006T\u0011A[\u0001\u0004_J<\u0017B\u00017f\u0005!!\u0015\r^3US6,7\u0003\u0002\u0003E]*\u0003\"!Q8\n\u0005A<$!F!sG\"Lg/\u001a3SK2,\u0017m]3SK\u0006$WM]\u0001\u0011CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mf\n!\u0001\u001a2\n\u0005a,(\u0001E!sG\"Lg/\u001a3SK2,\u0017m]3t\u0003E\t'o\u00195jm\u0016$'+\u001a7fCN,7\u000fI\u0001\u0017CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u001cV-\u0019:dQB\u0011A\u000f`\u0005\u0003{V\u0014a#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:TK\u0006\u00148\r[\u0001\u001fCJ\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJ\u00042!QA\u0001\u0013\r\t\u0019a\u000e\u0002\u001f\u0003J\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJ\f\u0011C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0015I,\u0007o\\:ji>\u0014\u0018PC\u0002\u0002\u0014m\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003/\tiAA\tSKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005q2m\\7qY\u0016$X\r\u001a*fY\u0016\f7/Z:FqB|'\u000f^*feZL7-\u001a\t\u0004\u0003\u0006}\u0011bAA\u0011o\ti2i\\7qY\u0016$X\r\u001a*fY\u0016\f7/Z#ya>\u0014HoU3sm&\u001cW-A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004B!a\n\u0002,5\u0011\u0011\u0011\u0006\u0006\u0004\u0003\u001fI\u0014\u0002BA\u0017\u0003S\u0011\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003Q!W\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ssB!\u0011qEA\u001a\u0013\u0011\t)$!\u000b\u0003)\u0011+\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA s\u00051\u0011m\u0019;peNLA!a\u0011\u0002>\t\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006qA/Z1n%\u0016\u0004xn]5u_JL\b\u0003BA\u0014\u0003\u0013JA!a\u0013\u0002*\tqA+Z1n%\u0016\u0004xn]5u_JL\u0018AC:fGV\u0014X\rZ\"jgB!\u0011qEA)\u0013\u0011\t\u0019&!\u000b\u0003\u0015M+7-\u001e:fI\u000eK7/A\u000esK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/\u001f\t\u0005\u0003O\tI&\u0003\u0003\u0002\\\u0005%\"a\u0007*fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u00180\u0001\bd_6lWM\u001c;TKJ4\u0018nY3\u0011\u0007\u0005\u000b\t'C\u0002\u0002d]\u0012abQ8n[\u0016tGoU3sm&\u001cW-A\rgC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014\b\u0003BA\u0014\u0003SJA!a\u001b\u0002*\tIb)Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s)q\ty'!\u001d\u0002t\u0005U\u0014qOA=\u0003w\ni(a \u0002\u0002\u0006\r\u0015QQAD\u0003\u0013\u0003\"!\u0011\u0003\t\u000bE$\u0002\u0019A:\t\u000bi$\u0002\u0019A>\t\u000by$\u0002\u0019A@\t\u000f\u0005\u0015A\u00031\u0001\u0002\n!9\u00111\u0004\u000bA\u0002\u0005u\u0001bBA\u0012)\u0001\u0007\u0011Q\u0005\u0005\b\u0003_!\u0002\u0019AA\u0019\u0011\u001d\t9\u0004\u0006a\u0001\u0003sAq!!\u0012\u0015\u0001\u0004\t9\u0005C\u0004\u0002NQ\u0001\r!a\u0014\t\u000f\u0005UC\u00031\u0001\u0002X!9\u0011Q\f\u000bA\u0002\u0005}\u0003bBA3)\u0001\u0007\u0011q\r\u0015\u0004)\u00055\u0005\u0003BAH\u0003Ck!!!%\u000b\t\u0005M\u0015QS\u0001\u000bC:tw\u000e^1uS>t'\u0002BAL\u00033\u000bqAZ1di>\u0014\u0018P\u0003\u0003\u0002\u001c\u0006u\u0015!\u00022fC:\u001c(bAAPS\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002$\u0006E%!C!vi><\u0018N]3e\u00039\t'o\u00195jm\u0016\u0014V\r\\3bg\u0016$B!!+\u00020B\u0019Q)a+\n\u0007\u00055fI\u0001\u0003V]&$\bBBAY+\u0001\u0007a+A\u0005sK2,\u0017m]3JI\"\u001aQ#!.\u0011\t\u0005]\u00161Y\u0007\u0003\u0003sSA!a%\u0002<*!\u0011QXA`\u0003\u001diW\r\u001e:jGNT1!!1>\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAc\u0003s\u0013Q\u0001V5nK\u0012\f!#\u0019:dQ&4X-\u0011;uC\u000eDW.\u001a8ugR!\u0011\u0011VAf\u0011\u001d\tiM\u0006a\u0001\u0003\u001f\fqA]3mK\u0006\u001cX\r\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t).O\u0001\u0007I>l\u0017-\u001b8\n\t\u0005e\u00171\u001b\u0002\b%\u0016dW-Y:f\u0003M\t'o\u00195jm\u0016$U\r]3oI\u0016t7-[3t)\u0011\tI+a8\t\u000f\u00055w\u00031\u0001\u0002P\u00069B-\u001a7fi\u0016\u0004&/Z!sG\"Lg/\u001a*fY\u0016\f7/\u001a\u000b\u0005\u0003K\fY\u000fE\u0002F\u0003OL1!!;G\u0005\u001d\u0011un\u001c7fC:Da!!-\u0019\u0001\u00041\u0006f\u0001\r\u00026\u0006\t\u0002O]3Be\u000eD\u0017N^3SK2,\u0017m]3\u0015\t\u0005%\u00161\u001f\u0005\b\u0003\u001bL\u0002\u0019AAhQ\rI\u0012QW\u0001\u000bO\u0016$(+\u001a7fCN,G\u0003BAh\u0003wDa!!-\u001b\u0001\u00041FCBAh\u0003\u007f\u0014\t\u0001\u0003\u0004\u00022n\u0001\rA\u0016\u0005\b\u0005\u0007Y\u0002\u0019AAs\u0003IIgn\u00197vI\u0016\u0004&/Z!sG\"Lg/\u001a3)\u0007m\t),A\bhKR\u0014V\r\\3bg\u0016$\u0016\u000e\u001e7f)\r1&1\u0002\u0005\u0007\u0003cc\u0002\u0019\u0001,)\u0007q\t),\u0001\u0005hKR\u0004\u0006.Y:f)\u0011\u0011\u0019B!\u0007\u0011\t\u0005E'QC\u0005\u0005\u0005/\t\u0019NA\u0003QQ\u0006\u001cX\r\u0003\u0004\u0003\u001cu\u0001\rAV\u0001\ba\"\f7/Z%eQ\ri\u0012QW\u0001\bO\u0016$H+Y:l)\u0011\u0011\u0019C!\u000b\u0011\t\u0005E'QE\u0005\u0005\u0005O\t\u0019N\u0001\u0003UCN\\\u0007B\u0002B\u0016=\u0001\u0007a+\u0001\u0004uCN\\\u0017\n\u001a\u0015\u0004=\u0005U\u0016aC4fiZ\u000b'/[1cY\u0016$BAa\r\u0003@A!!Q\u0007B\u001e\u001b\t\u00119D\u0003\u0003\u0003:\u0005M\u0017!\u0003<be&\f'\r\\3t\u0013\u0011\u0011iDa\u000e\u0003\u0011Y\u000b'/[1cY\u0016DaA!\u0011 \u0001\u00041\u0016A\u0003<be&\f'\r\\3JI\"\u001aq$!.\u0002\r\u0015D\u0018n\u001d;t)\u0011\t)O!\u0013\t\r\t-\u0003\u00051\u0001W\u0003\u0011\u0019\u0017.\u00133)\u0007\u0001\n),A\tfq&\u001cHo\u001d)sK\u0006\u00138\r[5wK\u0012$B!!:\u0003T!1!1J\u0011A\u0002YC3!IA[\u00031)\u00070[:ug\nKh*Y7f)\u0011\t)Oa\u0017\t\r\tu#\u00051\u0001W\u0003-\u0011X\r\\3bg\u0016t\u0015-\\3)\u0007\t\n),\u0001\tbiR\f7\r[7f]R,\u00050[:ugR!\u0011Q\u001dB3\u0011\u0019\u00119g\ta\u0001-\u0006a\u0011\r\u001e;bG\"lWM\u001c;JI\"\u001a1%!.\u0002\u001b\u001d,G/\u0011;uC\u000eDW.\u001a8u)\u0011\u0011yG!\u001e\u0011\t\u0005E'\u0011O\u0005\u0005\u0005g\n\u0019N\u0001\u0006BiR\f7\r[7f]RDaAa\u001a%\u0001\u00041\u0006f\u0001\u0013\u00026\u0006\u0019r-\u001a;BiR\f7\r[7f]R|\u0005\u000f^5p]R!!Q\u0010BB!\u0015)%q\u0010B8\u0013\r\u0011\tI\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\r\t\u001dT\u00051\u0001WQ\r)\u0013QW\u0001\u000fg\u0016\f'o\u00195SK2,\u0017m]3t)\u0011\u0011YIa'\u0011\r\t5%qSAh\u001b\t\u0011yI\u0003\u0003\u0003\u0012\nM\u0015\u0001B;uS2T!A!&\u0002\t)\fg/Y\u0005\u0005\u00053\u0013yI\u0001\u0003MSN$\bb\u0002BOM\u0001\u0007!qT\u0001\bM&dG/\u001a:t!\u0011\u0011\tKa,\u000e\u0005\t\r&\u0002\u0002BS\u0005O\u000bQAZ8s[NTAA!+\u0003,\u0006\u0011a/\r\u0006\u0004\u0005[K\u0014aA1qS&!!\u0011\u0017BR\u0005=\u0011V\r\\3bg\u0016\u001ch)\u001b7uKJ\u001c\bf\u0001\u0014\u00026RA!1\u0012B\\\u0005s\u0013\u0019\rC\u0004\u0003\u001e\u001e\u0002\rAa(\t\u000f\tmv\u00051\u0001\u0003>\u0006)A.[7jiB\u0019QIa0\n\u0007\t\u0005gI\u0001\u0003M_:<\u0007b\u0002BcO\u0001\u0007!QX\u0001\u0007_\u001a47/\u001a;)\u0007\u001d\n),\u0001\u001agS:$7\u000b[8siJ+G.Z1tK&#7oV5uQ\u001a{G\u000eZ3s\u001d\u0006lW-\u00118e\u001fJ$WM]\"sSR,'/[8o))\u0011iM!>\u0004\f\r]11\u0004\t\u0007\u0005\u001f\u0014IN!8\u000f\t\tE'Q\u001b\b\u00043\nM\u0017\"A$\n\u0007\t]g)A\u0004qC\u000e\\\u0017mZ3\n\t\te%1\u001c\u0006\u0004\u0005/4\u0005cB#\u0003`\n\r(q^\u0005\u0004\u0005C4%A\u0002+va2,'\u0007\u0005\u0003\u0003f\n-XB\u0001Bt\u0015\u0011\u0011I/a5\u0002\u000bU$\u0018\u000e\\:\n\t\t5(q\u001d\u0002\u0012\u0003\u0012\f\u0007\u000f^5wKJ+G.Z1tK&#\u0007cA#\u0003r&\u0019!1\u001f$\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u001e\"\u0002\rAa>\u0011\r\t='\u0011 B\u007f\u0013\u0011\u0011YPa7\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003\u0000\u000e\u001dQBAB\u0001\u0015\u0011\u0011ija\u0001\u000b\u0007\r\u0015\u0011(A\u0004sKB|'\u000f^:\n\t\r%1\u0011\u0001\u0002\r%\u0016\u0004xN\u001d;GS2$XM\u001d\u0005\b\u0007\u001bA\u0003\u0019AB\b\u0003\u0015y'\u000fZ3s!\u0015)%qPB\t!\u0011\u0011\tka\u0005\n\t\rU!1\u0015\u0002\u0011%\u0016dW-Y:f\u001fJ$WM]'pI\u0016D\u0011Ba/)!\u0003\u0005\ra!\u0007\u0011\u000b\u0015\u0013yH!0\t\u0013\t\u0015\u0007\u0006%AA\u0002\re\u0001f\u0001\u0015\u00026\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\u0019C\u000b\u0003\u0004\u001a\r\u00152FAB\u0014!\u0011\u0019Ic!\r\u000e\u0005\r-\"\u0002BB\u0017\u0007_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Me)\u0003\u0003\u00044\r-\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003U\u0019w.\u001e8u%\u0016dW-Y:fg\nK8\u000b^1ukN$Baa\u000f\u0004TA9qk!\u0010\u0004B\r5\u0013bAB A\n\u0019Q*\u00199\u0011\t\r\r3\u0011J\u0007\u0003\u0007\u000bRAaa\u0012\u0002T\u000611\u000f^1ukNLAaa\u0013\u0004F\ti!+\u001a7fCN,7\u000b^1ukN\u00042!RB(\u0013\r\u0019\tF\u0012\u0002\u0004\u0013:$\bb\u0002BOW\u0001\u0007!q\u0014\u0015\u0004W\u0005U\u0016!D2pk:$(+\u001a7fCN,7\u000f\u0006\u0003\u0004<\rm\u0003b\u0002BOY\u0001\u0007!q\u001f\u0015\u0004Y\u0005U\u0016\u0001\u00074j]\u0012\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z%egR111MB3\u0007_\u0002RAa4\u0003zZCqaa\u001a.\u0001\u0004\u0019I'\u0001\u0003eCR,\u0007\u0003\u0002BG\u0007WJAa!\u001c\u0003\u0010\n!A)\u0019;f\u0011\u001d\u0019\t(\fa\u0001\u0007g\n\u0001\u0002]1hKNK'0\u001a\t\u0005\u0007k\u001aY(\u0004\u0002\u0004x)!1\u0011\u0010BJ\u0003\u0011a\u0017M\\4\n\t\ru4q\u000f\u0002\b\u0013:$XmZ3sQ\ri\u0013QW\u0001\u001fCJ\u001c\u0007.\u001b<f\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2jKN$B!!+\u0004\u0006\"1\u0011\u0011\u0017\u0018A\u0002YC3ALA[\u0003)9W\r^!mYR\u000bwm\u001d\u000b\u0005\u0007\u001b\u001b\u0019\nE\u0003\u0003\u000e\u000e=e+\u0003\u0003\u0004\u0012\n=%aA*fi\"91QS\u0018A\u0002\r5\u0013a\u00037j[&$h*^7cKJD3aLA[)!\u0011Yia'\u0004\u001e\u000e}\u0005b\u0002BOa\u0001\u0007!q\u0014\u0005\b\u0005w\u0003\u0004\u0019AB\r\u0011\u001d\u0011)\r\ra\u0001\u00073\t!d]3be\u000eD'+\u001a7fCN,7OQ=SK2,\u0017m]3JIN$Ba!*\u0004(B1!q\u001aB}\u0003\u001fDqa!+2\u0001\u0004\u0019\u0019'\u0001\u0006sK2,\u0017m]3JIN\f!e]3be\u000eD'+\u001a7fCN,7OQ1tS\u000e,\u0005\u0010\u001e\"z%\u0016dW-Y:f\u0013\u0012\u001cH\u0003BBX\u0007{\u0003bAa4\u0003z\u000eE\u0006\u0003BBZ\u0007sk!a!.\u000b\t\r]\u0016\u0011F\u0001\u0006cV,'/_\u0005\u0005\u0007w\u001b)LA\nSK2,\u0017m]3CCNL7\rR1uC\u0016CH\u000fC\u0004\u0004*J\u0002\raa\u0019\u0002\u001d\u001d,GOU3mK\u0006\u001cX-\u0013;f[V!11YBg)\u0011\u0019)ma;\u0015\t\r\u001d7q\u001c\t\u0006\u000b\n}4\u0011\u001a\t\u0005\u0007\u0017\u001ci\r\u0004\u0001\u0005\u000f\r=7G1\u0001\u0004R\n\tA+\u0005\u0003\u0004T\u000ee\u0007cA#\u0004V&\u00191q\u001b$\u0003\u000f9{G\u000f[5oOB!\u0011\u0011[Bn\u0013\u0011\u0019i.a5\u0003\u0011Ac\u0017M\\%uK6Dqa!94\u0001\u0004\u0019\u0019/A\u0004hKRLE/Z7\u0011\u000f\u0015\u001b)/a4\u0004j&\u00191q\u001d$\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CB#\u0004fZ\u001bI\r\u0003\u0004\u0004nN\u0002\rAV\u0001\u0007SR,W.\u00133\u0002#\u001d,GOV1sS\u0006\u0014G.Z(qi&|g\u000e\u0006\u0003\u0004t\u000eU\b#B#\u0003\u0000\tM\u0002B\u0002B!i\u0001\u0007a+\u0001\u0010be\u000eD\u0017N^3BY2|U\u000f^4pS:<G)\u001a9f]\u0012,gnY5fgR!11 C\u0002!\u0019\u0011yM!?\u0004~B!\u0011\u0011[B\u0000\u0013\u0011!\t!a5\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010C\u0004\u0002NV\u0002\r!a4)'\u0011!9\u0001\"\u0006\u0005\u0018\u0011mAQ\u0004C\u0014\tS!\u0019\u0004\"\u000e\u0011\t\u0011%A\u0011C\u0007\u0003\t\u0017QA!a%\u0005\u000e)!AqBAO\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0011MA1\u0002\u0002\u000e)J\fgn]1di&|g.\u00197\u0002\u000bY\fG.^3\"\u0005\u0011e\u0011a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'/A\u0006qe>\u0004\u0018mZ1uS>tGE\u0001C\u0010\u0013\u0011!\t\u0003b\t\u0002\u0011I+\u0015+V%S\u000b\u0012SA\u0001\"\n\u0005\f\u0005Y\u0001K]8qC\u001e\fG/[8o\u0003%I7o\u001c7bi&|g\u000e\n\u0002\u0005,%!AQ\u0006C\u0018\u00039\u0011V)\u0011#`\u0007>kU*\u0013+U\u000b\u0012SA\u0001\"\r\u0005\f\u0005I\u0011j]8mCRLwN\\\u0001\fe>dGNY1dW\u001a{'\u000f\f\u0002\u00058\r\u0012A\u0011\b\t\u0005\u0005\u001f$Y$\u0003\u0003\u0005>\tm'!\u0003+ie><\u0018M\u00197fQ\r!A\u0011\t\t\u0005\t\u0007\"I%\u0004\u0002\u0005F)!AqIAO\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\t\u0017\")EA\u0004TKJ4\u0018nY3")
public class ArchivingService
implements ArchivedReleaseReader {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime startDate) {
        return ArchivingService$.MODULE$.getMonthYear(startDate);
    }

    @Override
    public Option<Release> getReleaseOption(String releaseId, boolean includePreArchived, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseReader.getReleaseOption$(this, releaseId, includePreArchived, ciConverter);
    }

    @Override
    public boolean getReleaseOption$default$2() {
        return ArchivedReleaseReader.getReleaseOption$default$2$(this);
    }

    @Override
    public ConfigurationItemConverter getReleaseOption$default$3() {
        return ArchivedReleaseReader.getReleaseOption$default$3$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeArchivedRelease(String releaseJson, RepositoryAdapter repository, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseDeserialization.deserializeArchivedRelease$(this, releaseJson, repository, ciConverter);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES), (Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.releaseExtensionsRepository.decorate(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveRelease$6(task, x$1)))).asJava()));
                    return BoxedUnit.UNIT;
                });
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(updatedTeams).asScala().toSeq());
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId, this.releaseRepository.delete$default$2());
                    ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).foreach((Function1 & Serializable)facet -> {
                        ArchivingService.$anonfun$archiveRelease$10(this, facet);
                        return BoxedUnit.UNIT;
                    });
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        Option previousWorkDirContext = Option$.MODULE$.apply((Object)WorkDirContext.get());
        WorkDirContext.initWorkdir();
        try {
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAttachments()).asScala().foreach((Function1 & Serializable)attachment -> {
                ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Option$.MODULE$.apply((Object)WorkDirContext.get()).foreach((Function1 & Serializable)x$2 -> {
                x$2.delete();
                return BoxedUnit.UNIT;
            });
            WorkDirContext.clear();
            previousWorkDirContext.foreach((Function1 & Serializable)x$1 -> {
                ArchivingService.$anonfun$archiveAttachments$6(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveDependencies(Release release) {
        scala.collection.immutable.Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public boolean deletePreArchiveRelease(String releaseId) {
        return this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$3(task, x$3)))).asJava()));
                return BoxedUnit.UNIT;
            });
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
                ((IterableOnceOps)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$5(specialTypes, facet)))).foreach((Function1 & Serializable)liveFacet -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet));
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId(), this.releaseRepository.delete$default$2());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived, this.getReleaseOption$default$3()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable)x$4 -> (Function1 & Serializable)x$1 -> x$4.getPhase(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable)x$5 -> (Function1 & Serializable)x$1 -> x$5.getTask(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$6 -> (Function1 & Serializable)x$1 -> x$6.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$7 -> (Function1 & Serializable)x$1 -> x$7.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(scala.collection.immutable.Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(scala.collection.immutable.Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        scala.collection.immutable.Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()))).asJava();
    }

    public scala.collection.immutable.Seq<Release> searchReleasesByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        scala.collection.immutable.Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (scala.collection.immutable.Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()));
    }

    public scala.collection.immutable.Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIds.map((Function1 & Serializable)x$9 -> FullReleaseId$.MODULE$.apply((String)x$9).withOnlyOneParentOrApplicationsForArchiveDb())));
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$10))));
    }

    private scala.collection.immutable.Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        Buffer dependencies = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$12)));
        dependencies.foreach((Function1 & Serializable)x$13 -> {
            x$13.archive();
            return BoxedUnit.UNIT;
        });
        return dependencies.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$archiveRelease$6(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$10(ArchivingService $this, Facet facet) {
        ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete(facet.getId(), ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete$default$2());
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$6(WorkDir x$1) {
        WorkDirContext.setWorkDir((WorkDir)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$3(Task task$2, Facet x$3) {
        String string = x$3.getTargetId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$5(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        scala.collection.immutable.Seq rawDependenciesToArchive = (scala.collection.immutable.Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)rawDependenciesToArchive.map((Function1 & Serializable)x$8 -> x$8.getId())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$10) {
        String string = x$10.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$12) {
        return !x$12.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        ArchivedReleaseDeserialization.$init$(this);
        Logging.$init$((Logging)this);
        ArchivedReleaseReader.$init$(this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
    }
}

