/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handlers;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedOrTypeChangedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDelayedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskExecutionEvent;
import com.xebialabs.xlrelease.domain.events.TaskMovedEvent;
import com.xebialabs.xlrelease.domain.events.TaskReopenedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskStartedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.service.PendingPlanItemScheduledJobService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005M4A\u0001C\u0005\u0001)!A1\u0005\u0001BC\u0002\u0013\u0005A\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015\t\u0007\u0001\"\u0001c\u0005\u0001\u0002VM\u001c3j]\u001e$\u0016m]6BkR|7\u000b^1si\u00163XM\u001c;IC:$G.\u001a:\u000b\u0005)Y\u0011\u0001\u00035b]\u0012dWM]:\u000b\u00051i\u0011AB3wK:$8O\u0003\u0002\u000f\u001f\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003!E\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003I\t1aY8n\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0006g24GG\u001b\u0006\u0002A\u0005AqM]5{u2,G-\u0003\u0002#;\t9Aj\\4hS:<\u0017A\t9f]\u0012Lgn\u001a)mC:LE/Z7TG\",G-\u001e7fI*{'mU3sm&\u001cW-F\u0001&!\t1\u0013&D\u0001(\u0015\tAS\"A\u0004tKJ4\u0018nY3\n\u0005):#A\t)f]\u0012Lgn\u001a)mC:LE/Z7TG\",G-\u001e7fI*{'mU3sm&\u001cW-A\u0012qK:$\u0017N\\4QY\u0006t\u0017\n^3n'\u000eDW\rZ;mK\u0012TuNY*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\tq\u0003\u0007\u0005\u00020\u00015\t\u0011\u0002C\u0003$\u0007\u0001\u0007Q\u0005\u000b\u0002\u0004eA\u00111GP\u0007\u0002i)\u0011QGN\u0001\u000bC:tw\u000e^1uS>t'BA\u001c9\u0003\u001d1\u0017m\u0019;pefT!!\u000f\u001e\u0002\u000b\t,\u0017M\\:\u000b\u0005mb\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003u\n1a\u001c:h\u0013\tyDGA\u0005BkR|w/\u001b:fI\u0006yrN\u001c+bg.\u001c%/Z1uK\u0012|%\u000fV=qK\u000eC\u0017M\\4fI\u00163XM\u001c;\u0015\u0005\t+\u0005C\u0001\fD\u0013\t!uC\u0001\u0003V]&$\b\"\u0002$\u0005\u0001\u00049\u0015!B3wK:$\bC\u0001%M\u001b\u0005I%B\u0001\u0007K\u0015\tYU\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u001b&\u0013Q\u0004V1tW\u000e\u0013X-\u0019;fI>\u0013H+\u001f9f\u0007\"\fgnZ3e\u000bZ,g\u000e\u001e\u0015\u0003\t=\u0003\"\u0001U)\u000e\u0003-I!AU\u0006\u0003\u0013M+(m]2sS\n,\u0017\u0001F8o)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8Fm\u0016tG\u000f\u0006\u0002C+\")a)\u0002a\u0001-B\u0011\u0001jV\u0005\u00031&\u0013!\u0003V1tW\u0016CXmY;uS>tWI^3oi\"\u0012QaT\u0001\u0011_:$\u0016m]6N_Z,G-\u0012<f]R$\"A\u0011/\t\u000b\u00193\u0001\u0019A/\u0011\u0005!s\u0016BA0J\u00059!\u0016m]6N_Z,G-\u0012<f]RD#AB(\u0002%=tG+Y:l\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\u000b\u0003\u0005\u000eDQAR\u0004A\u0002\u0011\u0004\"\u0001S3\n\u0005\u0019L%\u0001\u0005+bg.$U\r\\3uK\u0012,e/\u001a8uQ\t9q\n\u000b\u0002\u0001SB\u0011\u0001K[\u0005\u0003W.\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bF\u0001\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001((\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!A]8\u0003\u000fM+'O^5dK\u0002")
public class PendingTaskAutoStartEventHandler
implements Logging {
    private final PendingPlanItemScheduledJobService pendingPlanItemScheduledJobService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PendingTaskAutoStartEventHandler pendingTaskAutoStartEventHandler = this;
        synchronized (pendingTaskAutoStartEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public PendingPlanItemScheduledJobService pendingPlanItemScheduledJobService() {
        return this.pendingPlanItemScheduledJobService;
    }

    @Subscribe
    public void onTaskCreatedOrTypeChangedEvent(TaskCreatedOrTypeChangedEvent event) {
        block1: {
            Task task;
            block2: {
                block0: {
                    task = event.task();
                    if (!task.canScheduleTaskStart()) break block0;
                    this.pendingPlanItemScheduledJobService().schedule(task);
                    break block1;
                }
                if (!task.isPending() || !task.canStartNow()) break block2;
                task.setScheduledStartDate(new Date());
                this.pendingPlanItemScheduledJobService().schedule(task);
                break block1;
            }
            if (task.getRelease().isTemplate()) break block1;
            this.pendingPlanItemScheduledJobService().unschedule(task);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Subscribe
    public void onTaskExecutionEvent(TaskExecutionEvent event) {
        TaskDelayedEvent taskDelayedEvent;
        Task task;
        TaskReopenedEvent taskReopenedEvent;
        Task task2;
        TaskExecutionEvent taskExecutionEvent = event;
        if (taskExecutionEvent instanceof TaskStartedEvent) {
            TaskStartedEvent taskStartedEvent = (TaskStartedEvent)taskExecutionEvent;
            Task task3 = taskStartedEvent.task();
            this.pendingPlanItemScheduledJobService().unschedule(task3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (taskExecutionEvent instanceof TaskCompletedEvent) {
            TaskCompletedEvent taskCompletedEvent = (TaskCompletedEvent)taskExecutionEvent;
            Task task4 = taskCompletedEvent.task();
            boolean bl = taskCompletedEvent.inAdvance();
            if (bl) {
                this.pendingPlanItemScheduledJobService().unschedule(task4);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (taskExecutionEvent instanceof TaskSkippedEvent) {
            TaskSkippedEvent taskSkippedEvent = (TaskSkippedEvent)taskExecutionEvent;
            Task task5 = taskSkippedEvent.task();
            boolean bl = taskSkippedEvent.inAdvance();
            if (bl) {
                this.pendingPlanItemScheduledJobService().unschedule(task5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (taskExecutionEvent instanceof TaskReopenedEvent && (task2 = (taskReopenedEvent = (TaskReopenedEvent)taskExecutionEvent).task()).canScheduleTaskStart()) {
            this.pendingPlanItemScheduledJobService().schedule(task2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (taskExecutionEvent instanceof TaskDelayedEvent && (task = (taskDelayedEvent = (TaskDelayedEvent)taskExecutionEvent).task()).canScheduleTaskStart()) {
            this.pendingPlanItemScheduledJobService().schedule(task);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Subscribe
    public void onTaskMovedEvent(TaskMovedEvent event) {
        block1: {
            Task task = event.movedTask();
            if (task.getRelease().isTemplate()) break block1;
            this.pendingPlanItemScheduledJobService().unschedule(event.originalTaskId());
            if (task.canScheduleTaskStart()) {
                this.pendingPlanItemScheduledJobService().schedule(task);
            }
        }
    }

    @Subscribe
    public void onTaskDeletedEvent(TaskDeletedEvent event) {
        block0: {
            if (event.task().getRelease().isTemplate()) break block0;
            this.pendingPlanItemScheduledJobService().unschedule(event.task());
        }
    }

    @Autowired
    public PendingTaskAutoStartEventHandler(PendingPlanItemScheduledJobService pendingPlanItemScheduledJobService) {
        this.pendingPlanItemScheduledJobService = pendingPlanItemScheduledJobService;
        Logging.$init$((Logging)this);
    }
}

