/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivedReleaseDeserialization;
import com.xebialabs.xlrelease.service.ArchivedReleaseReader;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0005\u0011]s!B\u001c9\u0011\u0003\te!B\"9\u0011\u0003!\u0005\"B*\u0002\t\u0003!\u0006\"B+\u0002\t\u00031f\u0001B\"9\u00019D\u0001B\u001d\u0003\u0003\u0006\u0004%\ta\u001d\u0005\tu\u0012\u0011\t\u0011)A\u0005i\"A1\u0010\u0002B\u0001B\u0003%A\u0010C\u0005\u0000\t\t\u0005\t\u0015!\u0003\u0002\u0002!Q\u0011q\u0001\u0003\u0003\u0006\u0004%\t!!\u0003\t\u0015\u0005mAA!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u001e\u0011\u0011\t\u0011)A\u0005\u0003?A!\"!\n\u0005\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011)\t\t\u0004\u0002B\u0001B\u0003%\u00111\u0007\u0005\u000b\u0003s!!\u0011!Q\u0001\n\u0005m\u0002BCA$\t\t\u0005\t\u0015!\u0003\u0002J!Q\u0011q\n\u0003\u0003\u0002\u0003\u0006I!!\u0015\t\u0015\u0005]CA!A!\u0002\u0013\tI\u0006\u0003\u0006\u0002`\u0011\u0011\t\u0011)A\u0005\u0003CB!\"a\u001a\u0005\u0005\u0003\u0005\u000b\u0011BA5\u0011\u0019\u0019F\u0001\"\u0001\u0002p!9\u0011q\u0015\u0003\u0005\u0002\u0005%\u0006bBAe\t\u0011%\u00111\u001a\u0005\b\u0003;$A\u0011BAp\u0011\u001d\t\u0019\u000f\u0002C\u0001\u0003KDq!!=\u0005\t\u0003\t\u0019\u0010C\u0004\u0002z\u0012!\t!a?\t\u000f\u0005eH\u0001\"\u0001\u0002\u0000\"9!\u0011\u0002\u0003\u0005\u0002\t-\u0001b\u0002B\t\t\u0011\u0005!1\u0003\u0005\b\u0005C!A\u0011\u0001B\u0012\u0011\u001d\u0011\t\u0004\u0002C\u0001\u0005gAqAa\u0012\u0005\t\u0003\u0011I\u0005C\u0004\u0003R\u0011!\tAa\u0015\t\u000f\teC\u0001\"\u0001\u0003\\!9!1\r\u0003\u0005\u0002\t\u0015\u0004b\u0002B6\t\u0011\u0005!Q\u000e\u0005\b\u0005k\"A\u0011\u0001B<\u0011\u001d\u0011\u0019\t\u0002C\u0001\u0005\u000bCqA!%\u0005\t\u0003\u0011\u0019\nC\u0004\u0003\u0012\u0012!\tAa0\t\u000f\tMG\u0001\"\u0001\u0003V\"I1\u0011\u0006\u0003\u0012\u0002\u0013\u000511\u0006\u0005\n\u0007\u007f!\u0011\u0013!C\u0001\u0007WAqa!\u0011\u0005\t\u0003\u0019\u0019\u0005C\u0004\u0004b\u0011!\taa\u0019\t\u000f\r%D\u0001\"\u0001\u0004l!911\u0012\u0003\u0005\u0002\r5\u0005bBBJ\t\u0011\u00051Q\u0013\u0005\b\u0005##A\u0011BBR\u0011\u001d\u0019Y\u000b\u0002C\u0001\u0007[Cqa!.\u0005\t\u0003\u00199\fC\u0004\u0004J\u0012!Iaa3\t\u000f\reH\u0001\"\u0003\u0004|\"9A\u0011\u0001\u0003\u0005\n\u0011\r\u0011\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0015\tI$(A\u0004tKJ4\u0018nY3\u000b\u0005mb\u0014!\u0003=me\u0016dW-Y:f\u0015\tid(A\u0005yK\nL\u0017\r\\1cg*\tq(A\u0002d_6\u001c\u0001\u0001\u0005\u0002C\u00035\t\u0001H\u0001\tBe\u000eD\u0017N^5oON+'O^5dKN\u0019\u0011!R&\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g!\ta\u0015+D\u0001N\u0015\tqu*A\u0003tY\u001a$$NC\u0001Q\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001*N\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A!\u0002\u0019\u001d,G/T8oi\"LV-\u0019:\u0015\u0005]\u0013\u0007C\u0001-`\u001d\tIV\f\u0005\u0002[\u000f6\t1L\u0003\u0002]\u0001\u00061AH]8pizJ!AX$\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0017M\u0001\u0004TiJLgn\u001a\u0006\u0003=\u001eCQaY\u0002A\u0002\u0011\f\u0011b\u001d;beR$\u0015\r^3\u0011\u0005\u0015dW\"\u00014\u000b\u0005\u001dD\u0017\u0001\u0002;j[\u0016T!!\u001b6\u0002\t)|G-\u0019\u0006\u0002W\u0006\u0019qN]4\n\u000554'\u0001\u0003#bi\u0016$\u0016.\\3\u0014\t\u0011)un\u0013\t\u0003\u0005BL!!\u001d\u001d\u0003+\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u0014V-\u00193fe\u0006\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011qOO\u0001\u0003I\nL!!\u001f<\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u00051\u0012M]2iSZ,GMU3mK\u0006\u001cXm]*fCJ\u001c\u0007\u000e\u0005\u0002v{&\u0011aP\u001e\u0002\u0017\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\u001cV-\u0019:dQ\u0006q\u0012M]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM]5bY&TXM\u001d\t\u0004\u0005\u0006\r\u0011bAA\u0003q\tq\u0012I]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM]5bY&TXM]\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014XCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t!B]3q_NLGo\u001c:z\u0015\r\t)\u0002P\u0001\tI\u0016\u0004Hn\\=ji&!\u0011\u0011DA\b\u0005E\u0011V\r]8tSR|'/_!eCB$XM]\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b%\u0001\u0010d_6\u0004H.\u001a;fIJ+G.Z1tKN,\u0005\u0010]8siN+'O^5dKB\u0019!)!\t\n\u0007\u0005\r\u0002HA\u000fD_6\u0004H.\u001a;fIJ+G.Z1tK\u0016C\bo\u001c:u'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0005\u0003S\ti#\u0004\u0002\u0002,)\u0019\u0011\u0011\u0003\u001e\n\t\u0005=\u00121\u0006\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002*\u0005U\u0012\u0002BA\u001c\u0003W\u0011A\u0003R3qK:$WM\\2z%\u0016\u0004xn]5u_JL\u0018a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005#(\u0001\u0004bGR|'o]\u0005\u0005\u0003\u000b\nyDA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-\u0001\buK\u0006l'+\u001a9pg&$xN]=\u0011\t\u0005%\u00121J\u0005\u0005\u0003\u001b\nYC\u0001\bUK\u0006l'+\u001a9pg&$xN]=\u0002\u0015M,7-\u001e:fI\u000eK7\u000f\u0005\u0003\u0002*\u0005M\u0013\u0002BA+\u0003W\u0011!bU3dkJ,GmQ5t\u0003m\u0011X\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ssB!\u0011\u0011FA.\u0013\u0011\ti&a\u000b\u00037I+G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:z\u00039\u0019w.\\7f]R\u001cVM\u001d<jG\u0016\u00042AQA2\u0013\r\t)\u0007\u000f\u0002\u000f\u0007>lW.\u001a8u'\u0016\u0014h/[2f\u0003e1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0011\t\u0005%\u00121N\u0005\u0005\u0003[\nYCA\rGC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014H\u0003HA9\u0003g\n)(a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u00151\u0012\t\u0003\u0005\u0012AQA\u001d\u000bA\u0002QDQa\u001f\u000bA\u0002qDaa \u000bA\u0002\u0005\u0005\u0001bBA\u0004)\u0001\u0007\u00111\u0002\u0005\b\u0003;!\u0002\u0019AA\u0010\u0011\u001d\t)\u0003\u0006a\u0001\u0003OAq!!\r\u0015\u0001\u0004\t\u0019\u0004C\u0004\u0002:Q\u0001\r!a\u000f\t\u000f\u0005\u001dC\u00031\u0001\u0002J!9\u0011q\n\u000bA\u0002\u0005E\u0003bBA,)\u0001\u0007\u0011\u0011\f\u0005\b\u0003?\"\u0002\u0019AA1\u0011\u001d\t9\u0007\u0006a\u0001\u0003SB3\u0001FAH!\u0011\t\t*a)\u000e\u0005\u0005M%\u0002BAK\u0003/\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\tI*a'\u0002\u000f\u0019\f7\r^8ss*!\u0011QTAP\u0003\u0015\u0011W-\u00198t\u0015\r\t\tK[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u0011QUAJ\u0005%\tU\u000f^8xSJ,G-\u0001\bbe\u000eD\u0017N^3SK2,\u0017m]3\u0015\t\u0005-\u0016\u0011\u0017\t\u0004\r\u00065\u0016bAAX\u000f\n!QK\\5u\u0011\u0019\t\u0019,\u0006a\u0001/\u0006I!/\u001a7fCN,\u0017\n\u001a\u0015\u0004+\u0005]\u0006\u0003BA]\u0003\u000bl!!a/\u000b\t\u0005U\u0015Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005\rg(\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t9-a/\u0003\u000bQKW.\u001a3\u0002%\u0005\u00148\r[5wK\u0006#H/Y2i[\u0016tGo\u001d\u000b\u0005\u0003W\u000bi\rC\u0004\u0002PZ\u0001\r!!5\u0002\u000fI,G.Z1tKB!\u00111[Am\u001b\t\t)NC\u0002\u0002Xj\na\u0001Z8nC&t\u0017\u0002BAn\u0003+\u0014qAU3mK\u0006\u001cX-A\nbe\u000eD\u0017N^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002,\u0006\u0005\bbBAh/\u0001\u0007\u0011\u0011[\u0001\u0018I\u0016dW\r^3Qe\u0016\f%o\u00195jm\u0016\u0014V\r\\3bg\u0016$B!a:\u0002nB\u0019a)!;\n\u0007\u0005-xIA\u0004C_>dW-\u00198\t\r\u0005M\u0006\u00041\u0001XQ\rA\u0012qW\u0001\u0012aJ,\u0017I]2iSZ,'+\u001a7fCN,G\u0003BAV\u0003kDq!a4\u001a\u0001\u0004\t\t\u000eK\u0002\u001a\u0003o\u000b!bZ3u%\u0016dW-Y:f)\u0011\t\t.!@\t\r\u0005M&\u00041\u0001X)\u0019\t\tN!\u0001\u0003\u0004!1\u00111W\u000eA\u0002]CqA!\u0002\u001c\u0001\u0004\t9/\u0001\nj]\u000edW\u000fZ3Qe\u0016\f%o\u00195jm\u0016$\u0007fA\u000e\u00028\u0006yq-\u001a;SK2,\u0017m]3USRdW\rF\u0002X\u0005\u001bAa!a-\u001d\u0001\u00049\u0006f\u0001\u000f\u00028\u0006Aq-\u001a;QQ\u0006\u001cX\r\u0006\u0003\u0003\u0016\tm\u0001\u0003BAj\u0005/IAA!\u0007\u0002V\n)\u0001\u000b[1tK\"1!QD\u000fA\u0002]\u000bq\u0001\u001d5bg\u0016LE\rK\u0002\u001e\u0003o\u000bqaZ3u)\u0006\u001c8\u000e\u0006\u0003\u0003&\t-\u0002\u0003BAj\u0005OIAA!\u000b\u0002V\n!A+Y:l\u0011\u0019\u0011iC\ba\u0001/\u00061A/Y:l\u0013\u0012D3AHA\\\u0003-9W\r\u001e,be&\f'\r\\3\u0015\t\tU\"\u0011\t\t\u0005\u0005o\u0011i$\u0004\u0002\u0003:)!!1HAk\u0003%1\u0018M]5bE2,7/\u0003\u0003\u0003@\te\"\u0001\u0003,be&\f'\r\\3\t\r\t\rs\u00041\u0001X\u0003)1\u0018M]5bE2,\u0017\n\u001a\u0015\u0004?\u0005]\u0016AB3ySN$8\u000f\u0006\u0003\u0002h\n-\u0003B\u0002B'A\u0001\u0007q+\u0001\u0003dS&#\u0007f\u0001\u0011\u00028\u0006\tR\r_5tiN\u0004&/Z!sG\"Lg/\u001a3\u0015\t\u0005\u001d(Q\u000b\u0005\u0007\u0005\u001b\n\u0003\u0019A,)\u0007\u0005\n9,\u0001\u0007fq&\u001cHo\u001d\"z\u001d\u0006lW\r\u0006\u0003\u0002h\nu\u0003B\u0002B0E\u0001\u0007q+A\u0006sK2,\u0017m]3OC6,\u0007f\u0001\u0012\u00028\u0006\u00012\r[3dW:{G/\u0011:dQ&4X\r\u001a\u000b\u0005\u0003W\u00139\u0007\u0003\u0004\u0003N\r\u0002\ra\u0016\u0015\u0004G\u0005]\u0016\u0001E1ui\u0006\u001c\u0007.\\3oi\u0016C\u0018n\u001d;t)\u0011\t9Oa\u001c\t\r\tED\u00051\u0001X\u00031\tG\u000f^1dQ6,g\u000e^%eQ\r!\u0013qW\u0001\u000eO\u0016$\u0018\t\u001e;bG\"lWM\u001c;\u0015\t\te$q\u0010\t\u0005\u0003'\u0014Y(\u0003\u0003\u0003~\u0005U'AC!ui\u0006\u001c\u0007.\\3oi\"1!\u0011O\u0013A\u0002]C3!JA\\\u0003M9W\r^!ui\u0006\u001c\u0007.\\3oi>\u0003H/[8o)\u0011\u00119I!$\u0011\u000b\u0019\u0013II!\u001f\n\u0007\t-uI\u0001\u0004PaRLwN\u001c\u0005\u0007\u0005c2\u0003\u0019A,)\u0007\u0019\n9,\u0001\btK\u0006\u00148\r\u001b*fY\u0016\f7/Z:\u0015\t\tU%Q\u0015\t\u0007\u0005/\u0013\t+!5\u000e\u0005\te%\u0002\u0002BN\u0005;\u000bA!\u001e;jY*\u0011!qT\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003$\ne%\u0001\u0002'jgRDqAa*(\u0001\u0004\u0011I+A\u0004gS2$XM]:\u0011\t\t-&\u0011X\u0007\u0003\u0005[SAAa,\u00032\u0006)am\u001c:ng*!!1\u0017B[\u0003\t1\u0018GC\u0002\u00038j\n1!\u00199j\u0013\u0011\u0011YL!,\u0003\u001fI+G.Z1tKN4\u0015\u000e\u001c;feND3aJA\\)!\u0011)J!1\u0003D\n5\u0007b\u0002BTQ\u0001\u0007!\u0011\u0016\u0005\b\u0005\u000bD\u0003\u0019\u0001Bd\u0003\u0015a\u0017.\\5u!\r1%\u0011Z\u0005\u0004\u0005\u0017<%\u0001\u0002'p]\u001eDqAa4)\u0001\u0004\u00119-\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0004Q\u0005]\u0016A\r4j]\u0012\u001c\u0006n\u001c:u%\u0016dW-Y:f\u0013\u0012\u001cx+\u001b;i\r>dG-\u001a:OC6,\u0017I\u001c3Pe\u0012,'o\u0011:ji\u0016\u0014\u0018n\u001c8\u0015\u0015\t]'q`B\u000b\u0007C\u0019)\u0003\u0005\u0004\u0003Z\n\r(q\u001d\b\u0005\u00057\u0014yND\u0002[\u0005;L\u0011\u0001S\u0005\u0004\u0005C<\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005G\u0013)OC\u0002\u0003b\u001e\u0003rA\u0012Bu\u0005[\u0014I0C\u0002\u0003l\u001e\u0013a\u0001V;qY\u0016\u0014\u0004\u0003\u0002Bx\u0005kl!A!=\u000b\t\tM\u0018Q[\u0001\u0006kRLGn]\u0005\u0005\u0005o\u0014\tPA\tBI\u0006\u0004H/\u001b<f%\u0016dW-Y:f\u0013\u0012\u00042A\u0012B~\u0013\r\u0011ip\u0012\u0002\u0004\u0003:L\bb\u0002BTS\u0001\u00071\u0011\u0001\t\u0007\u00053\u001c\u0019aa\u0002\n\t\r\u0015!Q\u001d\u0002\u0004'\u0016\f\b\u0003BB\u0005\u0007#i!aa\u0003\u000b\t\t\u001d6Q\u0002\u0006\u0004\u0007\u001fQ\u0014a\u0002:fa>\u0014Ho]\u0005\u0005\u0007'\u0019YA\u0001\u0007SKB|'\u000f\u001e$jYR,'\u000fC\u0004\u0004\u0018%\u0002\ra!\u0007\u0002\u000b=\u0014H-\u001a:\u0011\u000b\u0019\u0013Iia\u0007\u0011\t\t-6QD\u0005\u0005\u0007?\u0011iK\u0001\tSK2,\u0017m]3Pe\u0012,'/T8eK\"I!QY\u0015\u0011\u0002\u0003\u000711\u0005\t\u0006\r\n%%q\u0019\u0005\n\u0005\u001fL\u0003\u0013!a\u0001\u0007GA3!KA\\\u0003q2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r5\"\u0006BB\u0012\u0007_Y#a!\r\u0011\t\rM21H\u0007\u0003\u0007kQAaa\u000e\u0004:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+;\u0015\u0002BB\u001f\u0007k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tG\u0005Z3gCVdG\u000f\n\u001b\u0002+\r|WO\u001c;SK2,\u0017m]3t\u0005f\u001cF/\u0019;vgR!1QIB/!\u001dA6qIB&\u0007/J1a!\u0013b\u0005\ri\u0015\r\u001d\t\u0005\u0007\u001b\u001a\u0019&\u0004\u0002\u0004P)!1\u0011KAk\u0003\u0019\u0019H/\u0019;vg&!1QKB(\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vgB\u0019ai!\u0017\n\u0007\rmsIA\u0002J]RDqAa*-\u0001\u0004\u0011I\u000bK\u0002-\u0003o\u000bQbY8v]R\u0014V\r\\3bg\u0016\u001cH\u0003BB#\u0007KBqAa*.\u0001\u0004\u0019\t\u0001K\u0002.\u0003o\u000b\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0019iga\u001c\u0004zA)!\u0011\\B\u0002/\"91\u0011\u000f\u0018A\u0002\rM\u0014\u0001\u00023bi\u0016\u0004BAa&\u0004v%!1q\u000fBM\u0005\u0011!\u0015\r^3\t\u000f\rmd\u00061\u0001\u0004~\u0005A\u0001/Y4f'&TX\r\u0005\u0003\u0004\u0000\r\u0015UBABA\u0015\u0011\u0019\u0019I!(\u0002\t1\fgnZ\u0005\u0005\u0007\u000f\u001b\tIA\u0004J]R,w-\u001a:)\u00079\n9,\u0001\u0010be\u000eD\u0017N^3BY2LenY8nS:<G)\u001a9f]\u0012,gnY5fgR!\u00111VBH\u0011\u0019\t\u0019l\fa\u0001/\"\u001aq&a.\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0004\u0018\u000eu\u0005#\u0002BL\u00073;\u0016\u0002BBN\u00053\u00131aU3u\u0011\u001d\u0019y\n\ra\u0001\u0007/\n1\u0002\\5nSRtU/\u001c2fe\"\u001a\u0001'a.\u0015\u0011\tU5QUBT\u0007SCqAa*2\u0001\u0004\u0011I\u000bC\u0004\u0003FF\u0002\raa\t\t\u000f\t=\u0017\u00071\u0001\u0004$\u0005Q2/Z1sG\"\u0014V\r\\3bg\u0016\u001c()\u001f*fY\u0016\f7/Z%egR!1qVBY!\u0019\u0011Ina\u0001\u0002R\"911\u0017\u001aA\u0002\r5\u0014A\u0003:fY\u0016\f7/Z%eg\u0006\u00113/Z1sG\"\u0014V\r\\3bg\u0016\u001c()Y:jG\u0016CHOQ=SK2,\u0017m]3JIN$Ba!/\u0004HB1!\u0011\\B\u0002\u0007w\u0003Ba!0\u0004D6\u00111q\u0018\u0006\u0005\u0007\u0003\fY#A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0004F\u000e}&a\u0005*fY\u0016\f7/\u001a\"bg&\u001cG)\u0019;b\u000bb$\bbBBZg\u0001\u00071QN\u0001\u000fO\u0016$(+\u001a7fCN,\u0017\n^3n+\u0011\u0019ima6\u0015\t\r=7Q\u001f\u000b\u0005\u0007#\u001cI\u000fE\u0003G\u0005\u0013\u001b\u0019\u000e\u0005\u0003\u0004V\u000e]G\u0002\u0001\u0003\b\u00073$$\u0019ABn\u0005\u0005!\u0016\u0003BBo\u0007G\u00042ARBp\u0013\r\u0019\to\u0012\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019n!:\n\t\r\u001d\u0018Q\u001b\u0002\t!2\fg.\u0013;f[\"911\u001e\u001bA\u0002\r5\u0018aB4fi&#X-\u001c\t\b\r\u000e=\u0018\u0011[Bz\u0013\r\u0019\tp\u0012\u0002\n\rVt7\r^5p]F\u0002bARBx/\u000eM\u0007BBB|i\u0001\u0007q+\u0001\u0004ji\u0016l\u0017\nZ\u0001\u0012O\u0016$h+\u0019:jC\ndWm\u00149uS>tG\u0003BB\u007f\u0007\u007f\u0004RA\u0012BE\u0005kAaAa\u00116\u0001\u00049\u0016AH1sG\"Lg/Z!mY>+HoZ8j]\u001e$U\r]3oI\u0016t7-[3t)\u0011!)\u0001\"\u0004\u0011\r\te71\u0001C\u0004!\u0011\t\u0019\u000e\"\u0003\n\t\u0011-\u0011Q\u001b\u0002\u000b\t\u0016\u0004XM\u001c3f]\u000eL\bbBAhm\u0001\u0007\u0011\u0011\u001b\u0015\u0014\t\u0011EAq\u0004C\u0011\tK!9\u0003\"\r\u00054\u0011uBq\b\t\u0005\t'!Y\"\u0004\u0002\u0005\u0016)!\u0011Q\u0013C\f\u0015\u0011!I\"a(\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\t;!)BA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u0006m\u0006dW/Z\u0011\u0003\tG\t1D]3q_J$\u0018N\\4Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\u0018a\u00039s_B\fw-\u0019;j_:$#\u0001\"\u000b\n\t\u0011-BQF\u0001\t%\u0016\u000bV+\u0013*F\t*!Aq\u0006C\u000b\u0003-\u0001&o\u001c9bO\u0006$\u0018n\u001c8\u0002\u0013%\u001cx\u000e\\1uS>tGE\u0001C\u001b\u0013\u0011!9\u0004\"\u000f\u0002\u001dI+\u0015\tR0D\u001f6k\u0015\n\u0016+F\t*!A1\bC\u000b\u0003%I5o\u001c7bi&|g.A\u0006s_2d'-Y2l\r>\u0014HF\u0001C!G\t!\u0019\u0005\u0005\u0003\u0003Z\u0012\u0015\u0013\u0002\u0002C$\u0005K\u0014\u0011\u0002\u00165s_^\f'\r\\3)\u0007\u0011!Y\u0005\u0005\u0003\u0005N\u0011MSB\u0001C(\u0015\u0011!\t&a(\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0005V\u0011=#aB*feZL7-\u001a")
public class ArchivingService
implements ArchivedReleaseReader {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime startDate) {
        return ArchivingService$.MODULE$.getMonthYear(startDate);
    }

    @Override
    public Option<Release> getReleaseOption(String releaseId, boolean includePreArchived, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseReader.getReleaseOption$(this, releaseId, includePreArchived, ciConverter);
    }

    @Override
    public boolean getReleaseOption$default$2() {
        return ArchivedReleaseReader.getReleaseOption$default$2$(this);
    }

    @Override
    public ConfigurationItemConverter getReleaseOption$default$3() {
        return ArchivedReleaseReader.getReleaseOption$default$3$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeArchivedRelease(String releaseJson, RepositoryAdapter repository, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseDeserialization.deserializeArchivedRelease$(this, releaseJson, repository, ciConverter);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES), (Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.releaseExtensionsRepository.decorate(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveRelease$6(task, x$1)))).asJava()));
                    return BoxedUnit.UNIT;
                });
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(updatedTeams).asScala().toSeq());
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId, this.releaseRepository.delete$default$2());
                    ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).foreach((Function1 & Serializable)facet -> {
                        ArchivingService.$anonfun$archiveRelease$10(this, facet);
                        return BoxedUnit.UNIT;
                    });
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        Option previousWorkDirContext = Option$.MODULE$.apply((Object)WorkDirContext.get());
        WorkDirContext.initWorkdir();
        try {
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAttachments()).asScala().foreach((Function1 & Serializable)attachment -> {
                ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Option$.MODULE$.apply((Object)WorkDirContext.get()).foreach((Function1 & Serializable)x$2 -> {
                x$2.delete();
                return BoxedUnit.UNIT;
            });
            WorkDirContext.clear();
            previousWorkDirContext.foreach((Function1 & Serializable)x$1 -> {
                ArchivingService.$anonfun$archiveAttachments$6(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveDependencies(Release release) {
        scala.collection.immutable.Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public boolean deletePreArchiveRelease(String releaseId) {
        return this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$3(task, x$3)))).asJava()));
                return BoxedUnit.UNIT;
            });
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
                ((IterableOnceOps)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$5(specialTypes, facet)))).foreach((Function1 & Serializable)liveFacet -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet));
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId(), this.releaseRepository.delete$default$2());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived, this.getReleaseOption$default$3()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable)x$4 -> (Function1 & Serializable)x$1 -> x$4.getPhase(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable)x$5 -> (Function1 & Serializable)x$1 -> x$5.getTask(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$6 -> (Function1 & Serializable)x$1 -> x$6.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$7 -> (Function1 & Serializable)x$1 -> x$7.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(scala.collection.immutable.Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(scala.collection.immutable.Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        scala.collection.immutable.Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()))).asJava();
    }

    public scala.collection.immutable.Seq<Release> searchReleasesByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        scala.collection.immutable.Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (scala.collection.immutable.Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()));
    }

    public scala.collection.immutable.Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIds.map((Function1 & Serializable)x$9 -> FullReleaseId$.MODULE$.apply((String)x$9).withOnlyOneParentOrApplicationsForArchiveDb())));
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$10))));
    }

    private scala.collection.immutable.Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        Buffer dependencies = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$12)));
        dependencies.foreach((Function1 & Serializable)x$13 -> {
            x$13.archive();
            return BoxedUnit.UNIT;
        });
        return dependencies.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$archiveRelease$6(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$10(ArchivingService $this, Facet facet) {
        ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete(facet.getId(), ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete$default$2());
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$6(WorkDir x$1) {
        WorkDirContext.setWorkDir((WorkDir)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$3(Task task$2, Facet x$3) {
        String string = x$3.getTargetId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$5(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        scala.collection.immutable.Seq rawDependenciesToArchive = (scala.collection.immutable.Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)rawDependenciesToArchive.map((Function1 & Serializable)x$8 -> x$8.getId())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$10) {
        String string = x$10.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$12) {
        return !x$12.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        ArchivedReleaseDeserialization.$init$(this);
        Logging.$init$((Logging)this);
        ArchivedReleaseReader.$init$(this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
    }
}

