/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.TeamsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService$FolderAndEvents$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011ub\u0001B&M\u0001UC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003v\u0011!A\bA!A!\u0002\u0013I\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B?\t\u0015\u0005\u0005\u0001A!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\n\u0001\u0011\t\u0011)A\u0005\u0003\u0017A!\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t)\u0003\u0001B\u0001B\u0003%\u0011q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013Bq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u0010\u0002!\t!!%\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"I\u00111\u0019\u0001\u0012\u0002\u0013\u0005\u0011Q\u0019\u0005\b\u00033\u0004A\u0011AAn\u0011%\t9\u000fAI\u0001\n\u0003\t)\rC\u0005\u0002j\u0002\t\n\u0011\"\u0001\u0002l\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\b\"\u0003B\u0001\u0001E\u0005I\u0011\u0001B\u0002\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013A\u0011B!\f\u0001#\u0003%\t!a;\t\u0013\t=\u0002!%A\u0005\u0002\u0005-\bb\u0002B\u0019\u0001\u0011\u0005!1\u0007\u0005\b\u0005{\u0001A\u0011\u0001B \u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017B\u0011Ba\u0018\u0001#\u0003%\t!a;\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!I!q\u0012\u0001\u0012\u0002\u0013\u0005!\u0011\u0013\u0005\b\u0005+\u0003A\u0011\u0001BL\u0011%\u0011)\u000bAI\u0001\n\u0003\tY\u000fC\u0004\u0003(\u0002!\tA!+\t\u000f\t\u001d\u0006\u0001\"\u0001\u00032\u001a1!Q\u0018\u0001A\u0005\u007fC!\"!)$\u0005+\u0007I\u0011\u0001Bm\u0011)\u0011Yn\tB\tB\u0003%\u00111\u0014\u0005\u000b\u0003?\u0019#Q3A\u0005\u0002\tu\u0007B\u0003BxG\tE\t\u0015!\u0003\u0003`\"9\u0011QF\u0012\u0005\u0002\tE\b\"\u0003B~G\u0005\u0005I\u0011\u0001B\u007f\u0011%\u0019\u0019aII\u0001\n\u0003\u0019)\u0001C\u0005\u0004\n\r\n\n\u0011\"\u0001\u0004\f!I1qB\u0012\u0002\u0002\u0013\u00053\u0011\u0003\u0005\n\u0007/\u0019\u0013\u0011!C\u0001\u00073A\u0011ba\u0007$\u0003\u0003%\ta!\b\t\u0013\r%2%!A\u0005B\r-\u0002\"CB\u001dG\u0005\u0005I\u0011AB\u001e\u0011%\u0019ydIA\u0001\n\u0003\u001a\t\u0005C\u0005\u0004F\r\n\t\u0011\"\u0011\u0004H!I1\u0011J\u0012\u0002\u0002\u0013\u000531\n\u0005\n\u0007\u001b\u001a\u0013\u0011!C!\u0007\u001f:\u0011ba\u0015\u0001\u0003\u0003E\ta!\u0016\u0007\u0013\tu\u0006!!A\t\u0002\r]\u0003bBA\u0017m\u0011\u00051q\u000e\u0005\n\u0007\u00132\u0014\u0011!C#\u0007\u0017B\u0011b!\u001d7\u0003\u0003%\tia\u001d\t\u0013\red'%A\u0005\u0002\r-\u0001\"CB>m\u0005\u0005I\u0011QB?\u0011%\u0019yINI\u0001\n\u0003\u0019Y\u0001C\u0004\u0004\u0012\u0002!\taa%\t\u000f\rm\u0005\u0001\"\u0001\u0004\u001e\"911\u0015\u0001\u0005\n\r\u0015\u0006bBBX\u0001\u0011%1\u0011\u0017\u0005\b\u0007\u0007\u0004A\u0011BBc\u0011\u001d\u0019Y\r\u0001C\u0005\u0007\u001bDqa!6\u0001\t\u0013\u00199\u000eC\u0004\u0004\\\u0002!Ia!8\t\u000f\r\u001d\b\u0001\"\u0001\u0004j\"9A1\u0001\u0001\u0005\n\u0011\u0015\u0001b\u0002C\n\u0001\u0011%AQ\u0003\u0005\b\tS\u0001A\u0011\u0002C\u0016\u0011\u001d!\t\u0004\u0001C\u0005\tgAq\u0001b\u000e\u0001\t\u0013!IDA\u0007G_2$WM]*feZL7-\u001a\u0006\u0003\u001b:\u000bqa]3sm&\u001cWM\u0003\u0002P!\u0006I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003#J\u000b\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003M\u000b1aY8n\u0007\u0001\u00192\u0001\u0001,]!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u0019\te.\u001f*fMB\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0006g24GG\u001b\u0006\u0002C\u0006AqM]5{u2,G-\u0003\u0002d=\n9Aj\\4hS:<\u0017a\u00024pY\u0012,'o\u001d\t\u0003M&l\u0011a\u001a\u0006\u0003Q:\u000b!B]3q_NLGo\u001c:z\u0013\tQwM\u0001\tG_2$WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006YA/Z1n'\u0016\u0014h/[2f!\tig.D\u0001M\u0013\tyGJA\u0006UK\u0006l7+\u001a:wS\u000e,\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011aM]\u0005\u0003g\u001e\u0014\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003-!\u0018m]6TKJ4\u0018nY3\u0011\u000554\u0018BA<M\u0005-!\u0016m]6TKJ4\u0018nY3\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u00014{\u0013\tYxMA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006Y1-[%e'\u0016\u0014h/[2f!\tig0\u0003\u0002\u0000\u0019\nY1)[%e'\u0016\u0014h/[2f\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKB\u0019Q.!\u0002\n\u0007\u0005\u001dAJ\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\fa\u0016\u0014X.[:tS>t7\u000f\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tBT\u0001\tg\u0016\u001cWO]5us&!\u0011QCA\b\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\tKZ,g\u000e\u001e\"vgB!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 9\u000ba!\u001a<f]R\u001c\u0018\u0002BA\u0012\u0003;\u0011\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003A\t'o\u00195jm&twmU3sm&\u001cW\rE\u0002n\u0003SI1!a\u000bM\u0005A\t%o\u00195jm&twmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002FA\u0011Q\u000e\u0001\u0005\u0006I.\u0001\r!\u001a\u0005\u0006W.\u0001\r\u0001\u001c\u0005\u0006a.\u0001\r!\u001d\u0005\u0006i.\u0001\r!\u001e\u0005\u0006q.\u0001\r!\u001f\u0005\u0006y.\u0001\r! \u0005\b\u0003\u0003Y\u0001\u0019AA\u0002\u0011\u001d\tIa\u0003a\u0001\u0003\u0017Aq!a\u0006\f\u0001\u0004\tI\u0002C\u0004\u0002&-\u0001\r!a\n\u0002#\rDWmY6G_2$WM]#ySN$8\u000f\u0006\u0003\u0002L\u0005E\u0003cA,\u0002N%\u0019\u0011q\n-\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'b\u0001\u0019AA+\u0003!1w\u000e\u001c3fe&#\u0007\u0003BA,\u0003KrA!!\u0017\u0002bA\u0019\u00111\f-\u000e\u0005\u0005u#bAA0)\u00061AH]8pizJ1!a\u0019Y\u0003\u0019\u0001&/\u001a3fM&!\u0011qMA5\u0005\u0019\u0019FO]5oO*\u0019\u00111\r-)\u00071\ti\u0007\u0005\u0003\u0002p\u0005uTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002x\u0005e\u0014aB7fiJL7m\u001d\u0006\u0004\u0003w\u0012\u0016\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005}\u0014\u0011\u000f\u0002\u0006)&lW\rZ\u0001\u0007KbL7\u000f^:\u0015\t\u0005\u0015\u00151\u0012\t\u0004/\u0006\u001d\u0015bAAE1\n9!i\\8mK\u0006t\u0007bBA*\u001b\u0001\u0007\u0011Q\u000b\u0015\u0004\u001b\u00055\u0014\u0001C4fiRKG\u000f\\3\u0015\t\u0005U\u00131\u0013\u0005\b\u0003'r\u0001\u0019AA+Q\rq\u0011QN\u0001\tM&tGMQ=JIR1\u00111TAV\u0003[\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+\u0001\u0004g_2$WM\u001d\u0006\u0004\u0003Ks\u0015A\u00023p[\u0006Lg.\u0003\u0003\u0002*\u0006}%A\u0002$pY\u0012,'\u000fC\u0004\u0002T=\u0001\r!!\u0016\t\u0013\u0005=v\u0002%AA\u0002\u0005E\u0016!\u00023faRD\u0007\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0005Y\u0006twM\u0003\u0002\u0002<\u0006!!.\u0019<b\u0013\u0011\ty,!.\u0003\u000f%sG/Z4fe\"\u001aq\"!\u001c\u0002%\u0019Lg\u000e\u001a\"z\u0013\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fTC!!-\u0002J.\u0012\u00111\u001a\t\u0005\u0003\u001b\f).\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003%)hn\u00195fG.,GMC\u0002\u0002taKA!a6\u0002P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\u0019Lg\u000e\u001a,jK^\f'\r\\3G_2$WM]:Cs&#G\u0003CAN\u0003;\fy.!9\t\u000f\u0005M\u0013\u00031\u0001\u0002V!I\u0011qV\t\u0011\u0002\u0003\u0007\u0011\u0011\u0017\u0005\n\u0003G\f\u0002\u0013!a\u0001\u0003\u000b\u000b\u0011#\u001a8g_J\u001cW\rU3s[&\u001c8/[8oQ\r\t\u0012QN\u0001\"M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$C-\u001a4bk2$HEM\u0001\"M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003[TC!!\"\u0002J\u0006Qa-\u001b8e\u0005f\u0004\u0016\r\u001e5\u0015\r\u0005m\u00151_A|\u0011\u001d\t)\u0010\u0006a\u0001\u0003+\nA\u0001]1uQ\"I\u0011q\u0016\u000b\u0011\u0002\u0003\u0007\u0011\u0011 \t\u0004/\u0006m\u0018bAA\u007f1\n\u0019\u0011J\u001c;)\u0007Q\ti'\u0001\u000bgS:$')\u001f)bi\"$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000bQC!!?\u0002J\u0006\u0019B.[:u-&,w/\u00192mK\u001a{G\u000eZ3sgRQ!1\u0002B\f\u00057\u0011)C!\u000b\u0011\r\t5!1CAN\u001b\t\u0011yA\u0003\u0003\u0003\u0012\u0005e\u0016\u0001B;uS2LAA!\u0006\u0003\u0010\t!A*[:u\u0011\u001d\u0011IB\u0006a\u0001\u0003+\n\u0001\u0002]1sK:$\u0018\n\u001a\u0005\b\u0005;1\u0002\u0019\u0001B\u0010\u0003\u0011\u0001\u0018mZ3\u0011\u0007\u0019\u0014\t#C\u0002\u0003$\u001d\u0014A\u0001U1hK\"I!q\u0005\f\u0011\u0002\u0003\u0007\u0011QQ\u0001\u0018I\u0016\u001cwN]1uK^KG\u000f\u001b)fe6L7o]5p]ND\u0011\"a9\u0017!\u0003\u0005\r!!\")\u0007Y\ti'A\u000fmSN$h+[3xC\ndWMR8mI\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003ua\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:tI\u0011,g-Y;mi\u0012\"\u0014\u0001B7pm\u0016$b!a'\u00036\t]\u0002bBA*3\u0001\u0007\u0011Q\u000b\u0005\b\u0005sI\u0002\u0019AA+\u0003-qWm\u001e)be\u0016tG/\u00133)\u0007e\ti'\u0001\u0004sK:\fW.\u001a\u000b\u0007\u00037\u0013\tEa\u0011\t\u000f\u0005M#\u00041\u0001\u0002V!9!Q\t\u000eA\u0002\u0005U\u0013a\u00028fo:\u000bW.\u001a\u0015\u00045\u00055\u0014aD:fCJ\u001c\u0007\u000eV3na2\fG/Z:\u0015\u0011\t5#q\u000bB-\u00057\u0002bA!\u0004\u0003\u0014\t=\u0003\u0003\u0002B)\u0005'j!!a)\n\t\tU\u00131\u0015\u0002\b%\u0016dW-Y:f\u0011\u001d\t\u0019f\u0007a\u0001\u0003+BqA!\b\u001c\u0001\u0004\u0011y\u0002C\u0005\u0002dn\u0001\n\u00111\u0001\u0002\u0006\"\u001a1$!\u001c\u00023M,\u0017M]2i)\u0016l\u0007\u000f\\1uKN$C-\u001a4bk2$HeM\u0001\u000fg\u0016\f'o\u00195SK2,\u0017m]3t)!\u0011)G!\u001d\u0003t\t-\u0005\u0003\u0002B4\u0005[j!A!\u001b\u000b\u0007\t-d*\u0001\u0004tK\u0006\u00148\r[\u0005\u0005\u0005_\u0012IGA\nSK2,\u0017m]3TK\u0006\u00148\r\u001b*fgVdG\u000fC\u0004\u0002Tu\u0001\r!!\u0016\t\u000f\tUT\u00041\u0001\u0003x\u00059a-\u001b7uKJ\u001c\b\u0003\u0002B=\u0005\u000fk!Aa\u001f\u000b\t\tu$qP\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0005\u0003\u0013\u0019)\u0001\u0002wc)\u0019!Q\u0011(\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\n\nm$a\u0004*fY\u0016\f7/Z:GS2$XM]:\t\u0013\tuQ\u0004%AA\u0002\t}\u0001fA\u000f\u0002n\u0005A2/Z1sG\"\u0014V\r\\3bg\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM%\u0006\u0002B\u0010\u0003\u0013\fA\"\\8wKR+W\u000e\u001d7bi\u0016$\u0002\"!\u0016\u0003\u001a\nm%q\u0014\u0005\b\u0003'z\u0002\u0019AA+\u0011\u001d\u0011ij\ba\u0001\u0003+\n!\u0002^3na2\fG/Z%e\u0011%\u0011\tk\bI\u0001\u0002\u0004\t))\u0001\ttQ>,H\u000eZ'fe\u001e,G+Z1ng\"\u001aq$!\u001c\u0002-5|g/\u001a+f[Bd\u0017\r^3%I\u00164\u0017-\u001e7uIM\naa\u0019:fCR,GCBAN\u0005W\u0013i\u000bC\u0004\u0003\u001a\u0005\u0002\r!!\u0016\t\u000f\u0005\u0005\u0016\u00051\u0001\u0002\u001c\"\u001a\u0011%!\u001c\u0015\u0011\u0005m%1\u0017B[\u0005oCqA!\u0007#\u0001\u0004\t)\u0006C\u0004\u0002\"\n\u0002\r!a'\t\u000f\te&\u00051\u0001\u0002\u0006\u0006\u00112M]3bi\u0016$UMZ1vYR$V-Y7tQ\r\u0011\u0013Q\u000e\u0002\u0010\r>dG-\u001a:B]\u0012,e/\u001a8ugN11E\u0016Ba\u0005\u000f\u00042a\u0016Bb\u0013\r\u0011)\r\u0017\u0002\b!J|G-^2u!\u0011\u0011IMa5\u000f\t\t-'q\u001a\b\u0005\u00037\u0012i-C\u0001Z\u0013\r\u0011\t\u000eW\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Na6\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\tE\u0007,\u0006\u0002\u0002\u001c\u00069am\u001c7eKJ\u0004SC\u0001Bp!\u0019\u0011IM!9\u0003f&!!1\u001dBl\u0005\r\u0019V-\u001d\t\u0005\u0005O\u0014Y/\u0004\u0002\u0003j*!\u0011qDAR\u0013\u0011\u0011iO!;\u0003\u001dac%+\u001a7fCN,WI^3oi\u00069QM^3oiN\u0004CC\u0002Bz\u0005o\u0014I\u0010E\u0002\u0003v\u000ej\u0011\u0001\u0001\u0005\b\u0003CC\u0003\u0019AAN\u0011%\ty\u0002\u000bI\u0001\u0002\u0004\u0011y.\u0001\u0003d_BLHC\u0002Bz\u0005\u007f\u001c\t\u0001C\u0005\u0002\"&\u0002\n\u00111\u0001\u0002\u001c\"I\u0011qD\u0015\u0011\u0002\u0003\u0007!q\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00199A\u000b\u0003\u0002\u001c\u0006%\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0007\u001bQCAa8\u0002J\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"aa\u0005\u0011\t\u0005M6QC\u0005\u0005\u0003O\n),\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002z\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB\u0010\u0007K\u00012aVB\u0011\u0013\r\u0019\u0019\u0003\u0017\u0002\u0004\u0003:L\b\"CB\u0014]\u0005\u0005\t\u0019AA}\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\u0006\t\u0007\u0007_\u0019)da\b\u000e\u0005\rE\"bAB\u001a1\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r]2\u0011\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0006\u000eu\u0002\"CB\u0014a\u0005\u0005\t\u0019AB\u0010\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\rM11\t\u0005\n\u0007O\t\u0014\u0011!a\u0001\u0003s\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003s\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007'\ta!Z9vC2\u001cH\u0003BAC\u0007#B\u0011ba\n5\u0003\u0003\u0005\raa\b\u0002\u001f\u0019{G\u000eZ3s\u0003:$WI^3oiN\u00042A!>7'\u001514\u0011LB3!)\u0019Yf!\u0019\u0002\u001c\n}'1_\u0007\u0003\u0007;R1aa\u0018Y\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u0019\u0004^\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\r\u001d4QN\u0007\u0003\u0007SRAaa\u001b\u0002:\u0006\u0011\u0011n\\\u0005\u0005\u0005+\u001cI\u0007\u0006\u0002\u0004V\u0005)\u0011\r\u001d9msR1!1_B;\u0007oBq!!):\u0001\u0004\tY\nC\u0005\u0002 e\u0002\n\u00111\u0001\u0003`\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}41\u0012\t\u0006/\u000e\u00055QQ\u0005\u0004\u0007\u0007C&AB(qi&|g\u000eE\u0004X\u0007\u000f\u000bYJa8\n\u0007\r%\u0005L\u0001\u0004UkBdWM\r\u0005\n\u0007\u001b[\u0014\u0011!a\u0001\u0005g\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u000592M]3bi\u0016<\u0016\u000e\u001e5pkR\u0004VO\u00197jg\"Lgn\u001a\u000b\t\u0005g\u001c)ja&\u0004\u001a\"9!\u0011D\u001fA\u0002\u0005U\u0003bBAQ{\u0001\u0007\u00111\u0014\u0005\b\u0005sk\u0004\u0019AAC\u0003\u0019!W\r\\3uKR!\u00111JBP\u0011\u001d\t\u0019F\u0010a\u0001\u0003+B3APA7\u0003=\t'o\u00195jm\u0016|%\u000fR3mKR,GCBA&\u0007O\u001bY\u000bC\u0004\u0004*~\u0002\r!!?\u0002\u0013\u0019|G\u000eZ3s+&$\u0007bBBW\u007f\u0001\u0007\u0011QK\u0001\ne\u0016dW-Y:f\u0013\u0012\f!\"\\3sO\u0016$V-Y7t)!\tYea-\u00046\u000e]\u0006bBA*\u0001\u0002\u0007\u0011Q\u000b\u0005\b\u0005;\u0003\u0005\u0019AA+\u0011\u001d\u0019I\f\u0011a\u0001\u0007w\u000bQ\u0002^3na2\fG/\u001a+fC6\u001c\bC\u0002Be\u0005C\u001ci\f\u0005\u0003\u0003R\r}\u0016\u0002BBa\u0003G\u0013A\u0001V3b[\u0006a!/\u001a9mC\u000e,G+Z1ngR1\u00111JBd\u0007\u0013Dq!a\u0015B\u0001\u0004\t)\u0006C\u0004\u0003\u001e\u0006\u0003\r!!\u0016\u000275,'oZ3UK6\u0004H.\u0019;f\u0003:$gi\u001c7eKJ$V-Y7t)\u0019\u0019Yla4\u0004T\"91\u0011\u001b\"A\u0002\rm\u0016a\u00034pY\u0012,'\u000fV3b[NDqa!/C\u0001\u0004\u0019Y,A\u0007sKN,G\u000fV1tWR+\u0017-\u001c\u000b\u0005\u0003\u0017\u001aI\u000eC\u0004\u0003\u001e\u000e\u0003\r!!\u0016\u0002=\r\u0014X-\u0019;f\t\u00164\u0017-\u001e7u)\u0016\fWn\u001d$peRCWMR8mI\u0016\u0014HCBBp\u0007G\u001c)\u000f\u0005\u0004\u0003J\u000e\u0005(Q]\u0005\u0005\u0005+\u00119\u000eC\u0004\u0002\"\u0012\u0003\r!a'\t\u000f\teA\t1\u0001\u0002V\u0005yr-\u001a;O_:Le\u000e[3sSR,GMR8mI\u0016\u0014(+\u001a4fe\u0016t7-Z:\u0015\r\r-8Q`B\u0000!\u0019\u0019ioa=\u0004x6\u00111q\u001e\u0006\u0005\u0007c\u001c\t$A\u0004nkR\f'\r\\3\n\t\rU8q\u001e\u0002\u0004'\u0016$\b\u0003\u0002B)\u0007sLAaa?\u0002$\n\t\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005MS\t1\u0001\u0002V!9A\u0011A#A\u0002\u0005U\u0013a\u00038fo\u001a|G\u000eZ3s\u0013\u0012\fQc\u00195fG.4u\u000e\u001c3fe\u000e\u000bgNQ3N_Z,G\r\u0006\u0005\u0002L\u0011\u001dA\u0011\u0002C\b\u0011\u001d\t\u0019F\u0012a\u0001\u0003+Bq\u0001b\u0003G\u0001\u0004!i!A\toK^4w\u000e\u001c3fe&#w\n\u001d;j_:\u0004RaVBA\u0003+Bq\u0001\"\u0005G\u0001\u0004\t)&A\u0005pa\u0016\u0014\u0018\r^5p]\u0006i1M]3bi\u0016$U\r^1jYN$\u0002ba\u0005\u0005\u0018\u0011uA\u0011\u0005\u0005\b\t39\u0005\u0019\u0001C\u000e\u00039\t7\r^5wKJ+G.Z1tKN\u0004bA!3\u0003b\n=\u0003b\u0002C\u0010\u000f\u0002\u0007A1D\u0001\u0019CV$xn\u0015;beR\u0004VM\u001c3j]\u001e\u0014V\r\\3bg\u0016\u001c\bb\u0002C\u0012\u000f\u0002\u0007AQE\u0001\fS:4\u0018\r\\5e%\u001647\u000f\u0005\u0004\u00040\u0011\u001d2q_\u0005\u0005\u0007k\u001c\t$A\fdQ\u0016\u001c7\u000eV3na2\fG/Z\"b]\n+Wj\u001c<fIR1\u00111\nC\u0017\t_AqA!(I\u0001\u0004\t)\u0006C\u0004\u0002T!\u0003\r!!\u0016\u0002%\u001d,GOU;o]&twMU3mK\u0006\u001cXm\u001d\u000b\u0005\t7!)\u0004C\u0004\u0002T%\u0003\r!!\u0016\u00027\u001d,G/Q;u_N#\u0018M\u001d;QK:$\u0017N\\4SK2,\u0017m]3t)\u0011!Y\u0002b\u000f\t\u000f\u0005M#\n1\u0001\u0002V\u0001")
public class FolderService
implements Logging {
    private volatile FolderService$FolderAndEvents$ FolderAndEvents$module;
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public FolderService$FolderAndEvents$ FolderAndEvents() {
        if (this.FolderAndEvents$module == null) {
            this.FolderAndEvents$lzycompute$1();
        }
        return this.FolderAndEvents$module;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringBuilder(23).append("Folder ").append(Ids.ROOT_FOLDER_ID).append(" cannot be found").toString(), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    @Timed
    public Folder findViewableFoldersById(String folderId, Integer depth, boolean enforcePermission) {
        return (Folder)this.folders.findViewableFoldersById(folderId, depth, enforcePermission).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(22).append("Could not find Folder ").append(folderId).toString(), new Object[0]);
        });
    }

    public Integer findViewableFoldersById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    public boolean findViewableFoldersById$default$3() {
        return true;
    }

    @Timed
    public Folder findByPath(String path, int depth) {
        return this.folders.findByPath(path, depth);
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public java.util.List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions, boolean enforcePermission) {
        block0: {
            if (!enforcePermission) break block0;
            this.permissions.checkViewFolder(parentId);
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folders.listViewableFolders(parentId, page, decorateWithPermissions, enforcePermission)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public boolean listViewableFolders$default$4() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public java.util.List<Release> searchTemplates(String folderId, Page page, boolean enforcePermission) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth(), enforcePermission).getReleases();
    }

    public boolean searchTemplates$default$3() {
        return true;
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringBuilder(1).append(folderId).append("/").append(Ids.getName((String)templateId)).toString();
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(61).append("Attempted to move template ").append(templateId).append(" to same folder ").append(folderId).append(". Will be ignored.").toString());
            string = templateId;
        } else {
            scala.collection.immutable.Seq templateTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getStoredTeams(templateId)).asScala().toSeq();
            this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateMovingAction(templateId, folderId));
            this.releaseRepository.move(templateId, newTemplateId);
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (scala.collection.immutable.Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        FolderAndEvents result = this.createWithoutPublishing(parentId, folder, createDefaultTeams);
        result.events().foreach((Function1 & Serializable)event -> {
            this.eventBus.publish(event);
            return BoxedUnit.UNIT;
        });
        return result.folder();
    }

    /*
     * Enabled aggressive block sorting
     */
    public FolderAndEvents createWithoutPublishing(String parentId, Folder folder, boolean createDefaultTeams) {
        Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
        this.checkFolderExists(parentId);
        this.folders.checkNameIsUnique(parentId, folder.getTitle());
        if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
            folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
        } else {
            folder.setId(new StringBuilder(1).append(parentId).append("/").append(Ids.getName((String)folder.getId())).toString());
        }
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(25).append("Creating folder ").append(folder.getTitle()).append(" with id ").append(folder.getId()).toString());
        Folder saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
        scala.collection.immutable.Seq events = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FolderCreatedEvent[]{new FolderCreatedEvent(folder)}));
        if (createDefaultTeams) {
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                events = (scala.collection.immutable.Seq)events.$plus$plus(this.createDefaultTeamsForTheFolder(saved, parentId));
                return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
            }
        }
        events = (scala.collection.immutable.Seq)events.$colon$plus((Object)new TeamsUpdatedEvent(folder.getId()));
        return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(16).append("Deleting folder ").append(folderId).toString());
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(41).append("archiveOrDelete(").append(folderUid).append(", ").append(releaseId).append("): status=").append(status).append(" [inactive? ").append(status.isInactive()).append("]").toString());
        if (this.releaseRepository.getStatus(releaseId).isInactive()) {
            if (!this.archivingService.existsPreArchived(releaseId)) {
                Release release = this.releaseRepository.findById(releaseId);
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(16).append("release loaded: ").append(release).toString());
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(16).append("archiveRelease(").append(releaseId).append(")").toString());
            this.archivingService.archiveRelease(releaseId);
        } else {
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(15).append("deleteRelease(").append(releaseId).append(")").toString());
            this.releaseRepository.delete(releaseId, this.releaseRepository.delete$default$2());
        }
    }

    private void mergeTeams(String folderId, String templateId, scala.collection.immutable.Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            scala.collection.immutable.Seq folderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(folderId)).asScala().toSeq();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable)() -> folderId);
            scala.collection.immutable.Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((scala.collection.immutable.Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, CollectionConverters$.MODULE$.SeqHasAsJava(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private scala.collection.immutable.Seq<Team> mergeTemplateAndFolderTeams(scala.collection.immutable.Seq<Team> folderTeams, scala.collection.immutable.Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((IterableOnceOps)folderTeams.map((Function1 & Serializable)team -> new Tuple2((Object)team.getTeamName(), team))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).toSeq());
        templateTeams.foreach((Function1 & Serializable)templateTeam -> {
            Growable growable;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                growable = folderTeamsMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getMembers()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getMembers()).asScala().toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getRoles()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getRoles()).asScala().toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getPermissions()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getPermissions()).asScala().toSet());
                folderTeam.setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)memberSet.toSeq()).asJava());
                folderTeam.setRoles(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)roleSet.toSeq()).asJava());
                folderTeam.setPermissions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)permissionSet.toSeq()).asJava());
                growable = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return growable;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
    }

    private List<XLReleaseEvent> createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getFolderPermissions()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_TRIGGER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        Buffer releaseAdminPermissions = (Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getReleasePermissions()).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getTriggerPermissions()).asScala())).concat((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{XLReleasePermissions.VIEW_FOLDER.getPermissionName()})));
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.addPermissions((String[])releaseAdminPermissions.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        Tuple2<java.util.List<Team>, java.util.List<XLReleaseEvent>> result = this.teamService.saveTeamsToPlatformWithoutPublishing(folder.getId(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava(), true);
        return CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)result._2()).asScala().toList();
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        Buffer releases = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, newfolderId, folderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        scala.collection.immutable.Seq<Release> activeReleases = this.getRunningReleases(folderId);
        scala.collection.immutable.Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Tried to ").append(operation).append(" folder ").append(folderId).append(", which has active releases ").append(((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$2 -> x$2.getId())).mkString(", ")).toString()).append(new StringBuilder(53).append(" or pending releases with auto start option enabled: ").append(((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$3 -> x$3.getId())).mkString(", ")).toString()).toString());
            String details = this.createDetails(activeReleases, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException(new StringBuilder(62).append("You cannot ").append(operation).append(" this folder. The folder or its subfolders contain ").append(details).toString(), new Object[0]);
        }
    }

    private String createDetails(scala.collection.immutable.Seq<Release> activeReleases, scala.collection.immutable.Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        String details;
        block2: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(17).append("active releases: ").append(((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$4 -> x$4.getTitle())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = new StringBuilder(0).append(details).append(new StringBuilder(34).append("pending releases with auto start: ").append(((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$5 -> x$5.getTitle())).mkString("\"", "\", \"", "\"")).toString()).toString();
            }
            if (!invalidRefs.nonEmpty()) break block2;
            details = new StringBuilder(0).append(details).append(new StringBuilder(66).append("configuration references not inherited by the destination folder: ").append(((IterableOnceOps)invalidRefs.map((Function1 & Serializable)x$6 -> x$6.getTitle())).mkString("\"", "\", \"", "\"")).toString()).toString();
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$1(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).forall((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$3(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private scala.collection.immutable.Seq<Release> getRunningReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala().toSeq();
    }

    private scala.collection.immutable.Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$4 = true;
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$6 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$5, x$6, true))).asScala().toSeq();
    }

    private final void FolderAndEvents$lzycompute$1() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (this.FolderAndEvents$module == null) {
                this.FolderAndEvents$module = new FolderService$FolderAndEvents$(this);
            }
        }
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String newfolderId$1, String folderId$7, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).foreach((Function1 & Serializable)c -> c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$7) ? BoxesRunTime.boxToBoolean((boolean)res$1.add(c)) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$1(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$3(String folderId$9, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$9.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
    }

    public class FolderAndEvents
    implements Product,
    Serializable {
        private final Folder folder;
        private final scala.collection.immutable.Seq<XLReleaseEvent> events;
        public final /* synthetic */ FolderService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Folder folder() {
            return this.folder;
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> events() {
            return this.events;
        }

        public FolderAndEvents copy(Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            return new FolderAndEvents(this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer(), folder, events);
        }

        public Folder copy$default$1() {
            return this.folder();
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> copy$default$2() {
            return this.events();
        }

        public String productPrefix() {
            return "FolderAndEvents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.folder();
                    break;
                }
                case 1: {
                    object = this.events();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FolderAndEvents;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "folder";
                    break;
                }
                case 1: {
                    string = "events";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FolderAndEvents)) return false;
            if (((FolderAndEvents)object).com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() != this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FolderAndEvents folderAndEvents = (FolderAndEvents)x$1;
            Folder folder = this.folder();
            Folder folder2 = folderAndEvents.folder();
            if (folder == null) {
                if (folder2 != null) {
                    return false;
                }
            } else if (!folder.equals(folder2)) return false;
            scala.collection.immutable.Seq<XLReleaseEvent> seq = this.events();
            scala.collection.immutable.Seq<XLReleaseEvent> seq2 = folderAndEvents.events();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!folderAndEvents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FolderService com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() {
            return this.$outer;
        }

        public FolderAndEvents(FolderService $outer, Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            this.folder = folder;
            this.events = events;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

