/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.server.jetty.JettyServer;
import com.xebialabs.xlrelease.server.jetty.JettyServerListener;
import com.xebialabs.xlrelease.server.jetty.ReleaseJettyServletWebServerFactory;
import com.xebialabs.xlrelease.server.jetty.ShutdownEventListener;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CustomJettyConfiguration {
    @Bean
    public JettyServer jettyServer(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        return new JettyServer(serverConfiguration, xlrConfig);
    }

    @Bean
    public JettyServletWebServerFactory JettyServletWebServerFactory(ObjectProvider<JettyServerCustomizer> jettyServerCustomizers, ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer) {
        ReleaseJettyServletWebServerFactory factory = new ReleaseJettyServletWebServerFactory(serverConfiguration, xlrConfig, permissionEnforcer);
        factory.getServerCustomizers().addAll(jettyServerCustomizers.orderedStream().collect(Collectors.toList()));
        return factory;
    }

    @Bean
    public JettyServerListener jettyServerListener(ServerConfiguration serverConfiguration) {
        return new JettyServerListener(serverConfiguration);
    }

    @Bean
    public ShutdownEventListener shutdownEventListener(ApplicationContext applicationContext) {
        return new ShutdownEventListener(applicationContext);
    }
}

