/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.utils;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class AccountIdHelper {
    public static String generateAccountId(String licensedName, String serverUrl) {
        if (licensedName == null) {
            licensedName = "";
        }
        if (serverUrl == null) {
            serverUrl = "";
        }
        String accountName = AccountIdHelper.camelCaseString(StringUtils.stripAccents((String)licensedName).replaceAll("[^a-zA-Z0-9]", " ").replaceAll("(\\d)([A-Za-z])", "$1 $2"));
        String accountEnvironment = DigestUtils.md5Hex((String)serverUrl).substring(0, 6);
        return accountName + "_" + accountEnvironment;
    }

    private static String camelCaseString(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        value = value.toLowerCase().stripLeading();
        int valueLen = value.length();
        int[] charPoints = new int[valueLen];
        int outOffset = 0;
        Integer delimiter = Character.codePointAt(new char[]{' '}, 0);
        boolean capitalizeNext = true;
        int index = 0;
        while (index < valueLen) {
            int codePoint = value.codePointAt(index);
            if (delimiter == codePoint) {
                capitalizeNext = outOffset != 0;
                index += Character.charCount(codePoint);
                continue;
            }
            if (capitalizeNext) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                charPoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            charPoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        if (outOffset != 0) {
            return new String(charPoints, 0, outOffset);
        }
        return value;
    }
}

