/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.MaintenanceModeAccessControlFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.ReleaseJettyServletWebServerFactory$;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Uv!\u0002\u0014(\u0011\u0003\u0011d!\u0002\u001b(\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%Ia\u0010\u0005\u0007\u0011\u0006\u0001\u000b\u0011\u0002!\t\u000f%\u000b!\u0019!C\u0005\u007f!1!*\u0001Q\u0001\n\u0001CqaS\u0001C\u0002\u0013%q\b\u0003\u0004M\u0003\u0001\u0006I\u0001\u0011\u0005\b\u001b\u0006\u0011\r\u0011\"\u0003@\u0011\u0019q\u0015\u0001)A\u0005\u0001\u001a!Ag\n\u0001P\u0011!y6B!b\u0001\n\u0003\u0001\u0007\u0002C4\f\u0005\u0003\u0005\u000b\u0011B1\t\u0011!\\!Q1A\u0005\u0002%D\u0001\u0002]\u0006\u0003\u0002\u0003\u0006IA\u001b\u0005\tc.\u0011)\u0019!C\u0001e\"A\u0011p\u0003B\u0001B\u0003%1\u000fC\u0003=\u0017\u0011\u0005!\u0010\u0003\u0004\u0000\u0017\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u0013YA\u0011KA\u0006\u0011\u001d\tIc\u0003C\u0005\u0003WAq!a\f\f\t\u0013\t\t\u0004C\u0004\u00026-!I!a\u000e\t\u000f\u0005m2\u0002\"\u0003\u0002>!9\u0011\u0011I\u0006\u0005\n\u0005\r\u0003bBA$\u0017\u0011%\u0011\u0011\n\u0005\b\u0003\u001bZA\u0011BA(\u0011\u001d\t\u0019f\u0003C\u0005\u0003+Bq!!\u0017\f\t\u0013\tY\u0006C\u0004\u0002`-!I!!\u0019\t\u000f\u0005\u00154\u0002\"\u0003\u0002h!9\u00111N\u0006\u0005\n\u00055\u0004bBA9\u0017\u0011%\u00111\u000f\u0005\b\u0003oZA\u0011BA=\u0011\u001d\tIi\u0003C\u0005\u0003\u0017Cq!a$\f\t\u0013\t\t\nC\u0004\u00020.!I!!-\u0002GI+G.Z1tK*+G\u000f^=TKJ4H.\u001a;XK\n\u001cVM\u001d<fe\u001a\u000b7\r^8ss*\u0011\u0001&K\u0001\u0006U\u0016$H/\u001f\u0006\u0003U-\naa]3sm\u0016\u0014(B\u0001\u0017.\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002/_\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002a\u0005\u00191m\\7\u0004\u0001A\u00111'A\u0007\u0002O\t\u0019#+\u001a7fCN,'*\u001a;usN+'O\u001e7fi^+'mU3sm\u0016\u0014h)Y2u_JL8CA\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AM\u0001\u0012\u0017\u0016K6\u000bV(S\u000b~\u0003&k\u0014)F%RKV#\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001\u00027b]\u001eT\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H\u0005\n11\u000b\u001e:j]\u001e\f!cS#Z'R{%+R0Q%>\u0003VI\u0015+ZA\u0005Q2*R-T)>\u0013Vi\u0018)B'N;vJ\u0015#`!J{\u0005+\u0012*U3\u0006Y2*R-T)>\u0013Vi\u0018)B'N;vJ\u0015#`!J{\u0005+\u0012*U3\u0002\n1\u0003\u0016*V'R\u001bFk\u0014*F?B\u0013v\nU#S)f\u000bA\u0003\u0016*V'R\u001bFk\u0014*F?B\u0013v\nU#S)f\u0003\u0013\u0001\b+S+N#6\u000bV(S\u000b~\u0003\u0016iU*X\u001fJ#u\f\u0015*P!\u0016\u0013F+W\u0001\u001e)J+6\u000bV*U\u001fJ+u\fU!T'^{%\u000bR0Q%>\u0003VI\u0015+ZAM\u00111\u0002\u0015\t\u0003#vk\u0011A\u0015\u0006\u0003QMS!\u0001V+\u0002\u0011\u0015l'-\u001a3eK\u0012T!AV,\u0002\u0007],'M\u0003\u0002Y3\u0006!!m\\8u\u0015\tQ6,A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005a\u0016aA8sO&\u0011aL\u0015\u0002\u001d\u0015\u0016$H/_*feZdW\r^,fEN+'O^3s\r\u0006\u001cGo\u001c:z\u0003M\u0019XM\u001d<fe\u000e{gNZ5hkJ\fG/[8o+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013.\u0003!!W\r\u001d7ps&$\u0018B\u00014d\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003Q\u0019XM\u001d<fe\u000e{gNZ5hkJ\fG/[8oA\u0005I\u0001\u0010\u001c:D_:4\u0017nZ\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011QnK\u0001\u0007G>tg-[4\n\u0005=d'!\u0003-me\u000e{gNZ5h\u0003)AHN]\"p]\u001aLw\rI\u0001\u0013a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/F\u0001t!\t!x/D\u0001v\u0015\t18-\u0001\u0005tK\u000e,(/\u001b;z\u0013\tAXO\u0001\nQKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\u0018a\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ\u0004C\u0003B>}{z\u0004\"aM\u0006\t\u000b}\u0013\u0002\u0019A1\t\u000b!\u0014\u0002\u0019\u00016\t\u000bE\u0014\u0002\u0019A:\u00021%\u001c(+Z4jgR,'\u000fR3gCVdGoU3sm2,G\u000f\u0006\u0002\u0002\u0004A\u0019q'!\u0002\n\u0007\u0005\u001d\u0001HA\u0004C_>dW-\u00198\u00021A|7\u000f\u001e)s_\u000e,7o],fE\u0006\u0003\boQ8oi\u0016DH\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\u001c\u0002\u0010%\u0019\u0011\u0011\u0003\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+!\u0002\u0019AA\f\u0003-\u0019wN\u001c;fqR\u0014vn\u001c;\u0011\t\u0005e\u0011QE\u0007\u0003\u00037QA!!\b\u0002 \u00051q/\u001a2baBT1\u0001KA\u0011\u0015\r\t\u0019cW\u0001\bK\u000ed\u0017\u000e]:f\u0013\u0011\t9#a\u0007\u0003\u001b]+'-\u00119q\u0007>tG/\u001a=u\u0003)\u0019X\r^;q\u0015\u0016$H/\u001f\u000b\u0005\u0003\u001b\ti\u0003C\u0004\u0002\u0016U\u0001\r!a\u0006\u0002%M,G/\u001e9M_\u001e\u0014\u0017mY6GS2$XM\u001d\u000b\u0005\u0003\u001b\t\u0019\u0004C\u0004\u0002\u0016Y\u0001\r!a\u0006\u0002\u0017M,G/\u001e9TaJLgn\u001a\u000b\u0005\u0003\u001b\tI\u0004C\u0004\u0002\u0016]\u0001\r!a\u0006\u0002\u001dM,G/\u001e9BG\u000e,7o\u001d'pOR!\u0011QBA \u0011\u001d\t)\u0002\u0007a\u0001\u0003/\tqb]3ukB\u001cuN]:GS2$XM\u001d\u000b\u0005\u0003\u001b\t)\u0005C\u0004\u0002\u0016e\u0001\r!a\u0006\u0002;M,G/\u001e9YgN\u001cVmY;sSRL\b*Z1eKJ\u001ch)\u001b7uKJ$B!!\u0004\u0002L!9\u0011Q\u0003\u000eA\u0002\u0005]\u0011AD:fiV\u0004XK\u001d7GS2$XM\u001d\u000b\u0005\u0003\u001b\t\t\u0006C\u0004\u0002\u0016m\u0001\r!a\u0006\u0002'M,G/\u001e9TY><Hm\\<o\r&dG/\u001a:\u0015\t\u00055\u0011q\u000b\u0005\b\u0003+a\u0002\u0019AA\f\u0003E\u0019X\r^;q\u000bb$XM\\:j_:\f\u0005/\u001b\u000b\u0005\u0003\u001b\ti\u0006C\u0004\u0002\u0016u\u0001\r!a\u0006\u0002)M,G/\u001e9WKJ\u001c\u0018n\u001c8F]\u001a|'oY3s)\u0011\ti!a\u0019\t\u000f\u0005Ua\u00041\u0001\u0002\u0018\u0005\t2/\u001a;vaJ+\u0017/^3ti2{7-\u00197\u0015\t\u00055\u0011\u0011\u000e\u0005\b\u0003+y\u0002\u0019AA\f\u0003Q)g.\u00192mKJ+7o\\;sG\u0016\u001c8)Y2iKR!\u0011QBA8\u0011\u001d\t)\u0002\ta\u0001\u0003/\t\u0011#\u001a8bE2,wI_5q\u0011\u0006tG\r\\3s)\u0011\ti!!\u001e\t\u000f\u0005U\u0011\u00051\u0001\u0002\u0018\u0005\tb.Z<TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u000bk!!a \u000b\t\u0005\u0005\u00151Q\u0001\bg\u0016\u001c8/[8o\u0015\rQ\u0013qD\u0005\u0005\u0003\u000f\u000byH\u0001\bTKN\u001c\u0018n\u001c8IC:$G.\u001a:\u00023\u0015t\u0017M\u00197f\u0013:\u001cHO];nK:$X\r\u001a%b]\u0012dWM\u001d\u000b\u0005\u0003\u001b\ti\tC\u0004\u0002\u0016\r\u0002\r!a\u0006\u0002#M,G\u000f\u0015:pa\u0016\u0014H/_%g\u001dVdG\u000e\u0006\u0004\u0002\u000e\u0005M\u00151\u0016\u0005\b\u0003+#\u0003\u0019AAL\u0003\rYW-\u001f\t\u0005\u00033\u000b9K\u0004\u0003\u0002\u001c\u0006\r\u0006cAAOq5\u0011\u0011q\u0014\u0006\u0004\u0003C\u000b\u0014A\u0002\u001fs_>$h(C\u0002\u0002&b\na\u0001\u0015:fI\u00164\u0017bA$\u0002**\u0019\u0011Q\u0015\u001d\t\u000f\u00055F\u00051\u0001\u0002\u0018\u0006)a/\u00197vK\u000693/\u001a;va6\u000b\u0017N\u001c;f]\u0006t7-Z'pI\u0016\f5mY3tg\u000e{g\u000e\u001e:pY\u001aKG\u000e^3s)\u0011\ti!a-\t\u000f\u0005UQ\u00051\u0001\u0002\u0018\u0001")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupMaintenanceModeAccessControlFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        block2: {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setShowStacks(false);
            errorHandler.setShowServlet(false);
            contextRoot.setSessionHandler(this.newSessionHandler());
            contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
            contextRoot.setErrorHandler(errorHandler);
            if (this.xlrConfig().metrics().enabled()) {
                this.enableInstrumentedHandler(contextRoot);
            }
            if (this.xlrConfig().server_http_gzip_enabled()) {
                this.enableGzipHandler(contextRoot);
            }
            if (!this.xlrConfig().server_http_cache_enabled() || !Environment.isProduction()) break block2;
            this.enableResourcesCache(contextRoot);
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setResourceBase(".");
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
        }
        contextRoot.getInitParams().put("resteasy.scan.resources", "true");
        contextRoot.getInitParams().put("resteasy.scan.providers", "true");
        contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().api_corsEnabled()) break block0;
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        block0: {
            long slowDownInMs;
            if (!Environment.isDevelopment() || (slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis()) <= 0L) break block0;
            this.logger.warn((Object)new StringBuilder(48).append("Configuring slow down filter with ").append(slowDownInMs).append(" milliseconds.").toString());
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        block0: {
            if (Environment.isDevelopment()) break block0;
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.xlrConfig().server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    /*
     * WARNING - void declaration
     */
    private SessionHandler newSessionHandler() {
        void var1_1;
        block0: {
            SessionHandler sessionHandler = new SessionHandler();
            sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
            sessionHandler.setHttpOnly(true);
            if (this.serverConfiguration().isSsl()) break block0;
            this.logger.debug((Object)new StringBuilder(38).append("Setting up Secure Cookie Enabled to - ").append(this.serverConfiguration().isSecureCookieEnabled()).toString());
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        return var1_1;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        block1: {
            block2: {
                if (value == null) break block1;
                if (System.getProperty(key) != null) break block2;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)new StringBuilder(26).append("Setting system property - ").append(key).toString());
                }
                System.setProperty(key, value);
                break block1;
            }
            if (!this.logger.isDebugEnabled()) break block1;
            this.logger.debug((Object)new StringBuilder(51).append("Not overriding already specified system property - ").append(key).toString());
        }
    }

    private void setupMaintenanceModeAccessControlFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().maintenanceModeEnabled()) break block0;
            boolean restrictApiAccess = this.xlrConfig().maintenanceModeRestrictApiAccess();
            FilterHolder filterHolder = new FilterHolder((Filter)new MaintenanceModeAccessControlFilter(this.permissionEnforcer(), restrictApiAccess));
            contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
    }
}

