/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import java.util.Collection;
import java.util.Collections;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class PersonalAuthenticationToken
extends AbstractAuthenticationToken {
    private final String principal;
    private String token;

    public PersonalAuthenticationToken(String token) {
        super(Collections.emptyList());
        Assert.hasText((String)token, (String)"token cannot be empty");
        this.principal = null;
        this.token = token;
        this.setAuthenticated(false);
    }

    public PersonalAuthenticationToken(String principal, String token, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.token = token;
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.token;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.token = null;
    }
}

