/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import java.io.IOException;
import java.util.Date;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Provider
@Component
public class IOExceptionMapper
implements ExceptionMapper<IOException> {
    public Response toResponse(IOException exception) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain");
        builder.header("X-Exception-Type", (Object)exception.getClass().getName());
        builder.header("X-Path", PathInterceptor.PATH.get());
        builder.header("Date", (Object)new Date());
        builder.entity((Object)Sanitizer.sanitize((String)this.rootCause(exception)));
        return builder.build();
    }

    private String rootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable.getMessage();
    }
}

