/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.Address;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.scheduler.Backpressure;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobQueueStopped;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\f\u0019\u0001\u0005B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b=\u0003A\u0011\u0001)\t\u000fU\u0003!\u0019!C\u0005-\"1A\r\u0001Q\u0001\n]Cq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004n\u0001\u0001\u0006Ia\u001a\u0005\u0006]\u0002!\te\u001c\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0004\u0001\t\u0003\t\t\u0002\u0003\u0004\u0002\u001a\u0001!\tA\u0016\u0005\b\u00037\u0001AQIA\u000f\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005u\u0002\u0001\"\u0011\u0002<!9\u0011q\b\u0001\u0005B\u0005\u0005#a\u0004#fM\u0006,H\u000e\u001e&pEF+X-^3\u000b\u0005eQ\u0012!C:dQ\u0016$W\u000f\\3s\u0015\tYB$A\u0005yYJ,G.Z1tK*\u0011QDH\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aH\u0001\u0004G>l7\u0001A\n\u0006\u0001\tBC\u0006\u000e\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%RS\"\u0001\r\n\u0005-B\"\u0001\u0003&pEF+X-^3\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:mMRR'\"A\u0019\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\r\u0018\u0003\u000f1{wmZ5oOB\u0011\u0011&N\u0005\u0003ma\u0011aAT8eK&#\u0017!\u00046pEJ+\u0007o\\:ji>\u0014\u00180F\u0001:!\tQT(D\u0001<\u0015\ta\u0004$\u0001\u0006sKB|7/\u001b;pefL!AP\u001e\u0003\u001b){'MU3q_NLGo\u001c:z\u00039QwN\u0019*fa>\u001c\u0018\u000e^8ss\u0002\nABY1dWB\u0014Xm]:ve\u0016,\u0012A\u0011\t\u0003S\rK!\u0001\u0012\r\u0003\u0019\t\u000b7m\u001b9sKN\u001cXO]3\u0002\u001b\t\f7m\u001b9sKN\u001cXO]3!\u0003E\t7\r^8s'f\u001cH/Z7I_2$WM]\u000b\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\u00111JG\u0001\u0007C\u000e$xN]:\n\u00055S%!E!di>\u00148+_:uK6Du\u000e\u001c3fe\u0006\u0011\u0012m\u0019;peNK8\u000f^3n\u0011>dG-\u001a:!\u0003\u0019a\u0014N\\5u}Q!\u0011KU*U!\tI\u0003\u0001C\u00038\u000f\u0001\u0007\u0011\bC\u0003A\u000f\u0001\u0007!\tC\u0003G\u000f\u0001\u0007\u0001*\u0001\u0006`Y>\u001c\u0017\r\u001c&pEN,\u0012a\u0016\t\u00041~\u000bW\"A-\u000b\u0005i[\u0016AC2p]\u000e,(O]3oi*\u0011A,X\u0001\u0005kRLGNC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001L&A\u0003#fY\u0006L\u0018+^3vKB\u0011\u0011FY\u0005\u0003Gb\u00111AS8c\u0003-yFn\\2bY*{'m\u001d\u0011\u0002\u0015}K7OU;o]&tw-F\u0001h!\tA7.D\u0001j\u0015\tQ\u0017,\u0001\u0004bi>l\u0017nY\u0005\u0003Y&\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aC0jgJ+hN\\5oO\u0002\naa];c[&$HC\u00019t!\t\u0019\u0013/\u0003\u0002sI\t!QK\\5u\u0011\u0015!H\u00021\u0001b\u0003\rQwN\u0019\u0015\u0003\u0019Y\u0004\"a\u001e@\u000e\u0003aT!!\u001f>\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002|y\u00069Q.\u001a;sS\u000e\u001c(BA?\u001f\u0003!\u0019w\u000eZ1iC2,\u0017BA@y\u0005\u0015!\u0016.\\3e\u00039\u0019XOY7ji\u0016C\u0018n\u001d;j]\u001e$2\u0001]A\u0003\u0011\u0015!X\u00021\u0001b\u0003\u001d\u0011X\r\u001d7bG\u0016$2\u0001]A\u0006\u0011\u0015!h\u00021\u0001bQ\tqa/A\u0005jgJ+hN\\5oOR\u0011\u00111\u0003\t\u0004G\u0005U\u0011bAA\fI\t9!i\\8mK\u0006t\u0017!\u00037pG\u0006d'j\u001c2t\u0003\r9W\r\u001e\u000b\u0002C\"\u001a\u0011#!\t\u0011\t\u0005\r\u0012qE\u0007\u0003\u0003KQ!!\u001f\u0013\n\t\u0005%\u0012Q\u0005\u0002\bi\u0006LGN]3d\u0003\u0011awnY6\u0015\u0007\u0005\fy\u0003C\u0003u%\u0001\u0007\u0011-\u0001\u0004gS:L7\u000f\u001b\u000b\u0004a\u0006U\u0002\"\u0002;\u0014\u0001\u0004\t\u0007FA\nw\u0003\u0015\u0019H/\u0019:u)\u0005\u0001\u0018\u0001B:u_B\f\u0001bY1oG\u0016d\u0017J\u001a\u000b\u0004a\u0006\r\u0003bBA#-\u0001\u0007\u0011qI\u0001\naJ,G-[2bi\u0016\u0004R!!\u0013\u0002P\u0005l!!a\u0013\u000b\u0007\u000553,\u0001\u0005gk:\u001cG/[8o\u0013\u0011\t\t&a\u0013\u0003\u0013A\u0013X\rZ5dCR,\u0007f\u0002\u0001\u0002V\u0005-\u0014Q\u000e\t\u0005\u0003/\n9'\u0004\u0002\u0002Z)\u0019\u00110a\u0017\u000b\t\u0005u\u0013qL\u0001\bG>tG/\u001a=u\u0015\u0011\t\t'a\u0019\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u001a\u0002\u0007=\u0014x-\u0003\u0003\u0002j\u0005e#!B*d_B,\u0017!\u00039s_bLXj\u001c3fI\t\ty'\u0003\u0003\u0002r\u0005M\u0014\u0001\u0004+B%\u001e+EkX\"M\u0003N\u001b&\u0002BA;\u00033\nqbU2pa\u0016$\u0007K]8ys6{G-\u001a\u0015\u0004\u0001\u0005e\u0004\u0003BA>\u0003\u0003k!!! \u000b\t\u0005}\u0014qL\u0001\u000bgR,'/Z8usB,\u0017\u0002BAB\u0003{\u0012\u0011bQ8na>tWM\u001c;")
public class DefaultJobQueue
implements JobQueue,
Logging,
NodeId {
    private final JobRepository jobRepository;
    private final Backpressure backpressure;
    private final ActorSystemHolder actorSystemHolder;
    private final DelayQueue<Job> _localJobs;
    private final AtomicBoolean _isRunning;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        return !this.bitmap$0 ? this.nodeId$lzycompute() : this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public Backpressure backpressure() {
        return this.backpressure;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private DelayQueue<Job> _localJobs() {
        return this._localJobs;
    }

    private AtomicBoolean _isRunning() {
        return this._isRunning;
    }

    @Override
    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("submitted job ").append(job).toString());
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            JobRow qual$1 = JobRow$.MODULE$.apply(taskJob);
            String x$1 = this.nodeId();
            long x$2 = qual$1.copy$default$1();
            JobType x$3 = qual$1.copy$default$3();
            JobStatus x$4 = qual$1.copy$default$4();
            long x$5 = qual$1.copy$default$5();
            Instant x$6 = qual$1.copy$default$6();
            Instant x$7 = qual$1.copy$default$7();
            Instant x$8 = qual$1.copy$default$8();
            String x$9 = qual$1.copy$default$9();
            Integer x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            taskJob.id_$eq(this.jobRepository().create(qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11)).id());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.localJobs().add(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("submitted existing job ").append(job).toString());
        this.localJobs().add(job);
    }

    @Override
    @Timed
    public void replace(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(13).append("replaced job ").append(job).toString());
        JobRow qual$1 = JobRow$.MODULE$.apply(job);
        String x$1 = this.nodeId();
        long x$2 = qual$1.copy$default$1();
        JobType x$3 = qual$1.copy$default$3();
        JobStatus x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        Instant x$6 = qual$1.copy$default$6();
        Instant x$7 = qual$1.copy$default$7();
        Instant x$8 = qual$1.copy$default$8();
        String x$9 = qual$1.copy$default$9();
        Integer x$10 = qual$1.copy$default$10();
        String x$11 = qual$1.copy$default$11();
        job.id_$eq(this.jobRepository().replace(qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11)).id());
        this.localJobs().add(job);
    }

    public boolean isRunning() {
        return this._isRunning().get();
    }

    public DelayQueue<Job> localJobs() {
        return this._localJobs();
    }

    @Override
    public final Job get() {
        Job job;
        block4: {
            Job job2;
            block6: {
                block5: {
                    Try try_;
                    block7: {
                        Throwable throwable;
                        Job job3;
                        while (true) {
                            if ((job3 = (Job)this.localJobs().take()) instanceof StopWorkerThread) {
                                StopWorkerThread stopWorkerThread;
                                job = stopWorkerThread = (StopWorkerThread)job3;
                                break block4;
                            }
                            this.backpressure().backpressureFn(job3);
                            if (!this.isRunning()) break block5;
                            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.lock(job3));
                            if (try_ instanceof Success) {
                                Success success = (Success)try_;
                                Job reservedJob = (Job)success.value();
                                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(7).append("giving ").append(reservedJob).toString());
                                job2 = reservedJob;
                                break block6;
                            }
                            if (!(try_ instanceof Failure)) break block7;
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            throwable = exception;
                            if (!(throwable instanceof OptimisticLockingFailureException)) break;
                            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(19).append("Unable to lock job ").append(job3).toString());
                        }
                        if (throwable == null) {
                            throw new MatchError((Object)throwable);
                        }
                        Throwable throwable2 = throwable;
                        this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                        FailJob failJob = new FailJob(job3, throwable2);
                        job2 = failJob;
                        break block6;
                    }
                    throw new MatchError((Object)try_);
                }
                throw new JobQueueStopped();
            }
            job = job2;
        }
        return job;
    }

    private Job lock(Job job) {
        job.version_$eq(job.version() + 1L);
        job.status_$eq(JobStatus.RESERVED);
        job.node_$eq(this.nodeId());
        job.startTime_$eq(Instant.now().truncatedTo(ChronoUnit.MILLIS));
        this.jobRepository().updateWithVersionCheck(JobRow$.MODULE$.apply(job));
        return job;
    }

    @Override
    @Timed
    public void finish(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("finishing job ").append(job).toString());
        this.jobRepository().delete(JobRow$.MODULE$.apply(job));
    }

    @Override
    public void start() {
        this.logger().debug((Function0 & Serializable)() -> "starting job queue");
        this._isRunning().set(true);
    }

    @Override
    public void stop() {
        this.logger().debug((Function0 & Serializable)() -> "stopping job queue");
        this._isRunning().set(false);
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.localJobs().removeIf(predicate);
    }

    public DefaultJobQueue(JobRepository jobRepository, Backpressure backpressure, ActorSystemHolder actorSystemHolder) {
        this.jobRepository = jobRepository;
        this.backpressure = backpressure;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        this._localJobs = new DelayQueue();
        this._isRunning = new AtomicBoolean(true);
    }
}

