/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.ReleaseJettyServletWebServerFactory$;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055u!\u0002\u0012$\u0011\u0003qc!\u0002\u0019$\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%Ia\u000f\u0005\u0007\t\u0006\u0001\u000b\u0011\u0002\u001f\t\u000f\u0015\u000b!\u0019!C\u0005w!1a)\u0001Q\u0001\nqBqaR\u0001C\u0002\u0013%1\b\u0003\u0004I\u0003\u0001\u0006I\u0001\u0010\u0005\b\u0013\u0006\u0011\r\u0011\"\u0003<\u0011\u0019Q\u0015\u0001)A\u0005y\u0019!\u0001g\t\u0001L\u0011!Y6B!b\u0001\n\u0003a\u0006\u0002C2\f\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0011\\!Q1A\u0005\u0002\u0015D\u0001\u0002\\\u0006\u0003\u0002\u0003\u0006IA\u001a\u0005\u0006q-!\t!\u001c\u0005\u0006c.!\tE\u001d\u0005\u0006m.!\tf\u001e\u0005\b\u0003\u001bYA\u0011BA\b\u0011\u001d\t\u0019b\u0003C\u0005\u0003+Aq!!\u0007\f\t\u0013\tY\u0002C\u0004\u0002 -!I!!\t\t\u000f\u0005\u00152\u0002\"\u0003\u0002(!9\u00111F\u0006\u0005\n\u00055\u0002bBA\u0019\u0017\u0011%\u00111\u0007\u0005\b\u0003oYA\u0011BA\u001d\u0011\u001d\tid\u0003C\u0005\u0003\u007fAq!a\u0011\f\t\u0013\t)\u0005C\u0004\u0002J-!I!a\u0013\t\u000f\u0005=3\u0002\"\u0003\u0002R!9\u0011QK\u0006\u0005\n\u0005]\u0003bBA4\u0017\u0011%\u0011\u0011\u000e\u0005\b\u0003[ZA\u0011BA8\u0003\r\u0012V\r\\3bg\u0016TU\r\u001e;z'\u0016\u0014h\u000f\\3u/\u0016\u00147+\u001a:wKJ4\u0015m\u0019;pefT!\u0001J\u0013\u0002\u000b),G\u000f^=\u000b\u0005\u0019:\u0013AB:feZ,'O\u0003\u0002)S\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003U-\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00031\n1aY8n\u0007\u0001\u0001\"aL\u0001\u000e\u0003\r\u00121EU3mK\u0006\u001cXMS3uif\u001cVM\u001d<mKR<VMY*feZ,'OR1di>\u0014\u0018p\u0005\u0002\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0018\u0002#-+\u0015l\u0015+P%\u0016{\u0006KU(Q\u000bJ#\u0016,F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u0015;sS:<\u0017AE&F3N#vJU#`!J{\u0005+\u0012*U3\u0002\n!dS#Z'R{%+R0Q\u0003N\u001bvk\u0014*E?B\u0013v\nU#S)f\u000b1dS#Z'R{%+R0Q\u0003N\u001bvk\u0014*E?B\u0013v\nU#S)f\u0003\u0013a\u0005+S+N#6\u000bV(S\u000b~\u0003&k\u0014)F%RK\u0016\u0001\u0006+S+N#6\u000bV(S\u000b~\u0003&k\u0014)F%RK\u0006%\u0001\u000fU%V\u001bFk\u0015+P%\u0016{\u0006+Q*T/>\u0013Fi\u0018)S\u001fB+%\u000bV-\u0002;Q\u0013Vk\u0015+T)>\u0013Vi\u0018)B'N;vJ\u0015#`!J{\u0005+\u0012*U3\u0002\u001a\"a\u0003'\u0011\u00055KV\"\u0001(\u000b\u0005\u0011z%B\u0001)R\u0003!)WNY3eI\u0016$'B\u0001*T\u0003\r9XM\u0019\u0006\u0003)V\u000bAAY8pi*\u0011akV\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001,A\u0002pe\u001eL!A\u0017(\u00039)+G\u000f^=TKJ4H.\u001a;XK\n\u001cVM\u001d<fe\u001a\u000b7\r^8ss\u0006\u00192/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\tQ\f\u0005\u0002_C6\tqL\u0003\u0002aS\u0005AA-\u001a9m_fLG/\u0003\u0002c?\n\u00192+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006!2/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002\n\u0011\u0002\u001f7s\u0007>tg-[4\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!![\u0014\u0002\r\r|gNZ5h\u0013\tY\u0007NA\u0005YYJ\u001cuN\u001c4jO\u0006Q\u0001\u0010\u001c:D_:4\u0017n\u001a\u0011\u0015\u00079|\u0007\u000f\u0005\u00020\u0017!)1\f\u0005a\u0001;\")A\r\u0005a\u0001M\u0006A\u0012n\u001d*fO&\u001cH/\u001a:EK\u001a\fW\u000f\u001c;TKJ4H.\u001a;\u0015\u0003M\u0004\"a\r;\n\u0005U$$a\u0002\"p_2,\u0017M\\\u0001\u0019a>\u001cH\u000f\u0015:pG\u0016\u001c8oV3c\u0003B\u00048i\u001c8uKb$HC\u0001=|!\t\u0019\u00140\u0003\u0002{i\t!QK\\5u\u0011\u0015a(\u00031\u0001~\u0003-\u0019wN\u001c;fqR\u0014vn\u001c;\u0011\u0007y\fI!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\r],'-\u00199q\u0015\r!\u0013Q\u0001\u0006\u0004\u0003\u000f9\u0016aB3dY&\u00048/Z\u0005\u0004\u0003\u0017y(!D,fE\u0006\u0003\boQ8oi\u0016DH/\u0001\u0006tKR,\bOS3uif$2\u0001_A\t\u0011\u0015a8\u00031\u0001~\u0003I\u0019X\r^;q\u0019><'-Y2l\r&dG/\u001a:\u0015\u0007a\f9\u0002C\u0003})\u0001\u0007Q0A\u0006tKR,\bo\u00159sS:<Gc\u0001=\u0002\u001e!)A0\u0006a\u0001{\u0006q1/\u001a;va\u0006\u001b7-Z:t\u0019><Gc\u0001=\u0002$!)AP\u0006a\u0001{\u0006y1/\u001a;va\u000e{'o\u001d$jYR,'\u000fF\u0002y\u0003SAQ\u0001`\fA\u0002u\fQd]3ukBD6o]*fGV\u0014\u0018\u000e^=IK\u0006$WM]:GS2$XM\u001d\u000b\u0004q\u0006=\u0002\"\u0002?\u0019\u0001\u0004i\u0018aE:fiV\u00048\u000b\\8xI><hNR5mi\u0016\u0014Hc\u0001=\u00026!)A0\u0007a\u0001{\u0006\t2/\u001a;va\u0016CH/\u001a8tS>t\u0017\t]5\u0015\u0007a\fY\u0004C\u0003}5\u0001\u0007Q0\u0001\u000btKR,\bOV3sg&|g.\u00128g_J\u001cWM\u001d\u000b\u0004q\u0006\u0005\u0003\"\u0002?\u001c\u0001\u0004i\u0018!E:fiV\u0004(+Z9vKN$Hj\\2bYR\u0019\u00010a\u0012\t\u000bqd\u0002\u0019A?\u0002)\u0015t\u0017M\u00197f%\u0016\u001cx.\u001e:dKN\u001c\u0015m\u00195f)\rA\u0018Q\n\u0005\u0006yv\u0001\r!`\u0001\u0012K:\f'\r\\3Hu&\u0004\b*\u00198eY\u0016\u0014Hc\u0001=\u0002T!)AP\ba\u0001{\u0006\tb.Z<TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005e\u0003\u0003BA.\u0003Gj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\bg\u0016\u001c8/[8o\u0015\r1\u00131A\u0005\u0005\u0003K\niF\u0001\bTKN\u001c\u0018n\u001c8IC:$G.\u001a:\u00023\u0015t\u0017M\u00197f\u0013:\u001cHO];nK:$X\r\u001a%b]\u0012dWM\u001d\u000b\u0004q\u0006-\u0004\"\u0002?!\u0001\u0004i\u0018!E:fiB\u0013x\u000e]3sifLeMT;mYR)\u00010!\u001d\u0002\n\"9\u00111O\u0011A\u0002\u0005U\u0014aA6fsB!\u0011qOAC\u001d\u0011\tI(!!\u0011\u0007\u0005mD'\u0004\u0002\u0002~)\u0019\u0011qP\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\tN\u0001\u0007!J,G-\u001a4\n\u0007\r\u000b9IC\u0002\u0002\u0004RBq!a#\"\u0001\u0004\t)(A\u0003wC2,X\r")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        block2: {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setShowStacks(false);
            errorHandler.setShowServlet(false);
            contextRoot.setSessionHandler(this.newSessionHandler());
            contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
            contextRoot.setErrorHandler(errorHandler);
            if (this.xlrConfig().metrics().enabled()) {
                this.enableInstrumentedHandler(contextRoot);
            }
            if (this.xlrConfig().server_http_gzip_enabled()) {
                this.enableGzipHandler(contextRoot);
            }
            if (!this.xlrConfig().server_http_cache_enabled() || !Environment.isProduction()) break block2;
            this.enableResourcesCache(contextRoot);
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setResourceBase(".");
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
        }
        contextRoot.getInitParams().put("resteasy.scan.resources", "true");
        contextRoot.getInitParams().put("resteasy.scan.providers", "true");
        contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().api_corsEnabled()) break block0;
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        block0: {
            long slowDownInMs;
            if (!Environment.isDevelopment() || (slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis()) <= 0L) break block0;
            this.logger.warn((Object)new StringBuilder(48).append("Configuring slow down filter with ").append(slowDownInMs).append(" milliseconds.").toString());
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        block0: {
            if (Environment.isDevelopment()) break block0;
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.xlrConfig().server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    /*
     * WARNING - void declaration
     */
    private SessionHandler newSessionHandler() {
        void var1_1;
        block0: {
            SessionHandler sessionHandler = new SessionHandler();
            sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
            sessionHandler.setHttpOnly(true);
            if (this.serverConfiguration().isSsl()) break block0;
            this.logger.debug((Object)new StringBuilder(38).append("Setting up Secure Cookie Enabled to - ").append(this.serverConfiguration().isSecureCookieEnabled()).toString());
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        return var1_1;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        block1: {
            block2: {
                if (value == null) break block1;
                if (System.getProperty(key) != null) break block2;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)new StringBuilder(26).append("Setting system property - ").append(key).toString());
                }
                System.setProperty(key, value);
                break block1;
            }
            if (!this.logger.isDebugEnabled()) break block1;
            this.logger.debug((Object)new StringBuilder(51).append("Not overriding already specified system property - ").append(key).toString());
        }
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
    }
}

