/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\u000f\u001f\u0001\u001dB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u001d!\u0007A1A\u0005\n\u0015DaA\u001b\u0001!\u0002\u00131\u0007bB6\u0001\u0005\u0004%I!\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011\u00024\t\u000f5\u0004\u0001\u0019!C\u0005K\"9a\u000e\u0001a\u0001\n\u0013y\u0007BB;\u0001A\u0003&a\rC\u0004w\u0001\u0001\u0007I\u0011B3\t\u000f]\u0004\u0001\u0019!C\u0005q\"1!\u0010\u0001Q!\n\u0019DQa\u001f\u0001\u0005\nqDq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA;\u0001\u0011E\u0011q\u000f\u0005\b\u0003s\u0002A\u0011CA<\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!$\u0001\t\u0003\ty\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\"a\u0011\u0011\u0015\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0002$\"a\u00111\u0017\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u00026\n\u0019\u0003\f\u001c)feNL7\u000f^3oiR{7.\u001a8SK6,WNY3s\u001b\u0016\u001cVM\u001d<jG\u0016\u001c(BA\u0010!\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!!\t\u0012\u0002\u0013ad'/\u001a7fCN,'BA\u0012%\u0003%AXMY5bY\u0006\u00147OC\u0001&\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*k5\t!F\u0003\u0002,Y\u0005Q!/Z7f[\n,'/\\3\u000b\u0005}i#B\u0001\u00180\u0003\r9XM\u0019\u0006\u0003aE\n\u0001b]3dkJLG/\u001f\u0006\u0003eM\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002i\u0005\u0019qN]4\n\u0005YR#AG!cgR\u0014\u0018m\u0019;SK6,WNY3s\u001b\u0016\u001cVM\u001d<jG\u0016\u001c\u0018aA6fsB\u0011\u0011H\u0011\b\u0003u\u0001\u0003\"a\u000f \u000e\u0003qR!!\u0010\u0014\u0002\rq\u0012xn\u001c;?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005s\u0014AE;tKJ$U\r^1jYN\u001cVM\u001d<jG\u0016\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u0017U\u001cXM\u001d3fi\u0006LGn\u001d\u0006\u0003\u0017>\nAaY8sK&\u0011Q\n\u0013\u0002\u0013+N,'\u000fR3uC&d7oU3sm&\u001cW-A\bu_.,gNU3q_NLGo\u001c:z!\t\u00016+D\u0001R\u0015\t\u0011\u0006%\u0001\u0006sKB|7/\u001b;pefL!\u0001V)\u0003?\r+8\u000f^8n!\u0016\u00148/[:uK:$Hk\\6f]J+\u0007o\\:ji>\u0014\u00180A\ntKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002X56\t\u0001L\u0003\u0002ZE\u0005AA-\u001a9m_fLG/\u0003\u0002\\1\n\u00192+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"RA\u00181bE\u000e\u0004\"a\u0018\u0001\u000e\u0003yAQaN\u0003A\u0002aBQ!R\u0003A\u0002\u0019CQAT\u0003A\u0002=CQ!V\u0003A\u0002Y\u000bQ\u0003R#G\u0003VcEkX*F%&+5k\u0018'F\u001d\u001e#\u0006*F\u0001g!\t9\u0007.D\u0001?\u0013\tIgHA\u0002J]R\fa\u0003R#G\u0003VcEkX*F%&+5k\u0018'F\u001d\u001e#\u0006\nI\u0001\u0015\t\u00163\u0015)\u0016'U?R{5*\u0012(`\u0019\u0016su\t\u0016%\u0002+\u0011+e)Q+M)~#vjS#O?2+ej\u0012+IA\u0005a1/\u001a:jKNdUM\\4uQ\u0006\u00012/\u001a:jKNdUM\\4uQ~#S-\u001d\u000b\u0003aN\u0004\"aZ9\n\u0005It$\u0001B+oSRDq\u0001^\u0006\u0002\u0002\u0003\u0007a-A\u0002yIE\nQb]3sS\u0016\u001cH*\u001a8hi\"\u0004\u0013a\u0003;pW\u0016tG*\u001a8hi\"\fq\u0002^8lK:dUM\\4uQ~#S-\u001d\u000b\u0003afDq\u0001\u001e\b\u0002\u0002\u0003\u0007a-\u0001\u0007u_.,g\u000eT3oORD\u0007%\u0001\u0004h_B\u000b7\u000f\u001e\u000b\u0006{\u0006-\u0011q\u0002\t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005kRLGN\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\u0005\t\u0006$X\r\u0003\u0004\u0002\u000eA\u0001\r!`\u0001\nO&4XM\u001c#bi\u0016Dq!!\u0005\u0011\u0001\u0004\t\u0019\"\u0001\u0005uS6,\u0017J\\'t!\r9\u0017QC\u0005\u0004\u0003/q$\u0001\u0002'p]\u001e\f\u0001bZ8GkR,(/\u001a\u000b\u0006{\u0006u\u0011q\u0004\u0005\u0007\u0003\u001b\t\u0002\u0019A?\t\u000f\u0005E\u0011\u00031\u0001\u0002\u0014\u0005qqN\u001c'pO&t7+^2dKN\u001cHc\u00029\u0002&\u0005u\u0012q\t\u0005\b\u0003O\u0011\u0002\u0019AA\u0015\u0003\u001d\u0011X-];fgR\u0004B!a\u000b\u0002:5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0003iiR\u0004(\u0002BA\u001a\u0003k\tqa]3sm2,GO\u0003\u0002\u00028\u0005)!.\u0019<bq&!\u00111HA\u0017\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\t\u000f\u0005}\"\u00031\u0001\u0002B\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002,\u0005\r\u0013\u0002BA#\u0003[\u00111\u0003\u0013;uaN+'O\u001e7fiJ+7\u000f]8og\u0016Dq!!\u0013\u0013\u0001\u0004\tY%\u0001\rtk\u000e\u001cWm]:gk2\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004B!!\u0014\u0002P5\t!*C\u0002\u0002R)\u0013a\"Q;uQ\u0016tG/[2bi&|g.\u0001\fqe>\u001cWm]:BkR|Gj\\4j]\u000e{wn[5f)!\t9&!\u0018\u0002h\u0005%\u0004cA$\u0002Z%\u0019\u00111\f%\u0003\u0017U\u001bXM\u001d#fi\u0006LGn\u001d\u0005\b\u0003?\u001a\u0002\u0019AA1\u00031\u0019wn\\6jKR{7.\u001a8t!\u00119\u00171\r\u001d\n\u0007\u0005\u0015dHA\u0003BeJ\f\u0017\u0010C\u0004\u0002(M\u0001\r!!\u000b\t\u000f\u0005}2\u00031\u0001\u0002B\u00051An\\4pkR$r\u0001]A8\u0003c\n\u0019\bC\u0004\u0002(Q\u0001\r!!\u000b\t\u000f\u0005}B\u00031\u0001\u0002B!1q\u0004\u0006a\u0001\u0003\u0017\n!cZ3oKJ\fG/Z*fe&,7\u000fR1uCV\t\u0001(A\thK:,'/\u0019;f)>\\WM\u001c#bi\u0006\f\u0011\"\u00193e\u0007>|7.[3\u0015\u000fA\fy(!#\u0002\f\"9\u0011\u0011Q\fA\u0002\u0005\r\u0015!\u0002;pW\u0016t\u0007cA\u0015\u0002\u0006&\u0019\u0011q\u0011\u0016\u00033A+'o]5ti\u0016tGOU3nK6\u0014WM]'f)>\\WM\u001c\u0005\b\u0003O9\u0002\u0019AA\u0015\u0011\u001d\tyd\u0006a\u0001\u0003\u0003\nqb]3u'\u0016\u0014\u0018.Z:MK:<G\u000f\u001b\u000b\u0004a\u0006E\u0005\"B7\u0019\u0001\u00041\u0017AD:fiR{7.\u001a8MK:<G\u000f\u001b\u000b\u0004a\u0006]\u0005\"\u0002<\u001a\u0001\u00041\u0017aF:fiR{7.\u001a8WC2LG-\u001b;z'\u0016\u001cwN\u001c3t)\r\u0001\u0018Q\u0014\u0005\u0007\u0003?S\u0002\u0019\u00014\u0002)Q|7.\u001a8WC2LG-\u001b;z'\u0016\u001cwN\u001c3t\u0003]\u0001(o\u001c;fGR,G\rJ4fi\u000e{wn[5f\u001d\u0006lW\r\u0006\u0003\u0002&\u0006EFCAAT!\u0011\tI+a,\u000e\u0005\u0005-&\u0002BAW\u0003\u0007\tA\u0001\\1oO&\u00191)a+\t\u000fQ\\\u0012\u0011!a\u0001=\u00061\u0002O]8uK\u000e$X\r\u001a\u0013eK\u000e|G-Z\"p_.LW\r\u0006\u0003\u00028\u0006}F\u0003BA]\u0003w\u0003RaZA2\u0003OCq!!0\u001d\u0001\u0004\t9+A\u0006d_>\\\u0017.\u001a,bYV,\u0007b\u0002;\u001d\u0003\u0003\u0005\rA\u0018")
public class XlPersistentTokenRememberMeServices
extends AbstractRememberMeServices {
    private final CustomPersistentTokenRepository tokenRepository;
    private final ServerConfiguration serverConfiguration;
    private final int DEFAULT_SERIES_LENGTH;
    private final int DEFAULT_TOKEN_LENGTH;
    private int seriesLength;
    private int tokenLength;

    public /* synthetic */ String protected$getCookieName(XlPersistentTokenRememberMeServices x$1) {
        return x$1.getCookieName();
    }

    public /* synthetic */ String[] protected$decodeCookie(XlPersistentTokenRememberMeServices x$1, String cookieValue) {
        return x$1.decodeCookie(cookieValue);
    }

    private int DEFAULT_SERIES_LENGTH() {
        return this.DEFAULT_SERIES_LENGTH;
    }

    private int DEFAULT_TOKEN_LENGTH() {
        return this.DEFAULT_TOKEN_LENGTH;
    }

    private int seriesLength() {
        return this.seriesLength;
    }

    private void seriesLength_$eq(int x$1) {
        this.seriesLength = x$1;
    }

    private int tokenLength() {
        return this.tokenLength;
    }

    private void tokenLength_$eq(int x$1) {
        this.tokenLength = x$1;
    }

    private Date goPast(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long pastTime = givenTimeInMs - timeInMs;
        return new Date(pastTime);
    }

    private Date goFuture(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long futureTime = givenTimeInMs + timeInMs;
        return new Date(futureTime);
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        block2: {
            if (!this.serverConfiguration.isClientSessionRememberEnabled()) break block2;
            String username = successfulAuthentication.getName();
            this.logger.debug((Object)new StringBuilder(39).append("Creating new persistent login for user ").append(username).toString());
            PersistentRememberMeToken persistentToken = new PersistentRememberMeToken(username.toLowerCase(), this.generateSeriesData(), this.generateTokenData(), new Date());
            try {
                this.tokenRepository.createNewToken(persistentToken);
                this.addCookie(persistentToken, request, response);
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to save persistent token ", (Throwable)e);
            }
        }
    }

    public UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException(new StringBuilder(54).append("Cookie token did not contain ").append(2).append(" tokens, but contained '").append(Arrays.asList((Object[])new String[][]{cookieTokens})).append("'").toString());
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentRememberMeToken token = this.tokenRepository.getTokenForSeries(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException(new StringBuilder(41).append("No persistent token found for series id: ").append(presentedSeries).toString());
        }
        String string = presentedToken;
        String string2 = token.getTokenValue();
        if (string == null ? string2 != null : !string.equals(string2)) {
            List<PersistentRememberMeToken> previousTokenList = this.tokenRepository.getPreviousTokenForSeries(presentedSeries, token.getTokenValue());
            Optional<PersistentRememberMeToken> previousOldToken = previousTokenList.stream().filter(previousToken -> {
                String string = previousToken.getTokenValue();
                String string2 = presentedToken;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).findFirst();
            if (!previousOldToken.isPresent()) {
                this.tokenRepository.removeUserTokens(token.getUsername());
                throw new CookieTheftException(this.messages.getMessage("PersistentTokenBasedRememberMeServices.cookieStolen", "Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack."));
            }
            this.tokenRepository.removeTokenInSeriesBeforeGivenDate(token.getSeries(), this.goPast(previousOldToken.get().getDate(), 60000L));
        }
        if (this.goFuture(token.getDate(), (long)this.getTokenValiditySeconds() * 1000L).getTime() < System.currentTimeMillis()) {
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)new StringBuilder(56).append("Refreshing persistent login token for user '").append(token.getUsername()).append("', series '").append(token.getSeries()).append("'").toString());
        }
        if (!this.serverConfiguration.isClientSessionRememberEnabled()) {
            throw new RememberMeAuthenticationException("Remember-me login is disabled");
        }
        try {
            if (this.goFuture(token.getDate(), 30000L).getTime() < System.currentTimeMillis()) {
                PersistentRememberMeToken newToken = new PersistentRememberMeToken(token.getUsername().toLowerCase(), token.getSeries(), this.generateTokenData(), new Date());
                this.tokenRepository.createNewToken(newToken);
                this.addCookie(newToken, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
        }
        return this.getUserDetailsService().loadUserByUsername(token.getUsername());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        if (authentication != null) {
            this.tokenRepository.removeUserTokens(authentication.getName().toLowerCase());
        } else {
            Option$.MODULE$.apply((Object)request.getCookies()).foreach((Function1 & Serializable)cookies -> {
                XlPersistentTokenRememberMeServices.$anonfun$logout$1(this, cookies);
                return BoxedUnit.UNIT;
            });
        }
        SecurityContextLogoutHandler securityContextLogoutHandler = new SecurityContextLogoutHandler();
        securityContextLogoutHandler.logout(request, response, null);
    }

    public String generateSeriesData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.seriesLength())));
    }

    public String generateTokenData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.tokenLength())));
    }

    private void addCookie(PersistentRememberMeToken token, HttpServletRequest request, HttpServletResponse response) {
        this.setCookie((String[])((Object[])new String[]{token.getSeries(), token.getTokenValue()}), this.getTokenValiditySeconds(), request, response);
    }

    public void setSeriesLength(int seriesLength) {
        this.seriesLength_$eq(seriesLength);
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength_$eq(tokenLength);
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        Assert.isTrue((tokenValiditySeconds > 0 ? 1 : 0) != 0, (String)"tokenValiditySeconds must be positive for this implementation");
        super.setTokenValiditySeconds(tokenValiditySeconds);
    }

    public static final /* synthetic */ boolean $anonfun$logout$2(XlPersistentTokenRememberMeServices $this, Cookie x$1) {
        String string = x$1.getName();
        String string2 = $this.protected$getCookieName($this);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$logout$3(XlPersistentTokenRememberMeServices $this, Cookie c) {
        String[] values = $this.protected$decodeCookie($this, c.getValue());
        ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable)series -> {
            $this.tokenRepository.removeUserTokensBasedOnSeries(series);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logout$1(XlPersistentTokenRememberMeServices $this, Cookie[] cookies) {
        ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])cookies), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XlPersistentTokenRememberMeServices.$anonfun$logout$2($this, x$1))).foreach((Function1 & Serializable)c -> {
            XlPersistentTokenRememberMeServices.$anonfun$logout$3($this, c);
            return BoxedUnit.UNIT;
        });
    }

    public XlPersistentTokenRememberMeServices(String key, UserDetailsService userDetailsService, CustomPersistentTokenRepository tokenRepository, ServerConfiguration serverConfiguration) {
        this.tokenRepository = tokenRepository;
        this.serverConfiguration = serverConfiguration;
        super(key, userDetailsService);
        this.DEFAULT_SERIES_LENGTH = 16;
        this.DEFAULT_TOKEN_LENGTH = 16;
        this.seriesLength = this.DEFAULT_SERIES_LENGTH();
        this.tokenLength = this.DEFAULT_TOKEN_LENGTH();
    }
}

