/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers$PhaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$ReleaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$TaskId$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u0014)\u0001EB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003S\u0011!1\u0006A!b\u0001\n\u00039\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!Q1A\u0005\u0002uC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tE\u0002\u0011)\u0019!C\u0001G\"A!\u000e\u0001B\u0001B\u0003%A\r\u0003\u0005l\u0001\t\u0015\r\u0011\"\u0001m\u0011!\u0001\bA!A!\u0002\u0013i\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011\u0001:\t\u0011Y\u0004!\u0011!Q\u0001\nMD\u0001b\u001e\u0001\u0003\u0006\u0004%\t\u0001\u001f\u0005\ty\u0002\u0011\t\u0011)A\u0005s\")Q\u0010\u0001C\u0001}\"I\u0011q\u0006\u0001C\u0002\u0013\u0005\u0011\u0011\u0007\u0005\t\u00037\u0002\u0001\u0015!\u0003\u00024!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!!4\u0001\t\u0003\ty\rC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9\u00111\u001e\u0001\u0005\u0002\u00055\bbBA{\u0001\u0011%\u0011q\u001f\u0005\n\u0005\u0017\u0001\u0011\u0013!C\u0005\u0005\u001bA\u0011B!\t\u0001#\u0003%IAa\t\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OBqA!!\u0001\t\u0013\u0011\u0019\tC\u0004\u0003\u0014\u0002!\tB!&\t\u000f\te\u0005\u0001\"\u0005\u0003\u001c\n\tB)\u001a9f]\u0012,gnY=TKJ4\u0018nY3\u000b\u0005%R\u0013aB:feZL7-\u001a\u0006\u0003W1\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00055r\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005y\u0013aA2p[\u000e\u00011#\u0002\u00013qqz\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u0002:u5\t\u0001&\u0003\u0002<Q\t\u0011\"+\u001a7fCN,GK]3f\u0005VLG\u000eZ3s!\tIT(\u0003\u0002?Q\taB)\u001a9f]\u0012,gnY=DC:$\u0017\u000eZ1uK\u000e{G\u000e\\3di>\u0014\bC\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0015\u0001C4sSjTH.\u001a3\n\u0005\u0019\u000b%a\u0002'pO\u001eLgnZ\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#A%\u0011\u0005)kU\"A&\u000b\u00051S\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011aj\u0013\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\nAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,W#\u0001*\u0011\u0005e\u001a\u0016B\u0001+)\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0006)\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\u0013A\u00059mC:LE/Z7SKB|7/\u001b;pef,\u0012\u0001\u0017\t\u0003\u0015fK!AW&\u0003%Ac\u0017M\\%uK6\u0014V\r]8tSR|'/_\u0001\u0014a2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0015I\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\u0016\u0003y\u0003\"AS0\n\u0005\u0001\\%\u0001\u0006#fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u00180A\u000beKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\u0011\u0002\u0011\u00154XM\u001c;CkN,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O*\na!\u001a<f]R\u001c\u0018BA5g\u0005!)e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u00039!\u0018m]6SKB|7/\u001b;pef,\u0012!\u001c\t\u0003\u0015:L!a\\&\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l%\u0016\u0004xn]5u_JL\b%A\u0006dS&#7+\u001a:wS\u000e,W#A:\u0011\u0005e\"\u0018BA;)\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,W#A=\u0011\u0005eR\u0018BA>)\u0005A\t%o\u00195jm&twmU3sm&\u001cW-A\tbe\u000eD\u0017N^5oON+'O^5dK\u0002\na\u0001P5oSRtD#E@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010A\u0011\u0011\b\u0001\u0005\u0006\u000fF\u0001\r!\u0013\u0005\u0006!F\u0001\rA\u0015\u0005\u0006-F\u0001\r\u0001\u0017\u0005\u00069F\u0001\rA\u0018\u0005\u0006EF\u0001\r\u0001\u001a\u0005\u0006WF\u0001\r!\u001c\u0005\u0006cF\u0001\ra\u001d\u0005\u0006oF\u0001\r!\u001f\u0015\u0004#\u0005M\u0001\u0003BA\u000b\u0003Wi!!a\u0006\u000b\t\u0005e\u00111D\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u000f\u0003?\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002\"\u0005\r\u0012!\u00022fC:\u001c(\u0002BA\u0013\u0003O\tqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003S\t1a\u001c:h\u0013\u0011\ti#a\u0006\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001G1di&4X\rR3qK:$WM\\2z'R\fG/^:fgV\u0011\u00111\u0007\t\u0007\u0003k\t)%a\u0013\u000f\t\u0005]\u0012\u0011\t\b\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014bAA\"i\u00059\u0001/Y2lC\u001e,\u0017\u0002BA$\u0003\u0013\u00121aU3r\u0015\r\t\u0019\u0005\u000e\t\u0005\u0003\u001b\n)F\u0004\u0003\u0002P\u0005E\u0003cAA\u001di%\u0019\u00111\u000b\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\t9&!\u0017\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u0006N\u0001\u001aC\u000e$\u0018N^3EKB,g\u000eZ3oGf\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003C\ni'a\u001e\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a+\u0003\u0019!w.\\1j]&!\u00111NA3\u0005)!U\r]3oI\u0016t7-\u001f\u0005\b\u0003_\"\u0002\u0019AA9\u0003\u00119\u0017\r^3\u0011\t\u0005\r\u00141O\u0005\u0005\u0003k\n)G\u0001\u0005HCR,G+Y:l\u0011\u001d\tI\b\u0006a\u0001\u0003\u0017\n!\u0003^1sO\u0016$\u0018\nZ(s-\u0006\u0014\u0018.\u00192mK\"\u001aA#! \u0011\t\u0005}\u00141R\u0007\u0003\u0003\u0003SA!!\u0007\u0002\u0004*!\u0011QQAD\u0003\u001diW\r\u001e:jGNT1!!#/\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAG\u0003\u0003\u0013Q\u0001V5nK\u0012\fA\"\u001e9eCR,G+\u0019:hKR$b!!\u0019\u0002\u0014\u0006]\u0005bBAK+\u0001\u0007\u00111J\u0001\rI\u0016\u0004XM\u001c3f]\u000eL\u0018\n\u001a\u0005\b\u0003s*\u0002\u0019AA&Q\r)\u0012QP\u0001\u0007I\u0016dW\r^3\u0015\t\u0005}\u0015Q\u0015\t\u0004g\u0005\u0005\u0016bAARi\t!QK\\5u\u0011\u001d\t9K\u0006a\u0001\u0003\u0017\n!!\u001b3)\u0007Y\ti(A\u000bhKR\u001cu.\u001c9mKR\f'\r\\3HCR,\u0017\nZ:\u0015\t\u0005=\u0016q\u0018\t\u0007\u0003c\u000bY,a\u0013\u000e\u0005\u0005M&\u0002BA[\u0003o\u000bA!\u001e;jY*\u0011\u0011\u0011X\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002>\u0006M&AC\"pY2,7\r^5p]\"9\u0011\u0011Y\fA\u0002\u0005\r\u0017a\u0002;be\u001e,Go\u001d\t\u0007\u0003c\u000bY,!2\u0011\t\u0005\r\u0014qY\u0005\u0005\u0003\u0013\f)G\u0001\u0005QY\u0006t\u0017\n^3nQ\r9\u0012QP\u0001\u001aM&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u0002R\u0006]\u0007CBAY\u0003'\fY%\u0003\u0003\u0002V\u0006M&\u0001\u0002'jgRDq!!7\u0019\u0001\u0004\tY%\u0001\u0005qCJ,g\u000e^%eQ\rA\u0012QP\u0001,M&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7oV5uQ>,H/\u0012=jgR\u001c8\t[3dWR!\u00111GAq\u0011\u001d\tI.\u0007a\u0001\u0003\u0017B3!GA?\u0003m!wNR5oI\u0006\u001bG/\u001b<f\u0013:\u001cw.\\5oO\u001e\u000bG/Z%egR!\u00111GAu\u0011\u001d\tIN\u0007a\u0001\u0003\u0017\n!cZ3u\r\u0006LG.\u00192mK\u001e\u000bG/Z%egR!\u0011qVAx\u0011\u001d\t\tp\u0007a\u0001\u0003\u0007\fa\"\u00192peR,G\rV1sO\u0016$8\u000fK\u0002\u001c\u0003{\nADZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8ds&#7\u000f\u0006\u0005\u00024\u0005e\u0018Q B\u0001\u0011\u001d\tY\u0010\ba\u0001\u0003g\t\u0011\u0002^1sO\u0016$\u0018\nZ:\t\u0013\u0005}H\u0004%AA\u0002\u0005M\u0012\u0001C:uCR,8/Z:\t\u0013\t\rA\u0004%AA\u0002\t\u0015\u0011a\u0005:fM\u0016\u0014XM\\2j]\u001e\u001c\u0005.\u001b7ee\u0016t\u0007cA\u001a\u0003\b%\u0019!\u0011\u0002\u001b\u0003\u000f\t{w\u000e\\3b]\u00061c-\u001b8e\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2z\u0013\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t=!\u0006BA\u001a\u0005#Y#Aa\u0005\u0011\t\tU!QD\u0007\u0003\u0005/QAA!\u0007\u0003\u001c\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033!\u0014\u0002\u0002B\u0010\u0005/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u00192\u0017N\u001c3BY2LenY8nS:<G)\u001a9f]\u0012,gnY=JIN$C-\u001a4bk2$HeM\u000b\u0003\u0005KQCA!\u0002\u0003\u0012\u0005Yb-\u001b8e\u0003\u000e$\u0018N^3PkR<w.\u001b8h)\u0006\u0014x-\u001a;JIN$B!!5\u0003,!9!QF\u0010A\u0002\u0005-\u0013!\u0003:fY\u0016\f7/Z%eQ\ry\u0012QP\u0001\u000fO\u0016$(+\u001a7fCN,GK]3f)\u0011\u0011)D!\u0011\u0011\t\t]\"QH\u0007\u0003\u0005sQ1Aa\u000f+\u0003\u00151\u0018.Z<t\u0013\u0011\u0011yD!\u000f\u0003\u0017I+G.Z1tKR\u0013X-\u001a\u0005\b\u0005[\u0001\u0003\u0019AA&Q\r\u0001\u0013QP\u0001\u001ckB$\u0017\r^3HCR,'+\u001a4fe\u0016t7-\u001b8h!\"\f7/Z:\u0015\r\u0005}%\u0011\nB'\u0011\u001d\u0011Y%\ta\u0001\u0003\u0017\naaZ1uK&#\u0007b\u0002B(C\u0001\u0007!\u0011K\u0001\u0011_JLw-\u001b8U_J+7\u000f^8sK\u0012\u0004\u0002\"!-\u0003T\u0005\u0015\u0017QY\u0005\u0005\u0005+\n\u0019LA\u0002NCBD3!IA?\u0003M\t'o\u00195jm\u0016$U\r]3oI\u0016t7-[3t)\u0019\tyJ!\u0018\u0003`!9!Q\u0006\u0012A\u0002\u0005-\u0003b\u0002B1E\u0001\u0007\u00111G\u0001\u000eI\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:)\u0007\t\ni(\u0001\u0010gS:$G)\u001a9f]\u0012,gnY=UCJ<W\r\u001e\"z)\u0006\u0014x-\u001a;JIV!!\u0011\u000eB8)\u0011\u0011YGa\u001f\u0011\t\t5$q\u000e\u0007\u0001\t\u001d\u0011\th\tb\u0001\u0005g\u0012\u0011\u0001V\t\u0005\u0005k\n)\rE\u00024\u0005oJ1A!\u001f5\u0005\u001dqu\u000e\u001e5j]\u001eDqA! $\u0001\u0004\tY%\u0001\u0005uCJ<W\r^%eQ\r\u0019\u0013QP\u0001\u0011M&tG\r\u00157b]&#X-\u001c\"z\u0013\u0012,BA!\"\u0003\u0010R!!q\u0011BI!\u0015\u0019$\u0011\u0012BG\u0013\r\u0011Y\t\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t5$q\u0012\u0003\b\u0005c\"#\u0019\u0001B:\u0011\u001d\u0011i\b\na\u0001\u0003\u0017\nQDZ5oI&s\u0007K]8he\u0016\u001c8/\u00138d_6LgnZ$bi\u0016LEm\u001d\u000b\u0005\u0003g\u00119\nC\u0004\u0002|\u0016\u0002\r!a\r\u0002\u0015%\u001cH+Z7qY\u0006$X\r\u0006\u0003\u0003\u0006\tu\u0005bBAKM\u0001\u0007\u00111\n\u0015\u0004\u0001\t\u0005\u0006\u0003\u0002BR\u0005Sk!A!*\u000b\t\t\u001d\u00161E\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002BV\u0005K\u0013qaU3sm&\u001cW\r")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String id) {
        Dependency dependency = this.dependencyRepository().findById(id);
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(targets).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable)x$3 -> x$3.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(37).append("getCompletableGateIds doneTargetIds: ").append(doneTargetIds.mkString(", ")).toString());
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            void var2_2;
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(87).append("getCompletableGateIds item ").append(item.getId()).append(": hasConditions = ").append(item.hasConditions()).append(", hasDependencies = ").append(item.hasDependencies()).append(", isOpen = ").append(item.isOpen()).append(", status = ").append(item.getStatus()).toString());
            return var2_2;
        })).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable)x$5 -> x$5.getId())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (this.planItemRepository().exists(parentId)) {
            seq = this.doFindActiveIncomingGateIds(parentId);
        } else {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(89).append("Plan item ").append(parentId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findActiveIncomingGateIdsWithoutExistsCheck(String parentId) {
        return this.doFindActiveIncomingGateIds(parentId);
    }

    private scala.collection.immutable.Seq<String> doFindActiveIncomingGateIds(String parentId) {
        return (scala.collection.immutable.Seq)((SeqOps)((IterableOps)this.findAllIncomingDependencyIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(abortedTargets).asScala().toSeq().map((Function1 & Serializable)x$6 -> x$6.getId())))).asJava();
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds(scala.collection.immutable.Seq<String> targetIds, scala.collection.immutable.Seq<String> statuses, boolean referencingChildren) {
        return (scala.collection.immutable.Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable)x$7 -> x$7.getId());
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds$default$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((SeqOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.dependencyRepository().findByReleaseId(releaseId)).asScala().filter((Function1 & Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable)x$8 -> x$8.getTargetId())).distinct()).asJava();
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$9 -> CollectionConverters$.MODULE$.ListHasAsScala(x$9.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$10 -> {
            x$10.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public <T extends PlanItem> T findDependencyTargetByTargetId(String targetId) {
        Option<String> option;
        Option<String> option2;
        PlanItem planItem;
        Option<String> option3;
        String string = targetId;
        if (string != null && !(option3 = IdMatchers$ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable)() -> this.archivingService().getRelease(targetId));
        } else if (string != null && !(option2 = IdMatchers$PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable)() -> this.archivingService().getPhase(targetId));
        } else if (string != null && !(option = IdMatchers$TaskId$.MODULE$.unapply(string)).isEmpty()) {
            planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable)() -> this.archivingService().getTask(targetId));
        } else {
            throw new TargetIdResolutionFailedException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString());
        }
        return (T)planItem;
    }

    private <T extends PlanItem> Option<T> findPlanItemById(String targetId) {
        Some some;
        try {
            some = new Some(this.planItemRepository().findById(targetId, ResolveOptions$.MODULE$.MINIMAL()));
        }
        catch (NotFoundException notFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.findAllIncomingDependencyIds(targetIds, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }
}

